/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.model.ControlledAnimation;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.IEquippable;
import thebetweenlands.items.misc.ItemGeneric;

public class EntityGiantToad
extends EntityCreature
implements IEntityBL {
    private int temper = 0;
    private int ticksOnGround = 0;
    private int strokeTicks = 0;
    private boolean prevOnGround;
    private ControlledAnimation leapingAnim = new ControlledAnimation(4);
    private ControlledAnimation swimmingAnim = new ControlledAnimation(8);
    private ControlledAnimation waterStanceAnim = new ControlledAnimation(4);
    private List<EntityLivingBase> trackedTargets = new ArrayList<EntityLivingBase>();
    public static final int DW_SWIM_STROKE = 20;
    public static final int DW_TAMED = 21;

    public EntityGiantToad(World worldObj) {
        super(worldObj);
        this.func_70661_as().func_75495_e(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.1));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70105_a(1.6f, 1.5f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Tamed", this.isTamed());
        nbt.func_74768_a("Temper", this.temper);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTamed(nbt.func_74767_n("Tamed"));
        this.temper = nbt.func_74762_e("Temper");
    }

    protected boolean func_70692_ba() {
        return !this.isTamed();
    }

    public boolean isTamed() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_75692_b(21, (Object)(tamed ? (byte)1 : 0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70071_h_() {
        this.prevOnGround = this.field_70122_E;
        if (this.field_70153_n != null) {
            this.field_70121_D.field_72337_e = this.field_70121_D.field_72338_b + (double)this.field_70131_O + (double)this.field_70153_n.field_70131_O - 1.0;
        }
        super.func_70071_h_();
        this.field_70121_D.field_72337_e = this.field_70121_D.field_72338_b + (double)this.field_70131_O;
        this.ticksOnGround = this.field_70122_E ? ++this.ticksOnGround : 0;
        if (!this.field_70170_p.field_72995_K) {
            if (this.strokeTicks > 0) {
                --this.strokeTicks;
                this.field_70180_af.func_75692_b(20, (Object)1);
            } else {
                this.field_70180_af.func_75692_b(20, (Object)0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            this.func_70050_g(20);
            PathEntity path = this.func_70661_as().func_75505_d();
            if (path != null && !path.func_75879_b() && !this.func_70610_aX()) {
                double speedMultiplier;
                float distance;
                float angle;
                float z;
                float x;
                PathPoint nextHopSpot;
                int index;
                if (this.field_70171_ac) {
                    index = path.func_75873_e();
                    if (index < path.func_75874_d()) {
                        nextHopSpot = path.func_75877_a(index);
                        x = (float)((double)nextHopSpot.field_75839_a - this.field_70165_t);
                        z = (float)((double)nextHopSpot.field_75838_c - this.field_70161_v);
                        angle = (float)Math.atan2(z, x);
                        distance = (float)Math.sqrt(x * x + z * z);
                        if (distance > 1.0f) {
                            if (this.strokeTicks == 0) {
                                speedMultiplier = Math.min(distance, 4.0f) / 4.0f * 0.8f + 0.2f;
                                this.field_70159_w += speedMultiplier * (double)0.8f * (double)MathHelper.func_76134_b((float)angle);
                                this.field_70179_y += speedMultiplier * (double)0.8f * (double)MathHelper.func_76126_a((float)angle);
                                this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                                this.strokeTicks = 40;
                            } else if (this.field_70123_F) {
                                this.field_70159_w += 0.01 * (double)MathHelper.func_76134_b((float)angle);
                                this.field_70179_y += 0.01 * (double)MathHelper.func_76126_a((float)angle);
                            }
                        }
                    }
                } else if (this.field_70122_E && (index = path.func_75873_e()) < path.func_75874_d()) {
                    nextHopSpot = path.func_75877_a(index);
                    x = (float)((double)nextHopSpot.field_75839_a - this.field_70165_t);
                    z = (float)((double)nextHopSpot.field_75838_c - this.field_70161_v);
                    angle = (float)Math.atan2(z, x);
                    distance = (float)Math.sqrt(x * x + z * z);
                    if (distance > 1.0f) {
                        if (this.ticksOnGround > 20) {
                            speedMultiplier = Math.min(distance, 2.0f) / 2.0f * 0.8f + 0.2f;
                            this.field_70181_x += speedMultiplier * 0.6;
                            this.field_70159_w += speedMultiplier * 0.5 * (double)MathHelper.func_76134_b((float)angle);
                            this.field_70179_y += speedMultiplier * 0.5 * (double)MathHelper.func_76126_a((float)angle);
                        } else if (this.field_70123_F) {
                            this.field_70159_w += 0.01 * (double)MathHelper.func_76134_b((float)angle);
                            this.field_70179_y += 0.01 * (double)MathHelper.func_76126_a((float)angle);
                        }
                    }
                }
            }
            if (this.field_70153_n != null) {
                float attackDamage;
                EntityDamageSourceIndirect damageSource;
                List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(0.6, 0.6, 0.6));
                EntityLivingBase closestTarget = null;
                float lastAngDiff = 0.0f;
                for (EntityLivingBase target : targets) {
                    float x;
                    float z;
                    float angle;
                    float angDiff;
                    float angDiffWrapped;
                    if (target.func_70643_av() != this.field_70153_n && (!(this.field_70153_n instanceof EntityLivingBase) || ((EntityLivingBase)this.field_70153_n).func_70643_av() != target) || !((angDiffWrapped = Math.min(angDiff = (float)Math.abs((double)(this.field_70177_z % 360.0f) - Math.toDegrees(angle = (float)Math.atan2(z = (float)(target.field_70161_v - this.field_70161_v), x = (float)(target.field_70165_t - this.field_70165_t))) % 360.0 + 90.0) % 360.0f, Math.abs(360.0f - angDiff))) <= 50.0f) || !(angDiffWrapped < lastAngDiff) && closestTarget != null) continue;
                    closestTarget = target;
                    lastAngDiff = angDiffWrapped;
                }
                if (closestTarget != null && closestTarget.func_70097_a((DamageSource)(damageSource = new EntityDamageSourceIndirect("mob", (Entity)this, this.field_70153_n)), attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
                    boolean doesJump = true;
                    if (this.field_70146_Z.nextInt(35) == 0 && closestTarget.func_70652_k((Entity)this)) {
                        doesJump = false;
                    }
                    float x = (float)(closestTarget.field_70165_t - this.field_70165_t);
                    float z = (float)(closestTarget.field_70161_v - this.field_70161_v);
                    if (doesJump && (this.field_70122_E && this.ticksOnGround >= 5 || this.field_70171_ac && this.strokeTicks == 0)) {
                        float angle = (float)Math.atan2(z, x);
                        if (!this.field_70171_ac) {
                            this.field_70181_x += 0.4;
                        }
                        this.field_70159_w += 0.5 * (double)MathHelper.func_76134_b((float)angle);
                        this.field_70179_y += 0.5 * (double)MathHelper.func_76126_a((float)angle);
                        if (this.field_70171_ac) {
                            this.strokeTicks = 20;
                            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                        }
                        this.field_70122_E = false;
                    }
                    closestTarget.func_70653_a((Entity)this, attackDamage, (double)(-x), (double)(-z));
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.waterStanceAnim.updateTimer();
            if (this.field_70171_ac) {
                this.waterStanceAnim.increaseTimer();
            } else {
                this.waterStanceAnim.decreaseTimer();
            }
            this.leapingAnim.updateTimer();
            if (this.field_70171_ac || this.field_70122_E || this.prevOnGround) {
                this.leapingAnim.decreaseTimer();
            } else {
                this.leapingAnim.increaseTimer();
            }
            this.swimmingAnim.updateTimer();
            if (this.field_70180_af.func_75683_a(20) == 1) {
                if (this.strokeTicks < 20) {
                    ++this.strokeTicks;
                }
            } else {
                this.strokeTicks = 0;
            }
            if (this.field_70171_ac && this.field_70180_af.func_75683_a(20) == 1 && this.strokeTicks < 12) {
                this.swimmingAnim.increaseTimer();
            } else {
                this.swimmingAnim.decreaseTimer();
            }
        }
    }

    public float getLeapProgress(float partialRenderTicks) {
        return this.leapingAnim.getAnimationProgressSinSqrt(partialRenderTicks);
    }

    public float getSwimProgress(float partialRenderTicks) {
        return Math.min((1.0f - (float)Math.pow(1.0f - this.swimmingAnim.getAnimationFraction(partialRenderTicks), 2.0)) * 2.5f * this.swimmingAnim.getAnimationFraction(partialRenderTicks), 1.0f);
    }

    public float getWaterStanceProgress(float partialRenderTicks) {
        return this.waterStanceAnim.getAnimationProgressSinSqrt(partialRenderTicks);
    }

    @Override
    public String pageName() {
        return "giantToad";
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:giantToadLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:giantToadHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:giantToadDeath";
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            boolean holdsWings;
            boolean holdsEquipment;
            boolean bl = holdsEquipment = player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b() instanceof IEquippable || player.func_70694_bm().func_77973_b() == BLItemRegistry.amuletSlot);
            if (holdsEquipment) {
                return false;
            }
            boolean bl2 = holdsWings = player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == BLItemRegistry.itemsGeneric && player.func_70694_bm().func_77960_j() == ItemGeneric.EnumItemGeneric.DRAGONFLY_WING.id;
            if (this.field_70153_n == null && this.isTamed() && (!holdsWings || this.func_110143_aJ() >= this.func_110138_aP())) {
                player.func_70078_a((Entity)this);
            } else if (holdsWings) {
                if (!this.isTamed()) {
                    this.temper += this.field_70146_Z.nextInt(4) + 1;
                    if (this.temper >= 30) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.setTamed(true);
                        this.temper = 0;
                    } else {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        --player.func_70694_bm().field_77994_a;
                        if (player.func_70694_bm().field_77994_a <= 0) {
                            player.func_70062_b(0, null);
                        }
                    }
                }
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    this.func_70691_i(4.0f);
                    --player.func_70694_bm().field_77994_a;
                    if (player.func_70694_bm().field_77994_a <= 0) {
                        player.func_70062_b(0, null);
                    }
                }
            }
        }
        return false;
    }

    public boolean func_70104_M() {
        return this.field_70153_n == null;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76346_g();
        return this.field_70153_n != null && this.field_70153_n.equals((Object)entity) ? false : super.func_70097_a(source, damage);
    }

    protected boolean func_70610_aX() {
        return this.field_70153_n != null ? true : super.func_70610_aX();
    }

    public void func_70612_e(float strafing, float forward) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
            this.field_70138_W = 1.0f;
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafing = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            boolean onWaterSurface = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o().func_76224_d();
            if (!this.field_70171_ac || !onWaterSurface) {
                if (this.field_70122_E && forward != 0.0f && !this.field_70170_p.field_72995_K && this.ticksOnGround > 4) {
                    this.field_70181_x += 0.5;
                    this.field_70159_w += (double)(forward / 1.5f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70179_y += (double)(forward / 1.5f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70159_w += (double)(strafing / 2.0f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z))));
                    this.field_70179_y += (double)(strafing / 2.0f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z))));
                }
            } else {
                if (this.field_70181_x < 0.0 && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 0.9)), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o().func_76224_d()) {
                    this.field_70181_x *= (double)0.05f;
                }
                if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.1)), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o().func_76224_d()) {
                    this.field_70181_x += (double)0.02f;
                }
                if (!this.field_70170_p.field_72995_K && this.field_70123_F) {
                    this.field_70181_x += 0.2;
                    this.strokeTicks = 0;
                }
                if (!this.field_70170_p.field_72995_K && forward > 0.0f && forward != 0.0f && this.strokeTicks == 0) {
                    this.field_70159_w += (double)(forward / 1.25f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70179_y += (double)(forward / 1.25f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z + 90.0f))));
                    this.field_70159_w += (double)(strafing / 1.25f * MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z))));
                    this.field_70179_y += (double)(strafing / 1.25f * MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z))));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                    this.strokeTicks = 20;
                }
            }
            if (!this.field_70170_p.field_72995_K && forward > 0.0f) {
                this.field_70159_w += 0.05 * (double)MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z + 90.0f)));
                this.field_70179_y += 0.05 * (double)MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z + 90.0f)));
            }
            super.func_70612_e(0.0f, 0.0f);
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafing, forward);
        }
    }

    public double func_70042_X() {
        return super.func_70042_X();
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnToadParticles(boolean isHeart) {
        String s = isHeart ? "heart" : "smoke";
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte type) {
        if (type == 8) {
            this.strokeTicks = 0;
        }
        if (type == 7) {
            this.spawnToadParticles(true);
        } else if (type == 6) {
            this.spawnToadParticles(false);
            this.field_70170_p.func_72956_a((Entity)this, "eating", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        } else {
            super.func_70103_a(type);
        }
    }
}

