/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.WeedWoodBushUncollidableEntity;
import thebetweenlands.entities.entityAI.EntityAIBLAvoidEntityGecko;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.network.packet.server.PacketWeedWoodBushRustle;

public class EntityGecko
extends EntityCreature
implements IEntityBL,
WeedWoodBushUncollidableEntity {
    private static final int HIDING_ID = 20;
    private static final int MIN_HIDE_TIME = 2400;
    private static final float UNHIDE_CHANCE = 0.1f;
    private static final int PLAYER_MIN_DISTANCE = 7;
    private int hidingBushX;
    private int hidingBushY;
    private int hidingBushZ;
    private int timeHiding;

    public EntityGecko(World worldObj) {
        super(worldObj);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBLAvoidEntityGecko(this, EntityPlayer.class, 7.0f, 0.3, 0.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70105_a(0.75f, 0.35f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
    }

    public void setHidingBush(int x, int y, int z) {
        this.hidingBushX = x;
        this.hidingBushY = y;
        this.hidingBushZ = z;
    }

    public boolean func_82150_aj() {
        return this.isHiding() ? true : super.func_82150_aj();
    }

    private void setHiding(boolean isHiding) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(isHiding ? 1 : 0)));
    }

    public void startHiding() {
        this.setHiding(true);
        this.func_85030_a("thebetweenlands:geckoHide", 0.5f, this.field_70146_Z.nextFloat() * 0.3f + 0.9f);
        this.sendRustleEffect(1.0f);
        this.func_70107_b((double)this.hidingBushX + 0.5, (double)this.hidingBushY + 0.25, (double)this.hidingBushZ + 0.5);
        this.timeHiding = 0;
    }

    public void stopHiding() {
        this.setHiding(false);
        this.func_85030_a("thebetweenlands:geckoHide", 0.25f, this.field_70146_Z.nextFloat() * 0.3f + 0.9f);
        this.timeHiding = 0;
        float x = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
        float y = this.field_70146_Z.nextFloat() * 0.5f;
        float z = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
        float len = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
        float mag = 0.6f;
        this.field_70159_w += (double)(x / len * mag);
        this.field_70181_x += (double)(y / len * mag);
        this.field_70179_y += (double)(z / len * mag);
    }

    private boolean isWeedWoodBushAtHidingSpot() {
        return this.field_70170_p.func_147439_a(this.hidingBushX, this.hidingBushY, this.hidingBushZ) == BLBlockRegistry.weedwoodBush;
    }

    private void sendRustleEffect(float strength) {
        if (!this.isWeedWoodBushAtHidingSpot()) {
            return;
        }
        PacketWeedWoodBushRustle packet = new PacketWeedWoodBushRustle(this.hidingBushX, this.hidingBushY, this.hidingBushZ, strength);
        NetworkRegistry.TargetPoint target = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0);
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(packet), target);
    }

    public boolean isHiding() {
        return this.field_70180_af.func_75683_a(20) != 0;
    }

    public void func_70091_d(double motionX, double motionY, double motionZ) {
        if (!this.isHiding()) {
            super.func_70091_d(motionX, motionY, motionZ);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isHiding()) {
            if (this.isWeedWoodBushAtHidingSpot()) {
                List players;
                ++this.timeHiding;
                if (this.field_70146_Z.nextFloat() < 0.01f) {
                    this.func_85030_a("thebetweenlands:geckoHide", this.field_70146_Z.nextFloat() * 0.05f + 0.02f, this.field_70146_Z.nextFloat() * 0.2f + 0.8f);
                    if (this.field_70146_Z.nextFloat() < 0.3f) {
                        this.sendRustleEffect((this.field_70146_Z.nextFloat() + 0.2f) * 0.06f);
                    }
                }
                if (this.timeHiding > 2400 && (players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(7.0, 7.0, 7.0))).size() < 1 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.stopHiding();
                }
            } else {
                this.stopHiding();
            }
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected float func_70599_aP() {
        return this.isHiding() ? super.func_70599_aP() * 0.1f : super.func_70599_aP();
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:geckoLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:geckoHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:geckoDeath";
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isHiding", this.isHiding());
        if (this.isHiding()) {
            compound.func_74768_a("hidingBushX", this.hidingBushX);
            compound.func_74768_a("hidingBushY", this.hidingBushY);
            compound.func_74768_a("hidingBushZ", this.hidingBushZ);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHiding(compound.func_74767_n("isHiding"));
        if (this.isHiding()) {
            this.setHidingBush(compound.func_74762_e("hidingBushX"), compound.func_74762_e("hidingBushY"), compound.func_74762_e("hidingBushZ"));
        }
    }

    @Override
    public String pageName() {
        return "gecko";
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.isHiding();
    }
}

