/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.entities.particles.EntityGasCloudFX;

public class EntityGasCloud
extends EntityFlying
implements IMob,
IEntityBL {
    public List<Object> gasParticles = new ArrayList<Object>();
    private int courseChangeCooldown;
    private double waypointX;
    private double waypointY;
    private double waypointZ;
    private double aboveLayer = 6.0;
    public static final int GAS_CLOUD_COLOR_DW = 20;

    public EntityGasCloud(World world) {
        super(world);
        this.func_70105_a(1.75f, 1.75f);
        this.field_70145_X = true;
        this.field_70158_ak = true;
    }

    public void setGasColor(int color) {
        this.field_70180_af.func_75692_b(20, (Object)color);
    }

    public int getGasColor() {
        return this.field_70180_af.func_75679_c(20);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)-1435974477);
    }

    protected void func_70626_be() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        super.func_70626_be();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        double dx = this.waypointX - this.field_70165_t;
        double dy = this.waypointY - this.field_70163_u;
        double dz = this.waypointZ - this.field_70161_v;
        double dist = dx * dx + dy * dy + dz * dz;
        if (dist < 1.0 || dist > 3600.0) {
            this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.5f) * 6.0f);
            this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        float speed = 0.02f;
        EntityPlayer closestTarget = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (closestTarget != null) {
            this.waypointX = closestTarget.field_70165_t;
            this.waypointY = closestTarget.field_70163_u;
            this.waypointZ = closestTarget.field_70161_v;
            speed = 0.05f;
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, dist = (double)MathHelper.func_76133_a((double)dist), closestTarget != null)) {
                this.field_70159_w += dx / dist * (double)speed;
                this.field_70181_x += dy / dist * (double)speed;
                this.field_70179_y += dz / dist * (double)speed;
            } else {
                this.waypointX = this.field_70165_t;
                this.waypointY = this.field_70163_u;
                this.waypointZ = this.field_70161_v;
            }
        }
    }

    private boolean isCourseTraversable(double x, double y, double z, double step, boolean canPassSolidBlocks) {
        double dx = (this.waypointX - this.field_70165_t) / step;
        double dy = (this.waypointY - this.field_70163_u) / step;
        double dz = (this.waypointZ - this.field_70161_v) / step;
        int i = 1;
        while ((double)i < step) {
            Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + dx * step)), MathHelper.func_76128_c((double)(this.field_70163_u + dy * step)), MathHelper.func_76128_c((double)(this.field_70161_v + dz * step)));
            if (!canPassSolidBlocks && block.func_149662_c() || block.func_149688_o().func_76224_d()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            EntityGasCloudFX newGasCloud = new EntityGasCloudFX(this.field_70170_p, this.field_70165_t + this.field_70159_w + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f), this.field_70163_u + (double)this.field_70131_O / 2.0 + this.field_70181_x + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f), this.field_70161_v + this.field_70179_y + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f), this.field_70159_w + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f), this.field_70181_x + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f), this.field_70179_y + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f), this.getGasColor());
            this.gasParticles.add((Object)newGasCloud);
            for (int i = 0; i < this.gasParticles.size(); ++i) {
                EntityGasCloudFX gasCloud = (EntityGasCloudFX)((Object)this.gasParticles.get(i));
                gasCloud.func_70071_h_();
                if (!gasCloud.field_70128_L) continue;
                this.gasParticles.remove(i);
            }
        } else if (this.func_70090_H()) {
            this.field_70181_x += 0.01;
            this.waypointX = this.field_70165_t;
            this.waypointY = this.field_70163_u + 0.1;
            this.waypointZ = this.field_70161_v;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(0.5, 0.5, 0.5));
            for (EntityLivingBase target : targets) {
                if (target instanceof EntityGasCloud || target instanceof IEntityBL) continue;
                target.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 60, 0));
                if (target.field_70173_aa % 10 != 0) continue;
                target.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("gasColor", this.getGasColor());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGasColor(nbt.func_74762_e("gasColor"));
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public String pageName() {
        return "gasCloud";
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }
}

