/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;

public class EntityFrog
extends EntityCreature
implements IEntityBL {
    private int ticksOnGround = 0;
    public int jumpAnimationTicks;
    public int prevJumpAnimationTicks;
    private int strokeTicks = 0;
    public static final int DW_SWIM_STROKE = 20;

    public EntityFrog(World world) {
        super(world);
        this.func_70661_as().func_75495_e(true);
        this.func_70661_as().func_75491_a(false);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.1));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70105_a(0.7f, 0.5f);
        this.field_70138_W = 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(30, (Object)new Integer(this.field_70146_Z.nextInt(5)));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public void func_70071_h_() {
        this.prevJumpAnimationTicks = this.jumpAnimationTicks;
        super.func_70071_h_();
        if (this.field_70122_E || this.strokeTicks == 0 && this.func_70090_H()) {
            ++this.ticksOnGround;
            if (this.jumpAnimationTicks > 0) {
                this.jumpAnimationTicks = 0;
            }
        } else {
            this.ticksOnGround = 0;
            ++this.jumpAnimationTicks;
        }
        if (this.strokeTicks > 0) {
            --this.strokeTicks;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.strokeTicks > 0) {
                --this.strokeTicks;
                this.field_70180_af.func_75692_b(20, (Object)1);
            } else {
                this.field_70180_af.func_75692_b(20, (Object)0);
            }
        } else if (this.field_70180_af.func_75683_a(20) == 1) {
            if (this.strokeTicks < 20) {
                ++this.strokeTicks;
            }
        } else {
            this.strokeTicks = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            int index;
            this.func_70050_g(20);
            PathEntity path = this.func_70661_as().func_75505_d();
            if (path != null && !path.func_75879_b() && (this.field_70122_E || this.func_70090_H()) && !this.func_70610_aX() && (index = path.func_75873_e()) < path.func_75874_d()) {
                PathPoint nextHopSpot = path.func_75877_a(index);
                float x = (float)((double)nextHopSpot.field_75839_a - this.field_70165_t);
                float z = (float)((double)nextHopSpot.field_75838_c - this.field_70161_v);
                float angle = (float)Math.atan2(z, x);
                float distance = (float)Math.sqrt(x * x + z * z);
                if (distance > 1.0f) {
                    if (!this.func_70090_H()) {
                        if (this.ticksOnGround > 5) {
                            this.field_70181_x += 0.5;
                            this.field_70159_w += 0.3 * (double)MathHelper.func_76134_b((float)angle);
                            this.field_70179_y += 0.3 * (double)MathHelper.func_76126_a((float)angle);
                            this.field_70133_I = true;
                        }
                    } else if (this.strokeTicks == 0) {
                        this.field_70159_w += 0.3 * (double)MathHelper.func_76134_b((float)angle);
                        this.field_70179_y += 0.3 * (double)MathHelper.func_76126_a((float)angle);
                        this.field_70133_I = true;
                        this.strokeTicks = 40;
                        this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                    } else if (this.field_70123_F) {
                        this.field_70159_w += 0.01 * (double)MathHelper.func_76134_b((float)angle);
                        this.field_70179_y += 0.01 * (double)MathHelper.func_76126_a((float)angle);
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70181_x < 0.0 && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 0.4)), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o().func_76224_d()) {
                    this.field_70181_x *= (double)0.1f;
                    this.field_70133_I = true;
                }
                if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 0.5)), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o().func_76224_d()) {
                    this.field_70181_x += (double)0.04f;
                    this.field_70133_I = true;
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.getSkin() == 4 && this.field_70170_p.func_72820_D() % 10L == 0L) {
            BLParticle.DIRT_DECAY.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        }
    }

    public void func_70612_e(float strafing, float forward) {
        super.func_70612_e(0.0f, 0.0f);
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        int duration = 0;
        if (this.getSkin() == 4 && !this.field_70170_p.field_72995_K && player.field_70121_D.field_72337_e >= this.field_70121_D.field_72338_b && player.field_70121_D.field_72338_b <= this.field_70121_D.field_72337_e && player.field_70121_D.field_72336_d >= this.field_70121_D.field_72340_a && player.field_70121_D.field_72340_a <= this.field_70121_D.field_72336_d && player.field_70121_D.field_72334_f >= this.field_70121_D.field_72339_c && player.field_70121_D.field_72339_c <= this.field_70121_D.field_72334_f) {
            if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                duration = 5;
            } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                duration = 10;
            }
            if (duration > 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, duration * 20, 0));
            }
        }
    }

    public int getSkin() {
        return this.field_70180_af.func_75679_c(30);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_75692_b(30, (Object)new Integer(skinType));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("skin", this.getSkin());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("skin")) {
            this.setSkin(nbt.func_74762_e("skin"));
        } else {
            this.setSkin(this.field_70146_Z.nextInt(5));
        }
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:frogLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:frogHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:frogDeath";
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.func_70027_ad()) {
            this.func_70099_a(ItemGeneric.createStack(BLItemRegistry.frogLegsCooked, 1, 0), 0.0f);
        } else {
            this.func_70099_a(ItemGeneric.createStack(BLItemRegistry.frogLegsRaw, 1, 0), 0.0f);
            if (this.getSkin() == 4) {
                this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.POISON_GLAND, 1), 0.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte type) {
        if (type == 8) {
            this.strokeTicks = 0;
        }
    }

    @Override
    public String pageName() {
        return "frog";
    }
}

