/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class EntityFirefly
extends EntityFlying
implements IMob,
IEntityBL {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    public int lastLightX;
    public int lastLightY;
    public int lastLightZ;
    public double aboveLayer = 6.0;

    public EntityFirefly(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.6f);
        this.field_70158_ak = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
    }

    protected void func_70626_be() {
        super.func_70626_be();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        double dx = this.waypointX - this.field_70165_t;
        double dy = this.waypointY - this.field_70163_u;
        double dz = this.waypointZ - this.field_70161_v;
        double dist = dx * dx + dy * dy + dz * dz;
        if (dist < 1.0 || dist > 3600.0) {
            this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (this.field_70163_u > 80.0 + this.aboveLayer) {
                this.waypointY = this.field_70163_u + (double)(-this.field_70146_Z.nextFloat() * 2.0f * 16.0f);
            } else {
                float rndFloat = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                if ((double)rndFloat > 0.0) {
                    rndFloat = (float)((double)rndFloat - 0.5);
                    double maxRange = 80.0 + this.aboveLayer - this.field_70163_u;
                    this.waypointY = this.field_70163_u + (double)(-this.field_70146_Z.nextFloat() * 2.0f) * maxRange;
                } else {
                    this.waypointY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
                }
            }
            this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, dist = (double)MathHelper.func_76133_a((double)dist))) {
                this.field_70159_w += dx / dist * 0.03;
                this.field_70181_x += dy / dist * 0.03;
                if (this.field_70163_u > 80.0 + this.aboveLayer) {
                    this.field_70181_x -= (1.0 - (80.0 + this.aboveLayer - this.field_70163_u) / this.aboveLayer + 1.0) / 100.0;
                }
                this.field_70179_y += dz / dist * 0.03;
                if (this.field_70163_u > 80.0 + this.aboveLayer) {
                    this.waypointX = this.field_70165_t;
                    this.waypointY = this.field_70163_u;
                    this.waypointZ = this.field_70161_v;
                }
            } else {
                this.waypointX = this.field_70165_t;
                this.waypointY = this.field_70163_u;
                this.waypointZ = this.field_70161_v;
            }
        }
    }

    private boolean isCourseTraversable(double x, double y, double z, double step) {
        double d4 = (this.waypointX - this.field_70165_t) / step;
        double d5 = (this.waypointY - this.field_70163_u) / step;
        double d6 = (this.waypointZ - this.field_70161_v) / step;
        AxisAlignedBB axisalignedbb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < step) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (!this.field_70170_p.func_72945_a((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int func_70641_bl() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    private void lightUp(World world, int x, int y, int z) {
        world.func_72915_b(EnumSkyBlock.Block, x, y, z, 15);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (x + i == this.lastLightX && y + j == this.lastLightY && z + k == this.lastLightZ && !this.field_70128_L) continue;
                    world.func_147463_c(EnumSkyBlock.Block, this.lastLightX + i, this.lastLightY + j, this.lastLightZ + k);
                    this.lastLightX = x;
                    this.lastLightY = y;
                    this.lastLightZ = z;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void switchOff() {
        this.field_70170_p.func_147463_c(EnumSkyBlock.Block, this.lastLightX, this.lastLightY, this.lastLightZ);
        this.field_70170_p.func_147463_c(EnumSkyBlock.Block, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if ((this.lastLightX != MathHelper.func_76128_c((double)this.field_70165_t) || this.lastLightY != MathHelper.func_76128_c((double)this.field_70163_u) || this.lastLightZ != MathHelper.func_76128_c((double)this.field_70161_v)) && ConfigHandler.FIREFLY_BLOCK_LIGHTING && !ShaderHelper.INSTANCE.isWorldShaderActive()) {
                this.switchOff();
                this.lightUp(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            }
        } else if (this.func_70090_H()) {
            this.field_70181_x += 0.01;
            this.waypointX = this.field_70165_t;
            this.waypointY = this.field_70163_u + 0.1;
            this.waypointZ = this.field_70161_v;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K && ConfigHandler.FIREFLY_BLOCK_LIGHTING && !ShaderHelper.INSTANCE.isWorldShaderActive()) {
            this.switchOff();
        }
    }

    @Override
    public String pageName() {
        return "firefly";
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

