/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.entities.ICameraOffset;
import thebetweenlands.entities.IEntityMusic;
import thebetweenlands.entities.IScreenShake;
import thebetweenlands.entities.mobs.EntityPeatMummy;
import thebetweenlands.entities.mobs.EntitySludgeBall;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.entities.mobs.boss.IBossBL;
import thebetweenlands.items.BLItemRegistry;

public class EntityDreadfulMummy
extends EntityMob
implements IEntityBL,
IBossBL,
IScreenShake,
ICameraOffset,
IEntityMusic {
    public static final IAttribute SPAWN_LENGTH_ATTRIB = new RangedAttribute("bl.spawnLength", 180.0, 0.0, 2.147483647E9).func_111117_a("Spawning Length");
    public static final IAttribute SPAWN_OFFSET_ATTRIB = new RangedAttribute("bl.spawnOffset", 3.0, -2.147483647E9, 2.147483647E9).func_111117_a("Spawning Y Offset");
    private static final int BREAK_COUNT = 20;
    private static final int SPAWN_MUMMY_COOLDOWN = 350;
    private int untilSpawnMummy = 0;
    private static final int SPAWN_SLUDGE_COOLDOWN = 150;
    private int untilSpawnSludge = 0;
    private float prevYOffset;
    public static final int SPAWNING_STATE_DW = 20;
    private int eatPreyTimer = 60;
    public EntityLivingBase currentEatPrey;
    public int deathTicks = 0;

    public EntityDreadfulMummy(World world) {
        super(world);
        this.func_70661_as().func_75495_e(true);
        this.func_70105_a(1.1f, 2.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    public String pageName() {
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(550.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SPAWN_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(SPAWN_OFFSET_ATTRIB);
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:dreadfulPeatMummyLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:dreadfulPeatMummyHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:dreadfulPeatMummyDeath";
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public double func_70033_W() {
        if (this.deathTicks > 80) {
            return (float)(-(this.deathTicks - 80)) * 0.08f;
        }
        return super.func_70033_W();
    }

    public float getCurrentOffset() {
        return (float)(-this.getSpawnOffset() + (double)this.getSpawningProgress() * this.getSpawnOffset());
    }

    public double getSpawnOffset() {
        return this.func_110148_a(SPAWN_OFFSET_ATTRIB).func_111126_e();
    }

    public int getSpawningState() {
        return this.field_70180_af.func_75679_c(20);
    }

    public int getSpawningLength() {
        return (int)this.func_110148_a(SPAWN_LENGTH_ATTRIB).func_111126_e();
    }

    public float getSpawningProgress() {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * (float)this.getSpawningState();
    }

    public float getSpawningProgress(float delta) {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * ((float)this.getSpawningState() + (this.getSpawningState() == this.getSpawningLength() ? 0.0f : delta));
    }

    public void updateSpawningState() {
        int spawningState = this.getSpawningState();
        if (spawningState < this.getSpawningLength()) {
            this.field_70180_af.func_75692_b(20, (Object)(spawningState + 1));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityLivingBase prey = this.getPrey();
        if (prey instanceof EntityLivingBase) {
            this.currentEatPrey = prey;
            if (this.currentEatPrey != null) {
                this.updateEatPrey();
            }
        } else {
            this.currentEatPrey = null;
        }
        if (this.deathTicks > 80) {
            this.field_70129_M = (float)(-(this.deathTicks - 80)) * 0.08f;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.getSpawningProgress() < 1.0f) {
                this.field_70129_M = this.getCurrentOffset();
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.getSpawningState() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.22, this.field_70161_v);
                }
                int breakPoint = this.getSpawningLength() / 20;
                if ((this.getSpawningState() - breakPoint / 2 - 1) % breakPoint == 0) {
                    int x = MathHelper.func_76128_c((double)this.field_70165_t);
                    int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)this.field_70129_M));
                    int z = MathHelper.func_76128_c((double)this.field_70161_v);
                    Block block = this.field_70170_p.func_147439_a(x, y - 1, z);
                    int metadata = this.field_70170_p.func_72805_g(x, y - 1, z);
                    String particle = "blockdust_" + Block.func_149682_b((Block)block) + "_" + metadata;
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u - (double)this.field_70129_M + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, block.field_149762_H.func_150495_a(), this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f, false);
                    int amount = this.field_70146_Z.nextInt(20) + 15;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.field_70170_p.func_72869_a(particle, px + ox, py, pz + oz, motionX, motionY, motionZ);
                    }
                }
            } else {
                this.field_70129_M = 0.0f;
            }
        } else if (this.getSpawningProgress() < 1.0f) {
            this.prevYOffset = this.field_70129_M;
            if (this.getSpawningState() == 0) {
                this.func_85030_a("thebetweenlands:dreadfulPeatMummyEmerge", 1.2f, 1.0f);
            }
            this.updateSpawningState();
            this.field_70129_M = this.getCurrentOffset();
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70133_I = true;
            if (this.func_70777_m() != null) {
                this.func_70625_a(this.func_70777_m(), 360.0f, 360.0f);
            }
            if (this.getSpawningState() == this.getSpawningLength() - 1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.22, this.field_70161_v);
            }
        } else if (this.deathTicks < 80) {
            this.field_70129_M = 0.0f;
            this.prevYOffset = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_70777_m() != null) {
                AxisAlignedBB checkAABB = this.field_70121_D.func_72314_b(32.0, 32.0, 32.0);
                List peatMummies = this.field_70170_p.func_72872_a(EntityPeatMummy.class, checkAABB);
                int mummies = 0;
                for (EntityPeatMummy mummy : peatMummies) {
                    if (!((double)mummy.func_70032_d((Entity)this) <= 32.0)) continue;
                    ++mummies;
                }
                if (mummies < 4 && this.untilSpawnMummy <= 0) {
                    this.spawnMummy();
                }
                if (this.untilSpawnSludge <= 0) {
                    this.spawnSludge();
                }
            }
            if (this.untilSpawnMummy > 0) {
                --this.untilSpawnMummy;
            }
            if (this.untilSpawnSludge > 0) {
                --this.untilSpawnSludge;
            }
            if (this.eatPreyTimer > 0 && this.currentEatPrey != null) {
                --this.eatPreyTimer;
            }
            if (this.eatPreyTimer <= 0) {
                this.setPrey(null);
                this.eatPreyTimer = 60;
            }
        }
    }

    private void spawnMummy() {
        EntityPeatMummy mummy = new EntityPeatMummy(this.field_70170_p);
        mummy.func_70107_b(this.field_70165_t + (double)(this.field_70146_Z.nextInt(6) - 3), this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextInt(6) - 3));
        if (mummy.field_70170_p.func_72855_b(mummy.field_70121_D) && mummy.field_70170_p.func_72945_a((Entity)mummy, mummy.field_70121_D).isEmpty()) {
            this.untilSpawnMummy = 350;
            mummy.func_70624_b((EntityLivingBase)this.func_70777_m());
            mummy.func_70606_j(30.0f);
            this.field_70170_p.func_72838_d((Entity)mummy);
            mummy.setCarryShimmerStone(false);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:dreadfulPeatMummyScream", 1.0f, 1.0f);
        } else {
            this.untilSpawnMummy = 1;
        }
    }

    private void spawnSludge() {
        this.untilSpawnSludge = 150;
        if (this.func_70777_m() != null) {
            this.func_70625_a(this.func_70777_m(), 360.0f, 360.0f);
        }
        Vec3 look = this.func_70040_Z();
        double direction = Math.toRadians(this.field_70761_aq);
        EntitySludgeBall sludge = new EntitySludgeBall(this.field_70170_p, (EntityLivingBase)this);
        sludge.func_70107_b(this.field_70165_t - Math.sin(direction) * 3.5, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + Math.cos(direction) * 3.5);
        sludge.field_70159_w = look.field_72450_a * 0.5;
        sludge.field_70181_x = look.field_72448_b;
        sludge.field_70179_y = look.field_72449_c * 0.5;
        this.func_85030_a("thebetweenlands:dreadfulPeatMummyRetch", 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        this.field_70170_p.func_72838_d((Entity)sludge);
    }

    public boolean func_70652_k(Entity target) {
        if (this.getSpawningProgress() < 1.0f) {
            return false;
        }
        boolean attacked = super.func_70652_k(target);
        if (!(!attacked || this.field_70146_Z.nextInt(6) != 0 || target == this.currentEatPrey || !(target instanceof EntityLivingBase) || target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d || this.field_70170_p.field_72995_K)) {
            this.setPrey((EntityLivingBase)target);
        }
        if (attacked) {
            this.func_85030_a("thebetweenlands:dreadfulPeatMummySwipe", 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        }
        return attacked;
    }

    private void updateEatPrey() {
        double direction = Math.toRadians(this.field_70761_aq);
        this.currentEatPrey.func_70080_a(this.field_70165_t - Math.sin(direction) * 1.7, this.field_70163_u + 1.7, this.field_70161_v + Math.cos(direction) * 1.7, (float)(Math.toDegrees(direction) + 180.0), 0.0f);
        this.currentEatPrey.field_70177_z = this.currentEatPrey.field_70126_B = (float)(Math.toDegrees(direction) + 180.0);
        this.currentEatPrey.field_70758_at = this.currentEatPrey.field_70126_B;
        this.currentEatPrey.field_70759_as = this.currentEatPrey.field_70126_B;
        this.currentEatPrey.field_70143_R = 0.0f;
        if (this.field_70173_aa % 10 == 0 && !this.field_70170_p.field_72995_K) {
            this.currentEatPrey.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
            this.func_85030_a("thebetweenlands:dreadfulPeatMummyBite", 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        }
        if (!this.currentEatPrey.func_70089_S() && !this.field_70170_p.field_72995_K) {
            this.setPrey(null);
        }
    }

    private void setPrey(EntityLivingBase prey) {
        if (prey == null) {
            this.field_70180_af.func_75692_b(24, (Object)-1);
        } else {
            this.field_70180_af.func_75692_b(24, (Object)prey.func_145782_y());
        }
    }

    private EntityLivingBase getPrey() {
        Entity prey;
        int id = this.field_70180_af.func_75679_c(24);
        Entity entity = prey = id != -1 ? this.field_70170_p.func_73045_a(id) : null;
        if (prey instanceof EntityLivingBase) {
            return (EntityLivingBase)prey;
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() == this.currentEatPrey) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public IChatComponent getBossName() {
        return this.func_145748_c_();
    }

    protected void func_70609_aI() {
        if (this.deathTicks == 0 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:dreadfulPeatMummyDeath", 1.0f, 1.0f);
        }
        ++this.deathTicks;
        if (!this.field_70170_p.field_72995_K) {
            int xp;
            int dropXP;
            this.field_70165_t = this.field_70142_S;
            this.field_70163_u = this.field_70137_T;
            this.field_70161_v = this.field_70136_U;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.deathTicks > 40 && this.deathTicks % 5 == 0) {
                for (xp = 100; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks == 80) {
                for (xp = 1200; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks > 120) {
                this.func_70106_y();
            }
        }
        if (this.deathTicks > 80 && this.field_70170_p.field_72995_K && this.deathTicks % 5 == 0) {
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    int z;
                    int y;
                    int x = MathHelper.func_76128_c((double)this.field_70165_t) + xo;
                    Block block = this.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)this.field_70129_M - 0.1)), z = MathHelper.func_76128_c((double)this.field_70161_v) + zo);
                    if (block == Blocks.field_150350_a) continue;
                    int metadata = this.field_70170_p.func_72805_g(x, y, z);
                    String particle = "blockdust_" + Block.func_149682_b((Block)block) + "_" + metadata;
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u - (double)this.field_70129_M + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, block.field_149762_H.func_150495_a(), this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f, false);
                    int amount = this.field_70146_Z.nextInt(20) + 10;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.field_70170_p.func_72869_a(particle, px + ox + (double)xo, py, pz + oz + (double)zo, motionX, motionY, motionZ);
                    }
                }
            }
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.func_70089_S()) {
            super.func_70100_b_(player);
        }
    }

    public boolean func_70104_M() {
        return this.func_70089_S() && super.func_70104_M();
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected boolean func_70610_aX() {
        return this.func_70089_S() && super.func_70610_aX();
    }

    @Override
    public float getShakeIntensity(EntityLivingBase viewer, float partialTicks) {
        if (this.deathTicks > 0) {
            double dist = this.func_70032_d((Entity)viewer);
            float screamMult = (float)(1.0 - dist / 30.0);
            if (dist >= 30.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.deathTicks / 120.0 * Math.PI) + (double)0.1f) * (double)0.15f * (double)screamMult);
        }
        return 0.0f;
    }

    @Override
    public boolean applyOffset(EntityLivingBase view, float partialTicks) {
        if (this.currentEatPrey == view) {
            double direction = Math.toRadians(this.field_70760_ar + (this.field_70761_aq - this.field_70760_ar) * partialTicks);
            view.field_70126_B = view.field_70177_z = (float)(Math.toDegrees(direction) + 180.0);
            view.field_70125_A = 0.0f;
            view.field_70127_C = 0.0f;
            view.func_70034_d((float)(Math.toDegrees(direction) + 180.0));
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("spawningState", this.getSpawningState());
        nbt.func_74768_a("deathTicks", this.deathTicks);
        nbt.func_74780_a("initialPosY", this.field_70163_u);
        nbt.func_74776_a("previousYOffset", this.prevYOffset);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.deathTicks = nbt.func_74762_e("deathTicks");
        this.field_70163_u = nbt.func_74769_h("initialPosY");
        this.field_70129_M = nbt.func_74760_g("previousYOffset");
        this.field_70180_af.func_75692_b(20, (Object)nbt.func_74762_e("spawningState"));
    }

    protected void func_70628_a(boolean killedByPlayer, int looting) {
        this.func_145779_a(BLItemRegistry.ringOfSummoning, 1);
        for (int i = 0; i < this.field_70170_p.field_73012_v.nextInt(3) + 1 + this.field_70170_p.field_73012_v.nextInt(looting + 1) * 2; ++i) {
            this.func_145779_a(BLItemRegistry.shimmerStone, 1);
        }
        this.func_145779_a(BLItemRegistry.amuletSlot, 1);
    }

    @Override
    public String getMusicFile(EntityPlayer listener) {
        return "thebetweenlands:dreadfulPeatMummyLoop";
    }

    @Override
    public double getMusicRange(EntityPlayer listener) {
        return 32.0;
    }

    @Override
    public boolean isMusicActive(EntityPlayer listener) {
        return this.func_70089_S();
    }
}

