/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.entities.mobs.EntityLurker;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.misc.ItemGeneric;

public class EntityDragonFly
extends EntityAmbientCreature
implements IEntityBL {
    public ChunkCoordinates currentFlightTarget;
    public boolean entityFlying;

    public EntityDragonFly(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.5f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_70641_bl() {
        return 2;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected void func_70069_a(float par1) {
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:dragonfly";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:squish";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.DRAGONFLY_WING, 4), 0.0f);
        }
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public void setEntityFlying(boolean state) {
        this.entityFlying = state;
    }

    public void func_70071_h_() {
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(200) == 0) {
                if (!this.entityFlying) {
                    this.setEntityFlying(true);
                } else {
                    this.setEntityFlying(false);
                }
            }
            if (this.entityFlying) {
                this.flyAbout();
            } else {
                this.land();
            }
            if (!this.entityFlying) {
                if (this.func_70090_H()) {
                    this.field_70181_x += (double)0.2f;
                }
                if (this.field_70170_p.func_72953_d(this.field_70121_D.func_72314_b(0.0, 1.0, 0.0))) {
                    this.flyAbout();
                }
                if (this.field_70170_p.func_72890_a((Entity)this, 4.0) != null) {
                    this.flyAbout();
                }
            }
        }
        super.func_70071_h_();
    }

    public void flyAbout() {
        if (!(this.currentFlightTarget == null || this.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c) && this.currentFlightTarget.field_71572_b >= 1 && this.field_70170_p.func_147439_a(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b + 1, this.currentFlightTarget.field_71573_c) != Blocks.field_150355_j)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentFlightTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 10.0f) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
        }
        this.flyToTarget();
    }

    public void flyToTarget() {
        if (this.currentFlightTarget != null) {
            double targetX = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
            double targetY = (double)this.currentFlightTarget.field_71572_b + 1.0 - this.field_70163_u;
            double targetZ = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.1;
            this.field_70181_x += (Math.signum(targetY) * 0.7 - this.field_70181_x) * 0.1;
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.1;
            float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += rotation;
        }
    }

    private void land() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return this.isInLurkersMouth() ? false : super.func_145770_h(x, y, z);
    }

    public boolean func_70067_L() {
        return !this.isInLurkersMouth();
    }

    protected boolean func_70692_ba() {
        return !this.isInLurkersMouth();
    }

    public boolean func_70685_l(Entity entity) {
        return this.isInLurkersMouth() ? false : super.func_70685_l(entity);
    }

    private boolean isInLurkersMouth() {
        return this.field_70154_o instanceof EntityLurker;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int amount;
                for (int experiencePoints = this.func_70693_a(this.field_70717_bb); experiencePoints > 0; experiencePoints -= amount) {
                    amount = EntityXPOrb.func_70527_a((int)experiencePoints);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, amount));
                }
            }
            this.func_70106_y();
            if (!this.isInLurkersMouth()) {
                for (int particle = 0; particle < 20; ++particle) {
                    double motionX = this.field_70146_Z.nextGaussian() * 0.02;
                    double motionY = this.field_70146_Z.nextGaussian() * 0.02;
                    double motionZ = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_72869_a("explode", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, motionX, motionY, motionZ);
                }
            }
        }
    }

    @Override
    public String pageName() {
        return "dragonFly";
    }
}

