/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.entityAI.EntityAIDruidTeleport;
import thebetweenlands.entities.entityAI.EntityAIHurtByTargetDruid;
import thebetweenlands.entities.entityAI.EntityAINearestAttackableTargetDruid;
import thebetweenlands.items.misc.ItemSwampTalisman;
import thebetweenlands.network.packet.server.PacketDruidTeleportParticle;

public class EntityDarkDruid
extends EntityMob {
    private static final int MIN_ATTACK_DELAY = 40;
    private static final int MAX_ATTACK_DELAY = 120;
    private static final int MAX_ATTACK_TIME = 20;
    private static final int MAX_ATTACK_ANIMATION_TIME = 8;
    private EntityAIAttackOnCollide meleeAI = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, (double)0.23f, false);
    private EntityAIWander wanderAI = new EntityAIWander((EntityCreature)this, (double)0.23f);
    private EntityAIWatchClosest watchAI = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f);
    private int attackDelayCounter;
    private int attackCounter;
    private int teleportCooldown;
    private boolean isWatching = true;
    private int prevAttackAnimationTime;
    private int attackAnimationTime;

    public EntityDarkDruid(World world) {
        super(world);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAI);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, (double)0.23f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wanderAI);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.watchAI);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIDruidTeleport(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTargetDruid(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTargetDruid(this));
        this.func_70105_a(0.9f, 1.9f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null) {
            if (this.attackDelayCounter > 0 && !this.isCasting() && (double)this.func_70638_az().func_70032_d((Entity)this) < 10.0) {
                --this.attackDelayCounter;
            }
            if ((this.attackDelayCounter <= 0 || this.attackCounter > 0) && this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                if (this.attackCounter == 0) {
                    if (this.func_70638_az().field_70122_E) {
                        ++this.attackCounter;
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAI);
                        }
                    }
                } else if (this.attackCounter < 20) {
                    ++this.attackCounter;
                    this.startCasting();
                    if (!this.field_70170_p.field_72995_K) {
                        this.chargeSpell((Entity)this.func_70638_az());
                    }
                } else if (this.attackCounter >= 20) {
                    this.attackDelayCounter = 40 + this.field_70146_Z.nextInt(81) + 1;
                    this.attackCounter = 0;
                    this.stopCasting();
                    if (!this.field_70170_p.field_72995_K) {
                        this.castSpell((Entity)this.func_70638_az());
                        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAI);
                    }
                }
            }
        } else if (this.isCasting() || this.attackCounter != 0) {
            if (this.attackDelayCounter <= 0) {
                this.attackDelayCounter = 40 + this.field_70146_Z.nextInt(81) + 1;
            }
            this.attackCounter = 0;
            this.stopCasting();
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70760_ar = this.field_70126_B;
            this.field_70761_aq = this.field_70177_z;
            this.prevAttackAnimationTime = this.attackAnimationTime;
            if (this.isCasting()) {
                if (this.attackAnimationTime < 8) {
                    ++this.attackAnimationTime;
                }
                this.spawnParticles();
            } else if (this.attackAnimationTime > 0) {
                --this.attackAnimationTime;
            }
        } else {
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 100.0f, 100.0f);
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
        }
    }

    private void enableWatch() {
        if (!this.isWatching) {
            this.isWatching = true;
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.watchAI);
        }
    }

    private void disableWatch() {
        if (this.isWatching) {
            this.isWatching = false;
            this.field_70714_bg.func_85156_a((EntityAIBase)this.watchAI);
        }
    }

    public boolean teleportNearEntity(Entity entity) {
        int blockZ;
        int blockY;
        double targetX = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 6.0;
        double targetY = entity.field_70163_u + (double)(this.field_70146_Z.nextInt(3) - 1);
        double targetZ = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 6.0;
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        boolean successful = false;
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(blockX, blockY = MathHelper.func_76128_c((double)this.field_70163_u), blockZ = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean validBlock = false;
            while (!validBlock && blockY > 0) {
                Block block = this.field_70170_p.func_147439_a(blockX, blockY - 1, blockZ);
                if (block.func_149688_o().func_76230_c()) {
                    validBlock = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --blockY;
            }
            if (validBlock) {
                this.teleportCooldown = this.field_70146_Z.nextInt(40) + 40;
                EntityDarkDruid newDruid = new EntityDarkDruid(this.field_70170_p);
                newDruid.func_82141_a((Entity)this, true);
                newDruid.func_70107_b(targetX, targetY, targetZ);
                newDruid.func_70625_a(entity, 100.0f, 100.0f);
                newDruid.attackDelayCounter = 40 + this.field_70146_Z.nextInt(81) + 1;
                if (this.field_70170_p.func_72945_a((Entity)newDruid, newDruid.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(newDruid.field_70121_D)) {
                    successful = true;
                    this.func_70106_y();
                    this.field_70170_p.func_72838_d((Entity)newDruid);
                    this.druidParticlePacketOrigin();
                    this.druidParticlePacketTarget(newDruid);
                } else {
                    newDruid.func_70106_y();
                }
            }
        }
        if (successful) {
            this.field_70170_p.func_72908_a(x, y, z, "thebetweenlands:druidTeleport", 1.0f, 1.0f);
            this.func_85030_a("thebetweenlands:druidTeleport", 1.0f, 1.0f);
            return true;
        }
        this.func_70107_b(x, y, z);
        return false;
    }

    private void druidParticlePacketTarget(EntityDarkDruid newDruid) {
        World world = this.field_70170_p;
        if (world instanceof WorldServer) {
            int dim = ((WorldServer)world).field_73011_w.field_76574_g;
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketDruidTeleportParticle(newDruid)), new NetworkRegistry.TargetPoint(dim, newDruid.field_70165_t + 0.5, newDruid.field_70163_u + 1.0, newDruid.field_70161_v + 0.5, 64.0));
        }
    }

    private void druidParticlePacketOrigin() {
        World world = this.field_70170_p;
        if (world instanceof WorldServer) {
            int dim = ((WorldServer)world).field_73011_w.field_76574_g;
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketDruidTeleportParticle(this)), new NetworkRegistry.TargetPoint(dim, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, 64.0));
        }
    }

    public void spawnParticles() {
        double yaw = this.field_70177_z * ((float)Math.PI / 180);
        double y = Math.cos(-this.field_70125_A * ((float)Math.PI / 180));
        double offsetX = -Math.sin(yaw) * 0.5 * y;
        double offsetY = 1.2 - Math.sin(-this.field_70125_A * ((float)Math.PI / 180)) * 0.5 * y;
        double offsetZ = Math.cos(yaw) * 0.5 * y;
        double motionX = -Math.sin(yaw) * y * 0.2 * (this.field_70146_Z.nextDouble() * 0.7 + 0.3) + this.field_70146_Z.nextDouble() * 0.05 - 0.025;
        double motionY = Math.sin(-this.field_70125_A * ((float)Math.PI / 180)) + this.field_70146_Z.nextDouble() * 0.25 - 0.125;
        double motionZ = Math.cos(yaw) * y * 0.2 * (this.field_70146_Z.nextDouble() * 0.7 + 0.3) + this.field_70146_Z.nextDouble() * 0.05 - 0.025;
        BLParticle.DRUID_MAGIC.spawn(this.field_70170_p, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, motionX, motionY, motionZ, this.field_70146_Z.nextFloat() + 0.5f, new Object[0]);
    }

    public void chargeSpell(Entity entity) {
        if (entity.func_70032_d((Entity)this) <= 4.0f) {
            double dx = entity.field_70165_t - this.field_70165_t;
            double dz = entity.field_70161_v - this.field_70161_v;
            double len = Math.sqrt(dx * dx + dz * dz);
            entity.field_70159_w = 1.5 * dx / len;
            entity.field_70179_y = 1.5 * dz / len;
        } else {
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
        }
        entity.field_70181_x = 0.1;
        entity.field_70133_I = true;
    }

    public void castSpell(Entity entity) {
        double dx = entity.field_70165_t - this.field_70165_t;
        double dz = entity.field_70161_v - this.field_70161_v;
        double len = Math.sqrt(dx * dx + dz * dz);
        entity.field_70159_w = 0.5 * dx / len;
        entity.field_70179_y = 0.5 * dz / len;
        entity.field_70181_x = 1.05;
        entity.field_70133_I = true;
    }

    protected void func_70600_l(int looting) {
        this.func_70099_a(ItemSwampTalisman.createStack(ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN, 1), 0.0f);
    }

    public void func_70628_a(boolean recentlyHit, int looting) {
        int randomPiece = this.field_70146_Z.nextInt(4);
        switch (randomPiece) {
            case 0: {
                this.func_70099_a(ItemSwampTalisman.createStack(ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_1, 1), 0.0f);
                break;
            }
            case 1: {
                this.func_70099_a(ItemSwampTalisman.createStack(ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_2, 1), 0.0f);
                break;
            }
            case 2: {
                this.func_70099_a(ItemSwampTalisman.createStack(ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_3, 1), 0.0f);
                break;
            }
            case 3: {
                this.func_70099_a(ItemSwampTalisman.createStack(ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_4, 1), 0.0f);
            }
        }
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public int func_70641_bl() {
        return 5;
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:darkDruidLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:darkDruidHit";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:darkDruidDeath";
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public int getAttackCounter() {
        return this.attackCounter;
    }

    public void startCasting() {
        this.field_70180_af.func_75692_b(20, (Object)1);
        this.enableWatch();
    }

    public void stopCasting() {
        this.field_70180_af.func_75692_b(20, (Object)0);
        this.disableWatch();
    }

    public boolean isCasting() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public boolean canTeleport() {
        return !this.isCasting() && this.teleportCooldown == 0;
    }

    public float getAttackAnimationTime(float partialRenderTicks) {
        return ((float)this.prevAttackAnimationTime + (float)(this.attackAnimationTime - this.prevAttackAnimationTime) * partialRenderTicks) / 8.0f;
    }

    public void func_70109_d(NBTTagCompound tagCompound) {
        super.func_70109_d(tagCompound);
        tagCompound.func_74768_a("Teleport", this.teleportCooldown);
    }

    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.teleportCooldown = tagCompound.func_74762_e("Teleport");
    }
}

