/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.entities.projectiles.EntitySnailPoisonJet;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;

public class EntityBloodSnail
extends EntityMob
implements IEntityBL {
    public EntityBloodSnail(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.5f);
        this.field_70138_W = 0.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 0.5, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public int func_70641_bl() {
        return 3;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.func_70027_ad()) {
            this.func_70099_a(ItemGeneric.createStack(BLItemRegistry.snailFleshCooked, 1, 0), 0.0f);
        } else {
            this.func_70099_a(ItemGeneric.createStack(BLItemRegistry.snailFleshRaw, 1, 0), 0.0f);
        }
        if (this.field_70146_Z.nextBoolean()) {
            this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.BLOOD_SNAIL_SHELL, 1), 0.0f);
        } else {
            this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.POISON_GLAND, 2), 0.0f);
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:snailLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:snailHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:snailDeath";
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLiving) {
                int duration = 0;
                if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0) {
                    ((EntityLiving)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, duration * 20, 0));
                    ((EntityLiving)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null && this.func_70089_S()) {
            float distance = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().field_70121_D.field_72338_b, this.func_70638_az().field_70161_v);
            if (this.getRangeAttackTimer() < 100 && distance > 3.0f) {
                this.setRangeAttackTimer(this.getRangeAttackTimer() + 2);
            }
            if (this.getRangeAttackTimer() == 100 && distance > 3.0f) {
                this.shootMissile(this.func_70638_az(), distance);
            }
        }
    }

    public void shootMissile(EntityLivingBase entity, float distance) {
        this.setRangeAttackTimer(0);
        if (this.func_70685_l((Entity)entity)) {
            EntitySnailPoisonJet missile = new EntitySnailPoisonJet(this.field_70170_p, (EntityLiving)this);
            missile.field_70125_A -= -20.0f;
            double targetX = entity.field_70165_t + entity.field_70159_w - this.field_70165_t;
            double targetY = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f - this.field_70163_u;
            double targetZ = entity.field_70161_v + entity.field_70179_y - this.field_70161_v;
            float target = MathHelper.func_76133_a((double)(targetX * targetX + targetZ * targetZ));
            missile.func_70186_c(targetX, targetY + (double)(target * 0.1f), targetZ, 0.75f, 8.0f);
            this.field_70170_p.func_72838_d((Entity)missile);
        }
    }

    public void setRangeAttackTimer(int size) {
        this.field_70180_af.func_75692_b(20, (Object)size);
    }

    public int getRangeAttackTimer() {
        return this.field_70180_af.func_75679_c(20);
    }

    @Override
    public String pageName() {
        return "bloodSnail";
    }
}

