/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import thebetweenlands.client.model.ControlledAnimation;
import thebetweenlands.entities.mobs.EntityTempleGuardian;
import thebetweenlands.entities.mobs.IEntityBL;

public class EntityBerserkerGuardian
extends EntityTempleGuardian
implements IEntityBL {
    private int chargingTimer = 0;
    private int timeUntilCharge = 0;
    public ControlledAnimation chargeAnim = new ControlledAnimation(10);
    private static final int CHARGE_DURATION = 40;
    private static final int CHARGE_COOLDOWN = 120;

    public EntityBerserkerGuardian(World worldObj) {
        super(worldObj);
        this.func_70105_a(1.1f, 2.5f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null && this.timeUntilCharge == 0 && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f && this.active.getTimer() == 20) {
            this.setCharging(true);
            this.func_85030_a("thebetweenlands:templeGuardianBerserkerCharge", 1.0f, 1.0f);
            this.chargingTimer = 40;
            this.timeUntilCharge = 120;
        }
        if (this.chargingTimer >= 0) {
            --this.chargingTimer;
        }
        if (this.chargingTimer == 0) {
            this.setCharging(false);
        }
        if (this.timeUntilCharge > 0) {
            --this.timeUntilCharge;
        }
        if (this.getCharging()) {
            this.func_70661_as().func_75499_g();
            float speed = 0.4f;
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            float x = speed * (float)Math.sin((double)(-this.field_70177_z) * Math.PI / 180.0);
            float z = speed * (float)Math.cos((double)(-this.field_70177_z) * Math.PI / 180.0);
            this.func_70091_d(x, this.field_70181_x, z);
            this.chargeAnim.increaseTimer();
        } else {
            this.chargeAnim.decreaseTimer();
        }
    }

    protected String func_70639_aQ() {
        if (!this.getActive()) {
            return null;
        }
        return "thebetweenlands:templeGuardianBerserkerLiving";
    }

    @Override
    public String pageName() {
        return "beserkerGuardian";
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public boolean getCharging() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    public void setCharging(boolean charging) {
        this.field_70180_af.func_75692_b(21, (Object)(charging ? (byte)1 : 0));
    }

    protected void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.getCharging() && entity instanceof EntityLivingBase) {
            this.func_70652_k(entity);
        }
    }

    public void func_70653_a(Entity p_70653_1_, float p_70653_2_, double p_70653_3_, double p_70653_5_) {
        if (this.getCharging()) {
            return;
        }
        super.func_70653_a(p_70653_1_, p_70653_2_, p_70653_3_, p_70653_5_);
    }
}

