/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.utils.AnimationMathHelper;

public class EntityAngler
extends EntityWaterMob
implements IEntityBL,
IMob {
    private ChunkCoordinates currentSwimTarget;
    AnimationMathHelper animation = new AnimationMathHelper();
    public float moveProgress;

    public EntityAngler(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.7f);
        this.func_70050_g(80);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(34.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected String func_70621_aR() {
        return "thebetweenlands:anglerAttack";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:anglerDeath";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_85030_a("game.hostile.swim", 0.1f, 2.0f);
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int amount = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + looting);
        if (recentlyHit) {
            for (int count = 0; count < amount; ++count) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.ANGLER_TOOTH, 3), 0.0f);
                    continue;
                }
                this.func_70099_a(ItemGeneric.createStack(BLItemRegistry.anglerMeatRaw, 1, 0), 0.0f);
            }
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) == BLBlockRegistry.swampWater;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this);
    }

    public boolean isGrounded() {
        return !this.func_70090_H() && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150350_a && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)).func_149703_v();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer target = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            this.func_70784_b((Entity)target);
            if (this.func_70090_H()) {
                if (!this.field_70170_p.field_72995_K) {
                    if (this.func_70777_m() != null) {
                        this.currentSwimTarget = new ChunkCoordinates((int)this.func_70777_m().field_70165_t, (int)((float)((int)this.func_70777_m().field_70163_u) + this.func_70777_m().func_70047_e()), (int)this.func_70777_m().field_70161_v);
                        this.swimToTarget();
                    } else {
                        this.swimAbout();
                    }
                }
            } else if (!this.field_70170_p.field_72995_K) {
                if (!this.field_70122_E) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x -= 0.08;
                    this.field_70181_x *= (double)0.98f;
                    this.field_70179_y = 0.0;
                } else if (this.field_70122_E) {
                    this.setIsLeaping(false);
                    this.field_70181_x += (double)0.4f;
                    this.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f);
                    this.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f);
                }
            }
        } else if (this.func_70090_H()) {
            this.moveProgress = this.animation.swing(1.2f, 0.4f, false);
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
        } else {
            this.moveProgress = this.animation.swing(2.0f, 0.4f, false);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--air);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(80);
        }
    }

    public void swimAbout() {
        if (this.currentSwimTarget != null && (this.field_70170_p.func_147439_a(this.currentSwimTarget.field_71574_a, this.currentSwimTarget.field_71572_b, this.currentSwimTarget.field_71573_c) != BLBlockRegistry.swampWater && this.field_70170_p.func_147439_a(this.currentSwimTarget.field_71574_a, this.currentSwimTarget.field_71572_b, this.currentSwimTarget.field_71573_c) != Blocks.field_150355_j || this.currentSwimTarget.field_71572_b < 1)) {
            this.currentSwimTarget = null;
        }
        if (this.currentSwimTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentSwimTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 10.0f) {
            this.currentSwimTarget = new ChunkCoordinates((int)this.field_70165_t + this.field_70146_Z.nextInt(10) - this.field_70146_Z.nextInt(10), (int)this.field_70163_u - this.field_70146_Z.nextInt(6) + 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(10) - this.field_70146_Z.nextInt(10));
        }
        this.swimToTarget();
    }

    protected void swimToTarget() {
        double targetX = (double)this.currentSwimTarget.field_71574_a + 0.5 - this.field_70165_t;
        double targetY = (double)this.currentSwimTarget.field_71572_b + 0.5 - this.field_70163_u;
        double targetZ = (double)this.currentSwimTarget.field_71573_c + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(targetX) * 0.3 - this.field_70159_w) * 0.1;
        this.field_70181_x += (Math.signum(targetY) * 0.4 - this.field_70181_x) * 0.08;
        this.field_70181_x -= 0.01;
        this.field_70179_y += (Math.signum(targetZ) * 0.3 - this.field_70179_y) * 0.1;
        this.field_70701_bs = 0.5f;
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        if (!player.field_71075_bZ.field_75098_d && !this.field_70170_p.field_72995_K && this.func_70635_at().func_75522_a((Entity)player) && this.func_70032_d((Entity)player) <= 1.5f && player.field_70121_D.field_72337_e >= this.field_70121_D.field_72338_b && player.field_70121_D.field_72338_b <= this.field_70121_D.field_72337_e) {
            player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        }
    }

    protected void func_70785_a(Entity entity, float distance) {
        if (distance > 2.0f && distance < 6.0f && entity.field_70121_D.field_72337_e >= this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b <= this.field_70121_D.field_72337_e && this.field_70146_Z.nextInt(3) == 0 && this.func_70090_H() && this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v) == Blocks.field_150350_a) {
            this.setIsLeaping(true);
            double distanceX = entity.field_70165_t - this.field_70165_t;
            double distanceZ = entity.field_70161_v - this.field_70161_v;
            float distanceSqrRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            this.field_70159_w = distanceX / (double)distanceSqrRoot * 1.5 * 0.900000011920929 + this.field_70159_w * 2.7000000029802322;
            this.field_70179_y = distanceZ / (double)distanceSqrRoot * 1.5 * 0.900000011920929 + this.field_70179_y * 2.7000000029802322;
            this.field_70181_x = 0.8;
        }
    }

    public boolean isLeaping() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public void setIsLeaping(boolean leaping) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(leaping ? 1 : 0)));
    }

    @Override
    public String pageName() {
        return "angler";
    }
}

