/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.entityAI;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Random;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityGecko;

public class EntityAIBLAvoidEntityGecko
extends EntityAIBase {
    public final IEntitySelector viableSelector = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity.func_70089_S() && EntityAIBLAvoidEntityGecko.this.gecko.func_70635_at().func_75522_a(entity);
        }
    };
    private final Comparator<Vec3> smallest = new Comparator<Vec3>(){

        @Override
        public int compare(Vec3 a, Vec3 b) {
            double bLength;
            double aLength = a.func_72433_c();
            return aLength < (bLength = b.func_72433_c()) ? -1 : (aLength > bLength ? 1 : 0);
        }
    };
    private EntityGecko gecko;
    private double farSpeed;
    private double nearSpeed;
    private Entity closestLivingEntity;
    private float distance;
    private PathEntity path;
    private PathNavigate navigator;
    private Class<?> avoidingEntityClass;
    private boolean bushBound;
    private Vec3 target;

    public EntityAIBLAvoidEntityGecko(EntityGecko gecko, Class<?> avoidingEntityClass, float distance, double farSpeed, double nearSpeed) {
        this.gecko = gecko;
        this.avoidingEntityClass = avoidingEntityClass;
        this.distance = distance;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.navigator = gecko.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.gecko.isHiding()) {
            return false;
        }
        if (this.avoidingEntityClass == EntityPlayer.class) {
            this.closestLivingEntity = this.gecko.field_70170_p.func_72890_a((Entity)this.gecko, (double)this.distance);
            if (this.closestLivingEntity == null) {
                return false;
            }
        } else {
            List list = this.gecko.field_70170_p.func_82733_a(this.avoidingEntityClass, this.gecko.field_70121_D.func_72314_b((double)this.distance, 3.0, (double)this.distance), this.viableSelector);
            if (list.isEmpty()) {
                return false;
            }
            this.closestLivingEntity = (Entity)list.get(0);
        }
        this.target = this.findNearBush();
        if (this.target == null) {
            this.target = RandomPositionGenerator.func_75461_b((EntityCreature)this.gecko, (int)16, (int)7, (Vec3)Vec3.func_72443_a((double)this.closestLivingEntity.field_70165_t, (double)this.closestLivingEntity.field_70163_u, (double)this.closestLivingEntity.field_70161_v));
        } else {
            this.bushBound = true;
        }
        if (this.target == null) {
            return false;
        }
        if (!this.bushBound && this.closestLivingEntity.func_70092_e(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c) < this.closestLivingEntity.func_70068_e((Entity)this.gecko)) {
            return false;
        }
        this.path = this.navigator.func_75488_a(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c);
        if (this.doesGeckoNeighborBush(this.target)) {
            this.gecko.setHidingBush(MathHelper.func_76128_c((double)this.gecko.field_70165_t), MathHelper.func_76128_c((double)this.gecko.field_70163_u), MathHelper.func_76128_c((double)this.gecko.field_70161_v));
            this.gecko.startHiding();
            return false;
        }
        return this.path == null ? false : (this.path.func_75880_b(this.target) ? true : (this.bushBound ? this.doesPathDestinationNeighborBush(this.target, this.path) : false));
    }

    private boolean doesGeckoNeighborBush(Vec3 target) {
        Vec3 geckoPos = Vec3.func_72443_a((double)MathHelper.func_76128_c((double)this.gecko.field_70165_t), (double)MathHelper.func_76128_c((double)this.gecko.field_70163_u), (double)MathHelper.func_76128_c((double)this.gecko.field_70161_v));
        for (ForgeDirection dir : ForgeDirection.values()) {
            Vec3 nearTarget = Vec3.func_72443_a((double)(target.field_72450_a + (double)dir.offsetX), (double)(target.field_72448_b + (double)dir.offsetY), (double)(target.field_72449_c + (double)dir.offsetZ));
            if (geckoPos.func_72436_e(nearTarget) != 0.0) continue;
            return true;
        }
        return false;
    }

    private boolean doesPathDestinationNeighborBush(Vec3 target, PathEntity path) {
        for (ForgeDirection dir : ForgeDirection.values()) {
            Vec3 nearTarget = Vec3.func_72443_a((double)(target.field_72450_a + (double)dir.offsetX), (double)(target.field_72448_b + (double)dir.offsetY), (double)(target.field_72449_c + (double)dir.offsetZ));
            if (!path.func_75880_b(nearTarget)) continue;
            return true;
        }
        return false;
    }

    private Vec3 findNearBush() {
        int radius = 8;
        int range = 17;
        int centerX = MathHelper.func_76128_c((double)this.gecko.field_70165_t);
        int centerY = MathHelper.func_76128_c((double)this.gecko.field_70163_u);
        int centerZ = MathHelper.func_76128_c((double)this.gecko.field_70161_v);
        Random rand = this.gecko.func_70681_au();
        ArrayList<Vec3> bushes = new ArrayList<Vec3>();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -4; dy <= 8; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    int x = centerX + dx;
                    int y = centerY + dy;
                    int z = centerZ + dz;
                    if (this.gecko.field_70170_p.func_147439_a(x, y, z) != BLBlockRegistry.weedwoodBush || !this.gecko.field_70170_p.func_147445_c(x, y - 1, z, false)) continue;
                    bushes.add(Vec3.func_72443_a((double)dx, (double)dy, (double)dz));
                }
            }
        }
        if (bushes.size() == 0) {
            return null;
        }
        Collections.sort(bushes, this.smallest);
        double targetDistance = ((Vec3)bushes.get(0)).func_72433_c();
        double epsilon = 1.0E-8;
        int bushCount = bushes.size();
        for (int i = 0; i < bushCount; ++i) {
            boolean end;
            boolean bl = end = i == bushCount - 1;
            if (!(Math.abs(((Vec3)bushes.get(i)).func_72433_c() - targetDistance) > 1.0E-8) && !end) continue;
            return ((Vec3)bushes.get(rand.nextInt(end ? i + 1 : i))).func_72441_c((double)centerX, (double)centerY, (double)centerZ);
        }
        throw new ConcurrentModificationException("I'm not sure how I feel about this...");
    }

    public boolean func_75253_b() {
        return !this.navigator.func_75500_f();
    }

    public void func_75249_e() {
        this.navigator.func_75484_a(this.path, this.farSpeed);
        PathPoint destination = this.path.func_75870_c();
        this.gecko.setHidingBush(MathHelper.func_76128_c((double)this.target.field_72450_a), MathHelper.func_76128_c((double)this.target.field_72448_b), MathHelper.func_76128_c((double)this.target.field_72449_c));
    }

    public void func_75251_c() {
        if (this.bushBound && this.path.func_75879_b()) {
            this.gecko.startHiding();
        }
        this.closestLivingEntity = null;
        this.bushBound = false;
    }

    public void func_75246_d() {
        if (this.gecko.func_70068_e(this.closestLivingEntity) < 49.0) {
            this.gecko.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.gecko.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

