/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.network.play.server.S14PacketEntity;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.network.play.server.S19PacketEntityHeadLook;
import net.minecraft.network.play.server.S1BPacketEntityAttach;
import net.minecraft.network.play.server.S1CPacketEntityMetadata;
import net.minecraft.network.play.server.S20PacketEntityProperties;
import net.minecraft.util.MathHelper;
import net.minecraft.world.storage.MapData;
import thebetweenlands.entities.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.utils.MathUtils;

public class SuperbEntityTrackerEntry
extends EntityTrackerEntry {
    private double posX;
    private double posY;
    private double posZ;
    private boolean isDataInitialized;
    private boolean sendVelocityUpdates;
    private int ticksSinceLastForcedTeleport;
    private Entity ridingEntity;
    private boolean isRidingEntity;
    private float prevRotationYaw;
    private float prevRotationPitch;

    public SuperbEntityTrackerEntry(Entity myEntity, int blockDistanceThreshold, int updateFrequency, boolean sendVelocityUpdates) {
        super(myEntity, blockDistanceThreshold, updateFrequency, sendVelocityUpdates);
        this.sendVelocityUpdates = sendVelocityUpdates;
    }

    public void func_73122_a(List players) {
        this.field_73133_n = false;
        if (!this.isDataInitialized || this.field_73132_a.func_70092_e(this.posX, this.posY, this.posZ) > 16.0) {
            this.posX = this.field_73132_a.field_70165_t;
            this.posY = this.field_73132_a.field_70163_u;
            this.posZ = this.field_73132_a.field_70161_v;
            this.isDataInitialized = true;
            this.field_73133_n = true;
            this.func_73125_b(players);
        }
        if (this.ridingEntity != this.field_73132_a.field_70154_o || this.field_73132_a.field_70154_o != null && this.field_73136_m % 60 == 0) {
            this.ridingEntity = this.field_73132_a.field_70154_o;
            this.func_151259_a((Packet)new S1BPacketEntityAttach(0, this.field_73132_a, this.field_73132_a.field_70154_o));
        }
        if (this.field_73132_a instanceof EntityItemFrame && this.field_73136_m % 10 == 0) {
            EntityItemFrame itemFrame = (EntityItemFrame)this.field_73132_a;
            ItemStack itemStack = itemFrame.func_82335_i();
            if (itemStack != null && itemStack.func_77973_b() instanceof ItemMap) {
                MapData mapData = Items.field_151098_aY.func_77873_a(itemStack, this.field_73132_a.field_70170_p);
                for (EntityPlayerMP player : players) {
                    mapData.func_76191_a((EntityPlayer)player, itemStack);
                    Packet packet = Items.field_151098_aY.func_150911_c(itemStack, this.field_73132_a.field_70170_p, (EntityPlayer)player);
                    if (packet == null) continue;
                    player.field_71135_a.func_147359_a(packet);
                }
            }
            this.sendMetadataToAllAssociatedPlayers();
        } else if (this.field_73136_m % this.field_73131_c == 0 || this.field_73132_a.field_70160_al || this.field_73132_a.func_70096_w().func_75684_a()) {
            int yaw;
            int moveThreshold;
            boolean silk = this.field_73132_a instanceof EntityWeedwoodRowboat;
            int n = moveThreshold = silk ? 1 : 4;
            if (this.field_73132_a.field_70154_o == null) {
                double min;
                double motionDeltaZ;
                double motionDeltaY;
                double motionDeltaX;
                double velocityDelta;
                boolean rotationPastThreshold;
                ++this.ticksSinceLastForcedTeleport;
                int x = this.field_73132_a.field_70168_am.func_75630_a(this.field_73132_a.field_70165_t);
                int y = MathHelper.func_76128_c((double)(this.field_73132_a.field_70163_u * 32.0));
                int z = this.field_73132_a.field_70168_am.func_75630_a(this.field_73132_a.field_70161_v);
                int yaw2 = MathUtils.degToByte(this.field_73132_a.field_70177_z);
                int pitch = MathUtils.degToByte(this.field_73132_a.field_70125_A);
                int deltaX = x - this.field_73128_d;
                int deltaY = y - this.field_73129_e;
                int deltaZ = z - this.field_73126_f;
                S18PacketEntityTeleport packet = null;
                boolean movePastThreshold = Math.abs(deltaX) >= moveThreshold || Math.abs(deltaY) >= moveThreshold || Math.abs(deltaZ) >= moveThreshold || this.field_73136_m % 60 == 0;
                boolean bl = rotationPastThreshold = silk && (Math.abs(this.field_73132_a.field_70177_z - this.prevRotationYaw) > 0.5f || Math.abs(this.field_73132_a.field_70125_A - this.prevRotationPitch) > 1.0f) || Math.abs(yaw2 - this.field_73127_g) >= 4 || Math.abs(pitch - this.field_73139_h) >= 4;
                if (this.field_73136_m > 0 || this.field_73132_a instanceof EntityArrow) {
                    if (deltaX >= -128 && deltaX < 128 && deltaY >= -128 && deltaY < 128 && deltaZ >= -128 && deltaZ < 128 && this.ticksSinceLastForcedTeleport <= 400 && !this.isRidingEntity) {
                        if (movePastThreshold && rotationPastThreshold) {
                            packet = new S14PacketEntity.S17PacketEntityLookMove(this.field_73132_a.func_145782_y(), (byte)deltaX, (byte)deltaY, (byte)deltaZ, (byte)yaw2, (byte)pitch);
                        } else if (movePastThreshold) {
                            packet = new S14PacketEntity.S15PacketEntityRelMove(this.field_73132_a.func_145782_y(), (byte)deltaX, (byte)deltaY, (byte)deltaZ);
                        } else if (rotationPastThreshold) {
                            packet = new S14PacketEntity.S16PacketEntityLook(this.field_73132_a.func_145782_y(), (byte)yaw2, (byte)pitch);
                        }
                    } else {
                        this.ticksSinceLastForcedTeleport = 0;
                        packet = new S18PacketEntityTeleport(this.field_73132_a.func_145782_y(), x, y, z, (byte)yaw2, (byte)pitch);
                    }
                }
                if (this.sendVelocityUpdates && ((velocityDelta = (motionDeltaX = this.field_73132_a.field_70159_w - this.field_73137_j) * motionDeltaX + (motionDeltaY = this.field_73132_a.field_70181_x - this.field_73138_k) * motionDeltaY + (motionDeltaZ = this.field_73132_a.field_70179_y - this.field_73135_l) * motionDeltaZ) > (min = 0.02) * min || velocityDelta > 0.0 && this.field_73132_a.field_70159_w == 0.0 && this.field_73132_a.field_70181_x == 0.0 && this.field_73132_a.field_70179_y == 0.0)) {
                    this.field_73137_j = this.field_73132_a.field_70159_w;
                    this.field_73138_k = this.field_73132_a.field_70181_x;
                    this.field_73135_l = this.field_73132_a.field_70179_y;
                    this.func_151259_a((Packet)new S12PacketEntityVelocity(this.field_73132_a.func_145782_y(), this.field_73137_j, this.field_73138_k, this.field_73135_l));
                }
                if (packet != null) {
                    this.func_151259_a((Packet)packet);
                }
                this.sendMetadataToAllAssociatedPlayers();
                if (movePastThreshold) {
                    this.field_73128_d = x;
                    this.field_73129_e = y;
                    this.field_73126_f = z;
                }
                if (rotationPastThreshold) {
                    this.field_73127_g = yaw2;
                    this.field_73139_h = pitch;
                    if (silk) {
                        this.prevRotationYaw = this.field_73132_a.field_70177_z;
                        this.prevRotationPitch = this.field_73132_a.field_70125_A;
                    }
                }
                this.isRidingEntity = false;
            } else {
                boolean rotationPastThreshold;
                yaw = MathUtils.degToByte(this.field_73132_a.field_70177_z);
                int pitch = MathUtils.degToByte(this.field_73132_a.field_70125_A);
                boolean bl = rotationPastThreshold = Math.abs(yaw - this.field_73127_g) >= 4 || Math.abs(pitch - this.field_73139_h) >= 4;
                if (rotationPastThreshold) {
                    this.func_151259_a((Packet)new S14PacketEntity.S16PacketEntityLook(this.field_73132_a.func_145782_y(), (byte)yaw, (byte)pitch));
                    this.field_73127_g = yaw;
                    this.field_73139_h = pitch;
                }
                this.field_73128_d = this.field_73132_a.field_70168_am.func_75630_a(this.field_73132_a.field_70165_t);
                this.field_73129_e = MathHelper.func_76128_c((double)(this.field_73132_a.field_70163_u * 32.0));
                this.field_73126_f = this.field_73132_a.field_70168_am.func_75630_a(this.field_73132_a.field_70161_v);
                this.sendMetadataToAllAssociatedPlayers();
                this.isRidingEntity = true;
            }
            yaw = MathUtils.degToByte(this.field_73132_a.func_70079_am());
            if (Math.abs(yaw - this.field_73140_i) >= 4) {
                this.func_151259_a((Packet)new S19PacketEntityHeadLook(this.field_73132_a, (byte)yaw));
                this.field_73140_i = yaw;
            }
            this.field_73132_a.field_70160_al = false;
        }
        ++this.field_73136_m;
        if (this.field_73132_a.field_70133_I) {
            this.func_151261_b((Packet)new S12PacketEntityVelocity(this.field_73132_a));
            this.field_73132_a.field_70133_I = false;
        }
    }

    private void sendMetadataToAllAssociatedPlayers() {
        DataWatcher dataWatcher = this.field_73132_a.func_70096_w();
        if (dataWatcher.func_75684_a()) {
            this.func_151261_b((Packet)new S1CPacketEntityMetadata(this.field_73132_a.func_145782_y(), dataWatcher, false));
        }
        if (this.field_73132_a instanceof EntityLivingBase) {
            ServersideAttributeMap attributeMap = (ServersideAttributeMap)((EntityLivingBase)this.field_73132_a).func_110140_aT();
            Set attributes = attributeMap.func_111161_b();
            if (!attributes.isEmpty()) {
                this.func_151261_b((Packet)new S20PacketEntityProperties(this.field_73132_a.func_145782_y(), (Collection)attributes));
            }
            attributes.clear();
        }
    }
}

