/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities;

import com.google.common.base.Strings;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemVolarkite;

public class EntityVolarkite
extends Entity
implements IEntityAdditionalSpawnData {
    private static Map<EntityPlayer, Integer> gliderMap = new WeakHashMap<EntityPlayer, Integer>();
    private static Map<EntityPlayer, Integer> gliderClientMap = new WeakHashMap<EntityPlayer, Integer>();
    private EntityPlayer player;
    private boolean shouldDespawn = false;

    public static Map<EntityPlayer, Integer> getMapForSide(boolean isRemote) {
        return isRemote ? gliderClientMap : gliderMap;
    }

    public static boolean isEntityHoldingGlider(Entity player) {
        return gliderClientMap.containsKey(player);
    }

    public static boolean isPlayerOnGround(Entity player) {
        Entity glider;
        Integer gliderId = gliderClientMap.get(player);
        if (gliderId != null && (glider = player.field_70170_p.func_73045_a(gliderId.intValue())) instanceof EntityVolarkite) {
            return ((EntityVolarkite)glider).isPlayerOnGround();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateGliders(World worldObj) {
        Iterator<Map.Entry<EntityPlayer, Integer>> it = gliderClientMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<EntityPlayer, Integer> next = it.next();
            EntityPlayer player = next.getKey();
            Entity entity = worldObj.func_73045_a(next.getValue().intValue());
            if (!(entity instanceof EntityVolarkite)) continue;
            EntityVolarkite glider = (EntityVolarkite)entity;
            if (player == null || player.field_70128_L || glider.field_70128_L || player.func_70694_bm() == null || !(player.func_70694_bm().func_77973_b() instanceof ItemVolarkite) || player.field_70170_p.field_73011_w.field_76574_g != glider.field_70170_p.field_73011_w.field_76574_g) {
                glider.func_70106_y();
                it.remove();
                continue;
            }
            glider.fixPositions((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    public EntityVolarkite(World world) {
        super(world);
    }

    public EntityVolarkite(World world, EntityPlayer player) {
        this(world);
        this.player = player;
        gliderMap.put(player, this.func_145782_y());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(2, (Object)0);
    }

    public void despawnGlider() {
        this.shouldDespawn = true;
    }

    public boolean isPlayerOnGround() {
        return this.field_70180_af.func_75683_a(2) == 1;
    }

    public void func_70071_h_() {
        if (this.player == null) {
            this.func_70106_y();
        } else {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(2, (Object)((byte)(this.player.field_70122_E ? 1 : 0)));
            }
            ItemStack held = this.player.func_70694_bm();
            if (this.player.field_70128_L || held == null || held.func_77973_b() == null || held.func_77973_b() != BLItemRegistry.volarkite || this.shouldDespawn || this.player.field_71093_bK != this.field_71093_bK) {
                EntityVolarkite.getMapForSide(this.field_70170_p.field_72995_K).remove(this.player);
                this.func_70106_y();
            } else {
                this.fixPositions();
                double horizontalSpeed = 0.03;
                double verticalSpeed = 0.4;
                if (this.player.func_70093_af()) {
                    horizontalSpeed = 0.1;
                    verticalSpeed = 0.7;
                }
                if (!this.player.field_70122_E && this.player.field_70181_x < 0.0) {
                    this.player.field_70181_x *= verticalSpeed;
                    this.field_70181_x *= verticalSpeed;
                    double x = Math.cos(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
                    double z = Math.sin(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
                    this.player.field_70159_w += x;
                    this.player.field_70179_y += z;
                    this.player.field_70143_R = 0.0f;
                }
            }
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    private void fixPositions(EntityPlayer thePlayer) {
        if (this.player != null) {
            this.field_70142_S = this.field_70169_q = this.player.field_70169_q;
            this.field_70137_T = this.field_70167_r = this.player.field_70167_r;
            this.field_70136_U = this.field_70166_s = this.player.field_70166_s;
            this.field_70165_t = this.player.field_70165_t;
            this.field_70163_u = this.player.field_70163_u;
            this.field_70161_v = this.player.field_70161_v;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70126_B = this.player.field_70760_ar;
            this.field_70177_z = this.player.field_70761_aq;
            this.field_70127_C = this.player.field_70127_C;
            this.field_70125_A = this.player.field_70125_A;
            if (this.player != thePlayer) {
                this.field_70163_u += 1.2;
                this.field_70167_r += 1.2;
                this.field_70137_T += 1.2;
            }
            this.field_70159_w = this.field_70165_t - this.field_70169_q;
            this.field_70181_x = this.field_70163_u - this.field_70167_r;
            this.field_70179_y = this.field_70161_v - this.field_70166_s;
        }
    }

    public void fixPositions() {
        this.fixPositions(null);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)(this.player != null ? this.player.func_70005_c_() : ""));
    }

    public void readSpawnData(ByteBuf data) {
        String username = ByteBufUtils.readUTF8String((ByteBuf)data);
        if (Strings.isNullOrEmpty((String)username)) {
            this.func_70106_y();
        } else {
            this.player = this.field_70170_p.func_72924_a(username);
            gliderClientMap.put(this.player, this.func_145782_y());
        }
    }
}

