/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityShockwaveBlock
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int OWNER_DW = 18;
    public Block blockID;
    public int blockMeta;
    public int originX;
    public int originY;
    public int originZ;
    public int jumpDelay;
    private double waveStartX;
    private double waveStartZ;

    public EntityShockwaveBlock(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.setBlock(Blocks.field_150348_b, 0);
    }

    public void setBlock(Block blockID, int blockMeta) {
        this.blockID = blockID;
        this.blockMeta = blockMeta;
    }

    public void setOwner(String ownerUUID) {
        this.field_70180_af.func_75692_b(18, (Object)ownerUUID);
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(18);
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID p_152378_1_) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!p_152378_1_.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70128_L || this.func_70011_f((double)this.originX + 0.5, this.originY, (double)this.originZ + 0.5) > 2.0) && this.field_70170_p.func_147437_c(this.originX, this.originY, this.originZ)) {
            this.field_70170_p.func_147465_d(this.originX, this.originY, this.originZ, this.blockID, this.blockMeta, 3);
        }
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70165_t = this.field_70142_S;
        this.field_70161_v = this.field_70136_U;
        this.field_70160_al = true;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == this.jumpDelay) {
                this.field_70181_x += 0.5;
            }
            if (this.field_70173_aa > this.jumpDelay) {
                this.field_70181_x -= 0.15;
                if (this.field_70163_u <= (double)this.originY || this.field_70122_E) {
                    this.field_70170_p.func_147465_d(this.originX, this.originY, this.originZ, this.blockID, this.blockMeta, 3);
                    this.func_70106_y();
                }
            }
        }
        if (this.field_70181_x > 0.1 && !this.field_70170_p.field_72995_K) {
            Entity owner = this.getOwner();
            Object damageSource = owner != null ? new EntityDamageSourceIndirect("player", (Entity)this, owner) : DamageSource.field_76377_j;
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D);
            for (EntityLivingBase entity : entities) {
                if (entity == null || !(entity instanceof EntityLivingBase) || !entity.func_70097_a(damageSource, 10.0f)) continue;
                float knockback = 1.5f;
                Vec3 dir = Vec3.func_72443_a((double)(this.field_70165_t - this.waveStartX), (double)0.0, (double)(this.field_70161_v - this.waveStartZ));
                dir = dir.func_72432_b();
                entity.field_70159_w = dir.field_72450_a * (double)knockback;
                entity.field_70181_x = 0.5;
                entity.field_70179_y = dir.field_72449_c * (double)knockback;
            }
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void func_70106_y() {
        if (this.field_70170_p.func_147437_c(this.originX, this.originY, this.originZ)) {
            this.field_70170_p.func_147465_d(this.originX, this.originY, this.originZ, this.blockID, this.blockMeta, 3);
        }
        super.func_70106_y();
    }

    public boolean func_70072_I() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(Block.func_149682_b((Block)this.blockID));
        data.writeInt(this.blockMeta);
    }

    public void readSpawnData(ByteBuf data) {
        this.blockID = Block.func_149729_e((int)data.readInt());
        this.blockMeta = data.readInt();
    }

    public void setOrigin(int x, int y, int z, int delay, double waveStartX, double waveStartZ, Entity source) {
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.jumpDelay = delay;
        this.waveStartX = waveStartX;
        this.waveStartZ = waveStartZ;
        this.setOwner(source.func_110124_au().toString());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(18, (Object)"");
    }

    protected void func_70037_a(NBTTagCompound data) {
        this.blockID = Block.func_149729_e((int)data.func_74762_e("blockID"));
        this.blockMeta = data.func_74762_e("blockMeta");
        this.originX = data.func_74762_e("originX");
        this.originY = data.func_74762_e("originY");
        this.originZ = data.func_74762_e("originZ");
        this.waveStartX = data.func_74769_h("waveStartX");
        this.waveStartZ = data.func_74769_h("waveStartZ");
        this.jumpDelay = data.func_74762_e("jumpDelay");
        this.setOwner(data.func_74779_i("ownerUUID"));
    }

    protected void func_70014_b(NBTTagCompound data) {
        data.func_74768_a("blockID", Block.func_149682_b((Block)this.blockID));
        data.func_74768_a("blockMeta", this.blockMeta);
        data.func_74768_a("originX", this.originX);
        data.func_74768_a("originY", this.originY);
        data.func_74768_a("originZ", this.originZ);
        data.func_74780_a("waveStartX", this.waveStartX);
        data.func_74780_a("waveStartZ", this.waveStartZ);
        data.func_74768_a("jumpDelay", this.jumpDelay);
        data.func_74778_a("ownerUUID", this.getOwnerUUID());
    }
}

