/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities;

import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.items.BLItemRegistry;

public class EntityRopeNode
extends Entity {
    public static final double ROPE_LENGTH = 4.0;
    public static final double ROPE_LENGTH_MAX = 12.0;
    private boolean canExtend = true;
    private boolean pickUp = false;
    private String prevNodeUUID = "";
    private String nextNodeUUID = "";
    private int despawnTimer = 0;

    public EntityRopeNode(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70155_l = 20.0;
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(19, (Object)-1);
        this.field_70180_af.func_75682_a(20, (Object)-1);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setNextNodeUUID(nbt.func_74764_b("nextNodeUUID") ? nbt.func_74779_i("nextNodeUUID") : null);
        this.setPreviousNodeUUID(nbt.func_74764_b("previousNodeUUID") ? nbt.func_74779_i("previousNodeUUID") : null);
        this.pickUp = nbt.func_74767_n("pickUp");
        this.canExtend = nbt.func_74767_n("canExtend");
        this.despawnTimer = nbt.func_74762_e("despawnTimer");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("nextNodeUUID", this.getNextNodeUUID());
        nbt.func_74778_a("previousNodeUUID", this.getPreviousNodeUUID());
        nbt.func_74757_a("pickUp", this.pickUp);
        nbt.func_74757_a("canExtend", this.canExtend);
        nbt.func_74768_a("despawnTimer", this.despawnTimer);
    }

    public void func_70030_z() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70072_I();
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.getNextNodeByUUID() != null) {
                this.field_70180_af.func_75692_b(19, (Object)this.getNextNodeByUUID().func_145782_y());
            } else {
                this.field_70180_af.func_75692_b(19, (Object)-1);
            }
            if (this.getPreviousNodeByUUID() != null) {
                this.field_70180_af.func_75692_b(20, (Object)this.getPreviousNodeByUUID().func_145782_y());
            } else {
                this.field_70180_af.func_75692_b(20, (Object)-1);
            }
            Entity nextNode = this.getNextNode();
            Entity prevNode = this.getPreviousNode();
            if (nextNode != null && nextNode instanceof EntityPlayer) {
                if ((double)nextNode.func_70032_d((Entity)this) > 1.5) {
                    this.pickUp = true;
                }
                if (this.pickUp && (double)nextNode.func_70032_d((Entity)this) < 1.4) {
                    this.removeNode(nextNode);
                    EntityPlayer player = (EntityPlayer)nextNode;
                    if (!player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.cavingRope, 1))) {
                        EntityItem itemEntity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(BLItemRegistry.cavingRope, 1));
                        itemEntity.field_145804_b = 0;
                        this.field_70170_p.func_72838_d((Entity)itemEntity);
                    }
                }
                if ((double)nextNode.func_70032_d((Entity)this) < 3.0) {
                    this.canExtend = true;
                }
                if (this.canExtend && (double)nextNode.func_70032_d((Entity)this) > 5.0) {
                    InventoryPlayer inventory = ((EntityPlayer)nextNode).field_71071_by;
                    int invSize = inventory.func_70302_i_();
                    for (int i = 0; i < invSize; ++i) {
                        ItemStack stack = inventory.func_70301_a(i);
                        if (stack == null || stack.func_77973_b() != BLItemRegistry.cavingRope) continue;
                        --stack.field_77994_a;
                        inventory.func_70299_a(i, (ItemStack)(stack.field_77994_a > 0 ? stack : null));
                        Vec3 connection = this.getConnectionToNext();
                        connection = connection.func_72432_b();
                        this.extendRope(nextNode, nextNode.field_70165_t, nextNode.field_70163_u + 0.1, nextNode.field_70161_v);
                        break;
                    }
                }
                if ((double)nextNode.func_70032_d((Entity)this) > 12.0) {
                    if (nextNode instanceof ICommandSender) {
                        ((ICommandSender)nextNode).func_145747_a((IChatComponent)new ChatComponentTranslation("chat.rope.disconnected", new Object[0]));
                    }
                    this.setNextNode(null);
                }
            }
            this.field_70181_x *= 0.88;
            this.field_70159_w *= 0.88;
            this.field_70179_y *= 0.88;
            if (!(this.isAttached() || this.field_70122_E || this.field_70171_ac)) {
                Vec3 diff;
                Vec3 constrainedPoint;
                Vec3 tetherPoint;
                Vec3 nextPoint;
                double mz;
                boolean isFloating = false;
                if (nextNode != null && (double)this.func_70032_d(nextNode) >= 4.0) {
                    Vec3 connection = this.getConnectionToNext();
                    double mx = MathHelper.func_151237_a((double)(connection.field_72450_a * 0.02), (double)-0.5, (double)0.5);
                    double my = MathHelper.func_151237_a((double)(connection.field_72448_b * 0.02), (double)-0.5, (double)0.5);
                    double mz2 = MathHelper.func_151237_a((double)(connection.field_72449_c * 0.02), (double)-0.5, (double)0.5);
                    if (prevNode != null && prevNode.func_70011_f(this.field_70165_t + mx, this.field_70163_u + my, this.field_70161_v + mz2) < 5.0) {
                        this.field_70159_w += mx;
                        this.field_70179_y += mz2;
                        this.field_70181_x += my;
                        isFloating = true;
                    }
                }
                if (!isFloating) {
                    this.field_70181_x -= 0.1;
                }
                if (nextNode != null) {
                    double mx = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.5, (double)0.5);
                    double my = MathHelper.func_151237_a((double)this.field_70181_x, (double)-0.5, (double)0.5);
                    mz = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.5, (double)0.5);
                    nextPoint = Vec3.func_72443_a((double)(this.field_70165_t + mx), (double)(this.field_70163_u + my), (double)(this.field_70161_v + mz));
                    tetherPoint = Vec3.func_72443_a((double)nextNode.field_70165_t, (double)nextNode.field_70163_u, (double)nextNode.field_70161_v);
                    if (tetherPoint.func_72438_d(nextPoint) >= 4.0) {
                        constrainedPoint = nextPoint.func_72444_a(tetherPoint).func_72432_b();
                        constrainedPoint = Vec3.func_72443_a((double)(constrainedPoint.field_72450_a * -4.0), (double)(constrainedPoint.field_72448_b * -4.0), (double)(constrainedPoint.field_72449_c * -4.0)).func_72441_c(tetherPoint.field_72450_a, tetherPoint.field_72448_b, tetherPoint.field_72449_c);
                        diff = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72444_a(constrainedPoint);
                        this.field_70159_w = diff.field_72450_a;
                        this.field_70181_x = diff.field_72448_b;
                        this.field_70179_y = diff.field_72449_c;
                    }
                }
                if (prevNode != null) {
                    double mx = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.5, (double)0.5);
                    double my = MathHelper.func_151237_a((double)this.field_70181_x, (double)-0.5, (double)0.5);
                    mz = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.5, (double)0.5);
                    nextPoint = Vec3.func_72443_a((double)(this.field_70165_t + mx), (double)(this.field_70163_u + my), (double)(this.field_70161_v + mz));
                    tetherPoint = Vec3.func_72443_a((double)prevNode.field_70165_t, (double)prevNode.field_70163_u, (double)prevNode.field_70161_v);
                    if (tetherPoint.func_72438_d(nextPoint) >= 4.0) {
                        constrainedPoint = nextPoint.func_72444_a(tetherPoint).func_72432_b();
                        constrainedPoint = Vec3.func_72443_a((double)(constrainedPoint.field_72450_a * -4.0), (double)(constrainedPoint.field_72448_b * -4.0), (double)(constrainedPoint.field_72449_c * -4.0)).func_72441_c(tetherPoint.field_72450_a, tetherPoint.field_72448_b, tetherPoint.field_72449_c);
                        diff = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72444_a(constrainedPoint);
                        this.field_70159_w = diff.field_72450_a;
                        this.field_70181_x = diff.field_72448_b;
                        this.field_70179_y = diff.field_72449_c;
                    }
                }
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (nextNode == null) {
                if (prevNode == null) {
                    this.func_70076_C();
                } else {
                    ++this.despawnTimer;
                    if (this.despawnTimer >= 12000) {
                        if (prevNode != null && prevNode instanceof EntityRopeNode) {
                            EntityRopeNode prevRopeNode = (EntityRopeNode)prevNode;
                            prevRopeNode.setNextNode(null);
                            prevRopeNode.despawn();
                        }
                        this.func_70076_C();
                    }
                }
            } else {
                this.despawnTimer = 0;
            }
        }
    }

    public boolean func_130002_c(EntityPlayer player) {
        Entity nextNode = this.getNextNode();
        Entity prevNode = this.getPreviousNode();
        if (prevNode != null) {
            if (nextNode == null) {
                EntityRopeNode connectedRopeNode = null;
                for (Entity e : player.field_70170_p.field_72996_f) {
                    EntityRopeNode ropeNode;
                    if (!(e instanceof EntityRopeNode) || (ropeNode = (EntityRopeNode)e).getNextNode() != player) continue;
                    connectedRopeNode = ropeNode;
                    break;
                }
                if (connectedRopeNode != null) {
                    if (player.field_70170_p.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.rope.already_connected", new Object[0]));
                    }
                    return false;
                }
                if (!player.field_70170_p.field_72995_K) {
                    this.setNextNode((Entity)player);
                }
                return true;
            }
            if (!(nextNode instanceof EntityRopeNode)) {
                if (!player.field_70170_p.field_72995_K) {
                    this.setNextNode(null);
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void removeNode(Entity nextConnectionNode) {
        Entity nextNode = this.getNextNode();
        Entity prevNode = this.getPreviousNode();
        if (prevNode != null && prevNode instanceof EntityRopeNode) {
            ((EntityRopeNode)prevNode).setNextNode(nextConnectionNode);
            ((EntityRopeNode)prevNode).canExtend = false;
        }
        this.func_70076_C();
    }

    public void despawn() {
        this.despawnTimer = 12000;
    }

    public boolean isAttached() {
        return !this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D.func_72314_b(0.1, 0.1, 0.1)).isEmpty();
    }

    public EntityRopeNode extendRope(Entity entity, double x, double y, double z) {
        EntityRopeNode ropeNode = new EntityRopeNode(this.field_70170_p);
        ropeNode.func_70012_b(x, y, z, 0.0f, 0.0f);
        ropeNode.setPreviousNode(this);
        ropeNode.setNextNode(entity);
        this.setNextNode(ropeNode);
        this.field_70170_p.func_72838_d((Entity)ropeNode);
        return ropeNode;
    }

    public Vec3 getConnectionToNext() {
        Entity nextNode = this.getNextNode();
        if (nextNode != null) {
            return Vec3.func_72443_a((double)(nextNode.field_70165_t - this.field_70165_t), (double)(nextNode.field_70163_u - this.field_70163_u), (double)(nextNode.field_70161_v - this.field_70161_v));
        }
        return null;
    }

    public void setNextNodeUUID(String uuid) {
        this.nextNodeUUID = uuid;
    }

    public String getNextNodeUUID() {
        return this.nextNodeUUID;
    }

    public void setNextNode(Entity entity) {
        this.setNextNodeUUID(entity == null ? "" : entity.func_110124_au().toString());
    }

    private Entity getNextNodeByUUID() {
        try {
            UUID uuid = UUID.fromString(this.getNextNodeUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void setPreviousNodeUUID(String uuid) {
        this.prevNodeUUID = uuid;
    }

    public String getPreviousNodeUUID() {
        return this.prevNodeUUID;
    }

    public void setPreviousNode(Entity entity) {
        this.setPreviousNodeUUID(entity == null ? "" : entity.func_110124_au().toString());
    }

    private Entity getPreviousNodeByUUID() {
        try {
            UUID uuid = UUID.fromString(this.getPreviousNodeUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public Entity getNextNode() {
        return this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(19));
    }

    public Entity getPreviousNode() {
        return this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(20));
    }

    private Entity getEntityByUUID(UUID uuid) {
        for (Entity entity : this.field_70170_p.field_72996_f) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }
}

