/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.decay;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumDifficulty;

public class DecayStats {
    private int decayLevel = 20;
    private float decaySaturationLevel = 5.0f;
    private float decayExhaustionLevel;
    private int prevDecayLevel = 20;

    public void addStats(int decay, float saturationModifier) {
        this.decayLevel = Math.min(decay + this.decayLevel, 20);
        this.decaySaturationLevel = Math.min(this.decaySaturationLevel + (float)decay * saturationModifier * 2.0f, (float)this.decayLevel / 4.0f);
    }

    public void onUpdate(EntityPlayer player) {
        EnumDifficulty difficulty = player.field_70170_p.field_73013_u;
        this.prevDecayLevel = this.decayLevel;
        if (this.decayExhaustionLevel > 4.0f) {
            this.decayExhaustionLevel -= 4.0f;
            if (this.decaySaturationLevel > 0.0f) {
                this.decaySaturationLevel = Math.max(this.decaySaturationLevel - 1.0f, 0.0f);
            } else if (difficulty != EnumDifficulty.PEACEFUL) {
                this.decayLevel = Math.max(this.decayLevel - 1, 0);
            }
        }
        if (player.func_70090_H()) {
            this.addExhaustion(0.0038f);
        } else {
            this.addExhaustion(0.0024f);
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("decayLevel", 99)) {
            this.decayLevel = nbt.func_74762_e("decayLevel");
            this.decaySaturationLevel = nbt.func_74760_g("decaySaturationLevel");
            this.decayExhaustionLevel = nbt.func_74760_g("decayExhaustionLevel");
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("decayLevel", this.decayLevel);
        nbt.func_74776_a("decaySaturationLevel", this.decaySaturationLevel);
        nbt.func_74776_a("decayExhaustionLevel", this.decayExhaustionLevel);
    }

    public int getDecayLevel() {
        return this.decayLevel;
    }

    public int getPrevDecayLevel() {
        return this.prevDecayLevel;
    }

    public void addExhaustion(float decayExhaustion) {
        this.decayExhaustionLevel = Math.min(this.decayExhaustionLevel + decayExhaustion, 40.0f);
    }

    public float getSaturationLevel() {
        return this.decaySaturationLevel;
    }

    public float getExhaustionLevel() {
        return this.decayExhaustionLevel;
    }

    public void setDecayLevel(int decay) {
        this.decayLevel = decay;
    }

    public void setDecaySaturationLevel(float saturation) {
        this.decaySaturationLevel = saturation;
    }
}

