/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.decay;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import thebetweenlands.decay.DecayStats;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesDecay;
import thebetweenlands.lib.ModInfo;

public class DecayManager {
    public static DecayStats getDecayStats(EntityPlayer player) {
        EntityPropertiesDecay property = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)player, EntityPropertiesDecay.class);
        if (property != null) {
            return property.decayStats;
        }
        return null;
    }

    public static int getDecayLevel(EntityPlayer player) {
        DecayStats stats = DecayManager.getDecayStats(player);
        if (stats != null) {
            return stats.getDecayLevel();
        }
        return 0;
    }

    public static void setDecayLevel(int decayLevel, EntityPlayer player) {
        DecayStats stats;
        if (decayLevel < 0) {
            return;
        }
        if (!player.field_70170_p.field_72995_K && (stats = DecayManager.getDecayStats(player)) != null) {
            stats.setDecayLevel(decayLevel > 20 ? 20 : (decayLevel < 0 ? 0 : decayLevel));
        }
    }

    public static void resetDecay(EntityPlayer player) {
        DecayManager.setDecayLevel(0, player);
    }

    public static float getPlayerHearts(EntityPlayer player) {
        return Math.min(26.0f - (float)(20 - DecayManager.getDecayLevel(player)), 20.0f);
    }

    public static boolean isDecayEnabled(EntityPlayer player) {
        return player.field_71093_bK == ModInfo.DIMENSION_ID && !player.field_71075_bZ.field_75098_d && !player.field_71075_bZ.field_75102_a;
    }

    public static int getCorruptionLevel(EntityPlayer player) {
        if (!DecayManager.isDecayEnabled(player)) {
            return 0;
        }
        return 10 - DecayManager.getDecayLevel(player) / 2;
    }
}

