/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.core;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TheBetweenlandsClassTransformer
implements IClassTransformer {
    public static boolean constructed;
    public static final String SLEEP_PER_TICK = "sleepPerTick";
    private static final String BL_FORGE_HOOKS = "thebetweenlands/forgeevent/BLForgeHooks";
    private static final String BL_FORGE_HOOKS_CLIENT = "thebetweenlands/forgeevent/BLForgeHooksClient";
    private static final String DEBUG_HANDLER_CLIENT = "thebetweenlands/event/debugging/DebugHandlerClient";
    private static final String PERSPECTIVE = "thebetweenlands/client/perspective/Perspective";
    private static final String SUPERB_ENTITY_TRACKER_ENTRY = "thebetweenlands/entities/SuperbEntityTrackerEntry";

    public TheBetweenlandsClassTransformer() {
        constructed = true;
    }

    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        if ("net.minecraft.server.MinecraftServer".equals(name)) {
            return this.writeClass(this.transformMinecraftServer(this.readClass(classBytes)));
        }
        boolean obf = "yz".equals(name);
        if (obf || "net.minecraft.entity.player.EntityPlayer".equals(name)) {
            return this.writeClass(this.transformEntityPlayer(this.readClass(classBytes), obf));
        }
        obf = "sv".equals(name);
        if (obf || "net.minecraft.entity.EntityLivingBase".equals(name)) {
            return this.writeClass(this.transformEntityLivingBase(this.readClass(classBytes), obf));
        }
        obf = "bao".equals(name);
        if (obf || "net.minecraft.client.Minecraft".equals(name)) {
            return this.writeClass(this.transformMinecraft(this.readClass(classBytes), obf));
        }
        obf = "bdw".equals(name);
        if (obf || "net.minecraft.client.gui.GuiScreen".equals(name)) {
            return this.writeClass(this.transformGuiScreen(this.readClass(classBytes), obf));
        }
        obf = "oi".equals(name);
        if (obf || "net.minecraft.server.management.ServerConfigurationManager".equals(name)) {
            return this.writeClass(this.transformServerConfigurationManager(this.readClass(classBytes), obf));
        }
        obf = "baj".equals(name);
        if (obf || "net.minecraft.client.renderer.ActiveRenderInfo".equals(name)) {
            return this.writeClass(this.transformActiveRenderInfo(this.readClass(classBytes), obf));
        }
        obf = "blt".equals(name);
        if (obf || "net.minecraft.client.renderer.EntityRenderer".equals(name)) {
            return this.writeClass(this.transformEntityRenderer(this.readClass(classBytes), obf));
        }
        obf = "bnn".equals(name);
        if (obf || "net.minecraft.client.renderer.entity.RenderManager".equals(name)) {
            return this.writeClass(this.transformRenderManager(this.readClass(classBytes), obf));
        }
        obf = "sa".equals(name);
        if (obf || "net.minecraft.entity.Entity".equals(name)) {
            return this.writeClass(this.transformEntity(this.readClass(classBytes), obf));
        }
        if ("net.minecraft.command.CommandWeather".equals(name)) {
            // empty if block
        }
        if ((obf = "mn".equals(name)) || "net.minecraft.entity.EntityTracker".equals(name)) {
            return this.writeClass(this.transformEntityTracker(this.readClass(classBytes), obf));
        }
        return classBytes;
    }

    private ClassNode readClass(byte[] classBytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] writeClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private ClassNode transformMinecraftServer(ClassNode classNode) {
        FieldNode sleepPerTickField = new FieldNode(1, SLEEP_PER_TICK, "J", null, null);
        classNode.fields.add(sleepPerTickField);
        boolean needsRun = true;
        boolean needsInit = true;
        for (MethodNode method : classNode.methods) {
            if (needsInit && "<init>".equals(method.name)) {
                needsInit = false;
                for (int i = 0; i < method.instructions.size(); ++i) {
                    AbstractInsnNode insnNode = method.instructions.get(i);
                    if (insnNode.getOpcode() != 177) continue;
                    InsnList initSleepPerTickInsns = new InsnList();
                    initSleepPerTickInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    initSleepPerTickInsns.add((AbstractInsnNode)new LdcInsnNode((Object)50L));
                    initSleepPerTickInsns.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/server/MinecraftServer", SLEEP_PER_TICK, "J"));
                    method.instructions.insertBefore(insnNode, initSleepPerTickInsns);
                    break;
                }
            }
            if (needsRun && "run".equals(method.name)) {
                needsRun = false;
                Long fifty = 50L;
                for (int i = 0; i < method.instructions.size(); ++i) {
                    AbstractInsnNode insnNode = method.instructions.get(i);
                    if (insnNode.getType() != 9 || !fifty.equals(((LdcInsnNode)insnNode).cst)) continue;
                    InsnList accessSleepPerTickInsns = new InsnList();
                    accessSleepPerTickInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    accessSleepPerTickInsns.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/server/MinecraftServer", SLEEP_PER_TICK, "J"));
                    method.instructions.insert(insnNode, accessSleepPerTickInsns);
                    method.instructions.remove(insnNode);
                    break;
                }
            }
            if (needsRun || needsInit) continue;
            break;
        }
        return classNode;
    }

    private ClassNode transformEntityPlayer(ClassNode classNode, boolean obf) {
        String getHurtSoundName = obf ? "aT" : "getHurtSound";
        String entityPlayerClass = obf ? "yz" : "net/minecraft/entity/player/EntityPlayer";
        for (MethodNode method : classNode.methods) {
            if (!getHurtSoundName.equals(method.name) || !"()Ljava/lang/String;".equals(method.desc)) continue;
            InsnList insns = method.instructions;
            insns.clear();
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insns.add((AbstractInsnNode)new MethodInsnNode(184, BL_FORGE_HOOKS, "onPlayerGetHurtSound", String.format("(L%s;)Ljava/lang/String;", entityPlayerClass), false));
            insns.add((AbstractInsnNode)new InsnNode(176));
            break;
        }
        return classNode;
    }

    private ClassNode transformEntityLivingBase(ClassNode classNode, boolean obf) {
        String setAttackTargetName = obf ? "b" : "setRevengeTarget";
        String entityLivingBaseClass = obf ? "sv" : "net/minecraft/entity/EntityLivingBase";
        String setAttackTargetDescription = String.format("(L%s;)V", entityLivingBaseClass);
        block0: for (MethodNode method : classNode.methods) {
            if (!setAttackTargetName.equals(method.name) || !setAttackTargetDescription.equals(method.desc)) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode insnNode = method.instructions.get(i);
                if (insnNode.getType() != 5) continue;
                MethodInsnNode methodNode = (MethodInsnNode)insnNode;
                methodNode.owner = BL_FORGE_HOOKS;
                methodNode.name = "onLivingSetRevengeTarget";
                break block0;
            }
        }
        return classNode;
    }

    private ClassNode transformMinecraft(ClassNode classNode, boolean obf) {
        String startGame = obf ? "ag" : "startGame";
        String runGameLoop = obf ? "ak" : "runGameLoop";
        String thirdPersonView = obf ? "aw" : "thirdPersonView";
        String runTick = obf ? "p" : "runTick";
        String isPressed = obf ? "f" : "isPressed";
        String handlePlayerAttackInput = obf ? "al" : "func_147116_af";
        String handleBlockBreakingInput = obf ? "a" : "func_147115_a";
        String minecraft = obf ? "bao" : "net/minecraft/client/Minecraft";
        String leftClickCounter = obf ? "U" : "leftClickCounter";
        boolean needsStartGame = true;
        boolean needsRunGameLoop = true;
        boolean needsRunTick = true;
        boolean needsHandlePlayerAttackInput = true;
        boolean needsHandleBlockBreakingInput = true;
        for (MethodNode method : classNode.methods) {
            AbstractInsnNode insnNode;
            int i;
            if (needsStartGame && startGame.equals(method.name) && "()V".equals(method.desc)) {
                for (i = method.instructions.size() - 1; i >= 0; --i) {
                    insnNode = method.instructions.get(i);
                    if (insnNode.getOpcode() != 177) continue;
                    method.instructions.insertBefore(insnNode, (AbstractInsnNode)new MethodInsnNode(184, DEBUG_HANDLER_CLIENT, "onMinecraftFinishedStarting", "()V", false));
                    break;
                }
                needsStartGame = false;
            }
            if (needsRunGameLoop && runGameLoop.equals(method.name) && "()V".equals(method.desc)) {
                for (i = method.instructions.size() - 1; i >= 0; --i) {
                    insnNode = method.instructions.get(i);
                    if (insnNode.getOpcode() != 181 || !thirdPersonView.equals(((FieldInsnNode)insnNode).name)) continue;
                    method.instructions.set(insnNode.getPrevious(), (AbstractInsnNode)new MethodInsnNode(184, PERSPECTIVE, "getInsideOpaqueBlockView", "()I", false));
                    break;
                }
                needsRunGameLoop = false;
            }
            if (needsRunTick && runTick.equals(method.name) && "()V".equals(method.desc)) {
                block3: for (i = 0; i < method.instructions.size(); ++i) {
                    insnNode = method.instructions.get(i);
                    if (insnNode.getOpcode() != 182 || !isPressed.equals(((MethodInsnNode)insnNode).name)) continue;
                    ListIterator insns = method.instructions.iterator(i + 6);
                    while (insns.hasNext()) {
                        insnNode = (AbstractInsnNode)insns.next();
                        if (insnNode.getOpcode() == 3) {
                            method.instructions.set(insnNode, (AbstractInsnNode)new MethodInsnNode(184, PERSPECTIVE, "cyclePerspective", "()I", false));
                            break block3;
                        }
                        insns.remove();
                    }
                    break;
                }
                needsRunTick = false;
            }
            if (needsHandlePlayerAttackInput && handlePlayerAttackInput.equals(method.name) && "()V".equals(method.desc)) {
                method.localVariables.clear();
                method.instructions.clear();
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new InsnNode(89));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, minecraft, leftClickCounter, "I"));
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, BL_FORGE_HOOKS_CLIENT, "handlePlayerAttackInput", "(I)I", false));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, minecraft, leftClickCounter, "I"));
                method.instructions.add((AbstractInsnNode)new InsnNode(177));
                needsHandlePlayerAttackInput = false;
            }
            if (needsHandleBlockBreakingInput && handleBlockBreakingInput.equals(method.name) && "(Z)V".equals(method.desc)) {
                method.localVariables.clear();
                method.instructions.clear();
                method.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, minecraft, leftClickCounter, "I"));
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, BL_FORGE_HOOKS_CLIENT, "handleBlockBreakingInput", "(ZI)I", false));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new InsnNode(95));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, minecraft, leftClickCounter, "I"));
                method.instructions.add((AbstractInsnNode)new InsnNode(177));
                needsHandleBlockBreakingInput = false;
            }
            if (needsRunGameLoop || needsStartGame || needsRunTick || needsHandlePlayerAttackInput) continue;
            break;
        }
        return classNode;
    }

    private ClassNode transformGuiScreen(ClassNode classNode, boolean obf) {
        String handleInputName = obf ? "p" : "handleInput";
        String handleKeyboardInputName = obf ? "l" : "handleKeyboardInput";
        block0: for (MethodNode method : classNode.methods) {
            if (!handleInputName.equals(method.name) || !"()V".equals(method.desc)) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode insnNode = method.instructions.get(i);
                if (insnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                if (!handleKeyboardInputName.equals(methodInsnNode.name) || !"()V".equals(methodInsnNode.desc)) continue;
                InsnList insns = new InsnList();
                insns.add((AbstractInsnNode)new FieldInsnNode(178, DEBUG_HANDLER_CLIENT, "INSTANCE", "Lthebetweenlands/event/debugging/DebugHandlerClient;"));
                insns.add((AbstractInsnNode)new InsnNode(1));
                insns.add((AbstractInsnNode)new MethodInsnNode(182, DEBUG_HANDLER_CLIENT, "onKeyInput", "(Lcpw/mods/fml/common/gameevent/InputEvent$KeyInputEvent;)V", false));
                method.instructions.insert(insnNode, insns);
                break block0;
            }
        }
        return classNode;
    }

    private ClassNode transformServerConfigurationManager(ClassNode classNode, boolean obf) {
        String createPlayerForUserName = obf ? "f" : "createPlayerForUser";
        String entityPlayerMPClass = obf ? "mw" : "net/minecraft/entity/player/EntityPlayerMP";
        String createPlayerForUserDescription = String.format("(Lcom/mojang/authlib/GameProfile;)L%s;", entityPlayerMPClass);
        String serverConfigurationManagerClass = obf ? "oi" : "net/minecraft/server/management/ServerConfigurationManager";
        for (MethodNode method : classNode.methods) {
            if (!createPlayerForUserName.equals(method.name) || !createPlayerForUserDescription.equals(method.desc)) continue;
            method.instructions.clear();
            method.localVariables.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, BL_FORGE_HOOKS, "createPlayerForUser", String.format("(L%s;Lcom/mojang/authlib/GameProfile;)L%s;", serverConfigurationManagerClass, entityPlayerMPClass), false));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
            break;
        }
        return classNode;
    }

    private ClassNode transformActiveRenderInfo(ClassNode classNode, boolean obf) {
        String owner = obf ? "baj" : "net/minecraft/client/renderer/ActiveRenderInfo";
        String viewport = obf ? "i" : "viewport";
        String modelview = obf ? "j" : "modelview";
        String projection = obf ? "k" : "projection";
        String objectCoords = obf ? "l" : "objectCoords";
        String updateRenderInfo = obf ? "a" : "updateRenderInfo";
        String updateRenderInfoDesc = obf ? "(Lyz;Z)V" : "(Lnet/minecraft/entity/player/EntityPlayer;Z)V";
        String fbDesc = "Ljava/nio/FloatBuffer;";
        String ibDesc = "Ljava/nio/IntBuffer;";
        block0: for (MethodNode method : classNode.methods) {
            if (!updateRenderInfo.equals(method.name) || !updateRenderInfoDesc.equals(method.desc)) continue;
            InsnList instructions = method.instructions;
            for (int i = 0; i < instructions.size(); ++i) {
                AbstractInsnNode insnNode = instructions.get(i);
                if (insnNode.getOpcode() != 21) continue;
                ListIterator iter = instructions.iterator(i);
                while (iter.hasNext()) {
                    insnNode = (AbstractInsnNode)iter.next();
                    if (insnNode.getOpcode() == 177) {
                        InsnList invocation = new InsnList();
                        invocation.add((AbstractInsnNode)new VarInsnNode(23, 2));
                        invocation.add((AbstractInsnNode)new VarInsnNode(23, 3));
                        invocation.add((AbstractInsnNode)new FieldInsnNode(178, owner, modelview, "Ljava/nio/FloatBuffer;"));
                        invocation.add((AbstractInsnNode)new FieldInsnNode(178, owner, projection, "Ljava/nio/FloatBuffer;"));
                        invocation.add((AbstractInsnNode)new FieldInsnNode(178, owner, viewport, "Ljava/nio/IntBuffer;"));
                        invocation.add((AbstractInsnNode)new FieldInsnNode(178, owner, objectCoords, "Ljava/nio/FloatBuffer;"));
                        invocation.add((AbstractInsnNode)new MethodInsnNode(184, PERSPECTIVE, "updateRenderInfo", "(FFLjava/nio/FloatBuffer;Ljava/nio/FloatBuffer;Ljava/nio/IntBuffer;Ljava/nio/FloatBuffer;)V", false));
                        instructions.insertBefore(insnNode, invocation);
                        continue block0;
                    }
                    iter.remove();
                }
                continue block0;
            }
        }
        return classNode;
    }

    private ClassNode transformEntityRenderer(ClassNode classNode, boolean obf) {
        String orientCamera = obf ? "h" : "orientCamera";
        String activeRenderInfo = obf ? "baj" : "net/minecraft/client/renderer/ActiveRenderInfo";
        String[] objectXYZ = new String[]{obf ? "a" : "objectX", obf ? "b" : "objectY", obf ? "c" : "objectZ"};
        String getMouseOver = obf ? "a" : "getMouseOver";
        String entityDesc = obf ? "Lsa;" : "Lnet/minecraft/entity/Entity;";
        String getMouseOverBLDesc = "(F)" + entityDesc;
        String entityRenderer = obf ? "blt" : "net/minecraft/client/renderer/EntityRenderer";
        String cloudFog = obf ? "ab" : "cloudFog";
        String pointedEntity = obf ? "x" : "pointedEntity";
        String renderHand = obf ? "b" : "renderHand";
        String worldClient = obf ? "bjf" : "net/minecraft/client/multiplayer/WorldClient";
        String rayTraceBlocks = obf ? "a" : "rayTraceBlocks";
        String rayTraceBlocksDesc = obf ? "(Lazw;Lazw;)Lazu;" : "(Lnet/minecraft/util/Vec3;Lnet/minecraft/util/Vec3;)Lnet/minecraft/util/MovingObjectPosition;";
        boolean needsOrientCamera = true;
        boolean needsRenderWorld = true;
        boolean needsGetMouseOver = true;
        boolean needsPostRenderHandEvent = true;
        for (MethodNode method : classNode.methods) {
            if (needsOrientCamera && orientCamera.equals(method.name) && "(F)V".equals(method.desc)) {
                method.localVariables.clear();
                InsnList insns = method.instructions;
                insns.clear();
                insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insns.add((AbstractInsnNode)new VarInsnNode(23, 1));
                insns.add((AbstractInsnNode)new MethodInsnNode(184, PERSPECTIVE, "orient", "(F)Z", false));
                insns.add((AbstractInsnNode)new FieldInsnNode(181, entityRenderer, cloudFog, "Z"));
                insns.add((AbstractInsnNode)new InsnNode(177));
                insns.add((AbstractInsnNode)new MethodInsnNode(182, worldClient, rayTraceBlocks, rayTraceBlocksDesc, false));
                needsOrientCamera = false;
            }
            if (needsRenderWorld && "(FJ)V".equals(method.desc)) {
                String fieldNameAddition = "currentFrustum";
                String entityRendererOwner = obf ? "blt" : "net/minecraft/client/renderer/EntityRenderer";
                String frustumDesc = obf ? "Lbmx;" : "Lnet/minecraft/client/renderer/culling/Frustrum;";
                boolean needsPerspectiveStuff = true;
                boolean needsFrustumStuff = true;
                int needsBLForgeEventStuff = 0;
                for (FieldNode field : classNode.fields) {
                    if (!field.name.equals(fieldNameAddition)) continue;
                    needsFrustumStuff = false;
                    break;
                }
                boolean replacedASTORE8 = false;
                for (int i = 0; i < method.instructions.size(); ++i) {
                    AbstractInsnNode insnNode = method.instructions.get(i);
                    if (needsPerspectiveStuff && insnNode.getOpcode() == 184 && activeRenderInfo.equals(((MethodInsnNode)insnNode).owner)) {
                        InsnList addCameraPosToViewerPos = new InsnList();
                        int n = 0;
                        int s = 7;
                        while (n < objectXYZ.length) {
                            addCameraPosToViewerPos.add((AbstractInsnNode)new VarInsnNode(24, s));
                            addCameraPosToViewerPos.add((AbstractInsnNode)new FieldInsnNode(178, activeRenderInfo, objectXYZ[n], "F"));
                            addCameraPosToViewerPos.add((AbstractInsnNode)new InsnNode(141));
                            addCameraPosToViewerPos.add((AbstractInsnNode)new InsnNode(99));
                            addCameraPosToViewerPos.add((AbstractInsnNode)new VarInsnNode(57, s));
                            ++n;
                            s += 2;
                        }
                        method.instructions.insert(insnNode, addCameraPosToViewerPos);
                        needsPerspectiveStuff = false;
                    } else if (needsBLForgeEventStuff < 2 && insnNode.getOpcode() == 184 && "setRenderPass".equals(((MethodInsnNode)insnNode).name)) {
                        String name = needsBLForgeEventStuff == 0 ? "postPreRenderEntitiesEvent" : "postPostRenderEntitiesEvent";
                        method.instructions.insert(insnNode, (AbstractInsnNode)new MethodInsnNode(184, BL_FORGE_HOOKS_CLIENT, name, "()V", false));
                        needsBLForgeEventStuff = (byte)(needsBLForgeEventStuff + 1);
                    }
                    if (!needsFrustumStuff) continue;
                    if (replacedASTORE8) {
                        if (insnNode.getOpcode() != 25 || ((VarInsnNode)insnNode).var != 14) continue;
                        ((VarInsnNode)insnNode).var = 0;
                        method.instructions.insert(insnNode, (AbstractInsnNode)new FieldInsnNode(180, entityRendererOwner, fieldNameAddition, frustumDesc));
                        continue;
                    }
                    if (insnNode.getOpcode() != 58 || ((VarInsnNode)insnNode).var != 14) continue;
                    InsnList newInsn = new InsnList();
                    method.instructions.insertBefore(method.instructions.get(i - 3), (AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.set(insnNode, (AbstractInsnNode)new FieldInsnNode(181, entityRendererOwner, fieldNameAddition, frustumDesc));
                    replacedASTORE8 = true;
                }
                if (needsFrustumStuff) {
                    classNode.fields.add(new FieldNode(1, fieldNameAddition, frustumDesc, null, null));
                }
                needsRenderWorld = false;
            }
            if (needsGetMouseOver && getMouseOver.equals(method.name) && "(F)V".equals(method.desc)) {
                for (int i = 0; i < method.instructions.size(); ++i) {
                    AbstractInsnNode insn = method.instructions.get(i);
                    if (insn.getOpcode() != 1) continue;
                    LabelNode ifNotCancelled = null;
                    i += 2;
                    while (i < method.instructions.size()) {
                        AbstractInsnNode search = method.instructions.get(i);
                        if (search.getType() == 8) {
                            ifNotCancelled = (LabelNode)search;
                            break;
                        }
                        ++i;
                    }
                    InsnList hook = new InsnList();
                    hook.add((AbstractInsnNode)new MethodInsnNode(184, BL_FORGE_HOOKS_CLIENT, "getMouseOverHook", "()Z", false));
                    hook.add((AbstractInsnNode)new JumpInsnNode(153, ifNotCancelled));
                    hook.add((AbstractInsnNode)new InsnNode(177));
                    method.instructions.insert(insn.getNext(), hook);
                    break;
                }
                needsGetMouseOver = false;
            }
            if (needsPostRenderHandEvent && renderHand.equals(method.name) && "(FI)V".equals(method.desc)) {
                AbstractInsnNode lastReturn = null;
                for (int i = method.instructions.size() - 1; i > 0; --i) {
                    AbstractInsnNode node = method.instructions.get(i);
                    if (!(node instanceof InsnNode) || ((InsnNode)node).getOpcode() != 177) continue;
                    lastReturn = node;
                }
                if (lastReturn != null) {
                    InsnList hook = new InsnList();
                    hook.add((AbstractInsnNode)new VarInsnNode(23, 1));
                    hook.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    hook.add((AbstractInsnNode)new MethodInsnNode(184, BL_FORGE_HOOKS_CLIENT, "postRenderHandEvent", "(FI)V", false));
                    method.instructions.insertBefore(lastReturn, hook);
                }
                needsPostRenderHandEvent = true;
            }
            if (needsOrientCamera || needsRenderWorld || needsGetMouseOver || needsPostRenderHandEvent) continue;
            break;
        }
        return classNode;
    }

    private ClassNode transformRenderManager(ClassNode classNode, boolean obf) {
        String cacheActiveRenderInfo = obf ? "a" : "cacheActiveRenderInfo";
        String cacheActiveRenderInfoDesc = obf ? "(Lahb;Lbqf;Lbbu;Lsv;Lsa;Lbbj;F)V" : "(Lnet/minecraft/world/World;Lnet/minecraft/client/renderer/texture/TextureManager;Lnet/minecraft/client/gui/FontRenderer;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/entity/Entity;Lnet/minecraft/client/settings/GameSettings;F)V";
        String fontRenderer = obf ? "r" : "fontRenderer";
        block0: for (MethodNode method : classNode.methods) {
            if (!cacheActiveRenderInfo.equals(method.name) || !cacheActiveRenderInfoDesc.equals(method.desc)) continue;
            for (int i = method.instructions.size() - 1; i >= 0; --i) {
                AbstractInsnNode insnNode = method.instructions.get(i);
                if (insnNode.getOpcode() != 177) continue;
                method.instructions.insertBefore(insnNode, (AbstractInsnNode)new MethodInsnNode(184, PERSPECTIVE, "cacheActiveRenderInfo", "()V", false));
                break block0;
            }
        }
        return classNode;
    }

    private ClassNode transformEntity(ClassNode classNode, boolean obf) {
        String setAngles = obf ? "c" : "setAngles";
        String entity = obf ? "sa" : "net/minecraft/entity/Entity";
        for (MethodNode method : classNode.methods) {
            if (!setAngles.equals(method.name) || !"(FF)V".equals(method.desc)) continue;
            method.instructions.clear();
            method.localVariables.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, PERSPECTIVE, "setAngles", String.format("(L%s;FF)V", entity), false));
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
            break;
        }
        return classNode;
    }

    private ClassNode transformEntityTracker(ClassNode classNode, boolean obf) {
        String addEntityToTracker = obf ? "a" : "addEntityToTracker";
        String addEntityToTrackerDesc = obf ? "(Lsa;IIZ)V" : "(Lnet/minecraft/entity/Entity;IIZ)V";
        String entityTrackerEntry = obf ? "my" : "net/minecraft/entity/EntityTrackerEntry";
        block0: for (MethodNode method : classNode.methods) {
            if (!addEntityToTracker.equals(method.name) || !addEntityToTrackerDesc.equals(method.desc)) continue;
            boolean hasEntry = false;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode insn = method.instructions.get(i);
                if (hasEntry) {
                    if (insn.getOpcode() != 183) continue;
                    ((MethodInsnNode)insn).owner = SUPERB_ENTITY_TRACKER_ENTRY;
                    break block0;
                }
                if (insn.getOpcode() != 187 || !entityTrackerEntry.equals(((TypeInsnNode)insn).desc)) continue;
                ((TypeInsnNode)insn).desc = SUPERB_ENTITY_TRACKER_ENTRY;
                hasEntry = true;
            }
        }
        return classNode;
    }
}

