/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.command;

import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.events.EnvironmentEvent;
import thebetweenlands.world.events.EnvironmentEventRegistry;

public class CommandBLEvent
extends CommandBase {
    private List<String> childCommands = Arrays.asList("toggle", "on", "off", "list", "enable", "disable");

    public String func_71517_b() {
        return "blevent";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.blevent.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new CommandException("command.blevent.usage", new Object[0]);
        }
        switch (args[0]) {
            case "toggle": {
                this.processToggle(sender, args);
                break;
            }
            case "on": {
                this.processOn(sender, args);
                break;
            }
            case "off": {
                this.processOff(sender, args);
                break;
            }
            case "list": {
                this.processList(sender);
                break;
            }
            case "enable": {
                this.processEnable(sender, args);
                break;
            }
            case "disable": {
                this.processDisable(sender, args);
                break;
            }
            default: {
                throw new CommandException("command.blevent.usage", new Object[0]);
            }
        }
    }

    private void checkArg(String[] args, int length, String usage) {
        if (args.length < length) {
            throw new CommandException("command.blevent.usage." + usage, new Object[0]);
        }
    }

    private void processToggle(ICommandSender sender, String[] args) {
        this.checkArg(args, 2, "toggle");
        String eventName = CommandBLEvent.func_82360_a((ICommandSender)sender, (String[])args, (int)1);
        EnvironmentEvent event = this.getEnvironentEvent(sender, eventName);
        boolean isActive = event.isActive();
        event.setActive(!isActive, true);
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("command.blevent.success." + (isActive ? "off" : "on")), (Object[])new Object[]{eventName});
    }

    private void processOn(ICommandSender sender, String[] args) {
        this.checkArg(args, 2, "on");
        this.processEventState(sender, CommandBLEvent.func_82360_a((ICommandSender)sender, (String[])args, (int)1), true);
    }

    private void processOff(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            EnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
            for (EnvironmentEvent event : environmentEventRegistry.getActiveEvents()) {
                event.setActive(false, true);
            }
            CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.blevent.success.alloff", (Object[])new Object[0]);
        } else {
            this.processEventState(sender, CommandBLEvent.func_82360_a((ICommandSender)sender, (String[])args, (int)1), false);
        }
    }

    private void processEnable(ICommandSender sender, String[] args) {
        EnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        if (environmentEventRegistry.isEnabled()) {
            throw new CommandException("command.blevent.failure.alreadyenabled", new Object[0]);
        }
        environmentEventRegistry.enable();
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.blevent.success.enable", (Object[])new Object[0]);
    }

    private void processDisable(ICommandSender sender, String[] args) {
        EnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        if (environmentEventRegistry.isDisabled()) {
            throw new CommandException("command.blevent.failure.alreadydisabled", new Object[0]);
        }
        environmentEventRegistry.disable();
        for (EnvironmentEvent event : environmentEventRegistry.getActiveEvents()) {
            event.setActive(false, true);
        }
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"command.blevent.success.disable", (Object[])new Object[0]);
    }

    private void processList(ICommandSender sender) {
        EnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        sender.func_145747_a((IChatComponent)new ChatComponentText(environmentEventRegistry.getGrammaticalActiveEventNameList()));
    }

    private void processEventState(ICommandSender sender, String eventName, boolean isActive) {
        EnvironmentEvent event = this.getEnvironentEvent(sender, eventName);
        if (event.isActive() == isActive) {
            throw new CommandException("command.blevent.failure.already" + (isActive ? "on" : "off"), new Object[]{eventName});
        }
        event.setActive(isActive, true);
        CommandBLEvent.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("command.blevent.success." + (isActive ? "on" : "off")), (Object[])new Object[]{eventName});
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (!(sender.func_130014_f_().field_73011_w instanceof WorldProviderBetweenlands)) {
            return null;
        }
        List<String> completions = null;
        if (args.length == 1) {
            completions = this.childCommands;
        } else if (args.length == 2) {
            switch (args[0]) {
                case "toggle": {
                    completions = this.getEnvironmentEventRegistry(sender).getEventNames();
                    break;
                }
                case "on": {
                    completions = this.getEnvironmentEventRegistry(sender).getEventNamesOfState(false);
                    break;
                }
                case "off": {
                    completions = this.getEnvironmentEventRegistry(sender).getEventNamesOfState(true);
                }
            }
        }
        return completions == null ? null : CommandBLEvent.func_71530_a((String[])args, (String[])completions.toArray(new String[0]));
    }

    private EnvironmentEventRegistry getEnvironmentEventRegistry(ICommandSender sender) {
        World world = sender.func_130014_f_();
        if (world.field_73011_w instanceof WorldProviderBetweenlands) {
            return ((WorldProviderBetweenlands)world.field_73011_w).getWorldData().getEnvironmentEventRegistry();
        }
        throw new CommandException("command.blevent.failure.wrongdimension", new Object[0]);
    }

    private EnvironmentEvent getEnvironentEvent(ICommandSender sender, String eventName) {
        EnvironmentEventRegistry environmentEventRegistry = this.getEnvironmentEventRegistry(sender);
        EnvironmentEvent event = environmentEventRegistry.forName(eventName);
        if (event == null) {
            throw new CommandException("command.blevent.failure.unknown", new Object[]{eventName});
        }
        return event;
    }
}

