/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.DiscoveryContainer;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class CommandAspectDiscovery
extends CommandBase {
    public String func_71517_b() {
        return "aspectDiscovery";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/aspectDiscovery <reset|discover> <held|all>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("command.generic.noplayer", new Object[0]);
        }
        if (args.length < 2) {
            throw new CommandException("commands.generic.syntax", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (!AspectManager.hasDiscoveryProvider(player)) {
            throw new CommandException("command.aspectdiscovery.book.none", new Object[0]);
        }
        WorldServer blWorld = DimensionManager.getWorld((int)ConfigHandler.DIMENSION_ID);
        AspectManager manager = AspectManager.get((World)blWorld);
        block4 : switch (args[0]) {
            case "discover": {
                switch (args[1]) {
                    case "held": {
                        if (player.func_70694_bm() == null) {
                            throw new CommandException("command.aspectdiscovery.held.null", new Object[0]);
                        }
                        DiscoveryContainer mergedKnowledge = AspectManager.getMergedDiscoveryContainer(player);
                        DiscoveryContainer.AspectDiscovery discovery = mergedKnowledge.discover(manager, new AspectManager.AspectItem(player.func_70694_bm()));
                        AspectManager.addDiscoveryToContainers(player, new AspectManager.AspectItem(player.func_70694_bm()), discovery.discovered.type);
                        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aspectdiscovery.discover.held", new Object[]{new ChatComponentText(discovery.result.toString()), new ChatComponentText(discovery.discovered == null ? "null" : discovery.discovered.type.getName())}));
                        break block4;
                    }
                    case "all": {
                        List<DiscoveryContainer> discoveryContainers = AspectManager.getWritableDiscoveryContainers(player);
                        for (DiscoveryContainer container : discoveryContainers) {
                            container.discoverAll(manager);
                        }
                        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aspectdiscovery.discover.all", new Object[0]));
                        break block4;
                    }
                }
                throw new CommandException("commands.generic.syntax", new Object[0]);
            }
            case "reset": {
                List<DiscoveryContainer> discoveryContainers = AspectManager.getWritableDiscoveryContainers(player);
                switch (args[1]) {
                    case "held": {
                        if (player.func_70694_bm() == null) {
                            throw new CommandException("command.aspectdiscovery.held.null", new Object[0]);
                        }
                        for (DiscoveryContainer container : discoveryContainers) {
                            container.resetDiscovery(new AspectManager.AspectItem(player.func_70694_bm()));
                        }
                        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aspectdiscovery.reset.held", new Object[0]));
                        break block4;
                    }
                    case "all": {
                        for (DiscoveryContainer container : discoveryContainers) {
                            container.resetAllDiscovery();
                        }
                        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aspectdiscovery.reset.all", new Object[0]));
                        break block4;
                    }
                }
                throw new CommandException("commands.generic.syntax", new Object[0]);
            }
            default: {
                throw new CommandException("commands.generic.syntax", new Object[0]);
            }
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("reset");
            completions.add("discover");
        } else if (args.length == 2) {
            completions.add("all");
            completions.add("held");
        }
        return CommandAspectDiscovery.func_71530_a((String[])args, (String[])completions.toArray(new String[0]));
    }
}

