/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.terrain.BlockSwampWater;
import thebetweenlands.client.model.block.ModelInfuser;
import thebetweenlands.herblore.elixirs.ElixirRecipe;
import thebetweenlands.tileentities.TileEntityInfuser;
import thebetweenlands.utils.ItemRenderHelper;
import thebetweenlands.utils.confighandler.ConfigHandler;

@SideOnly(value=Side.CLIENT)
public class TileEntityInfuserRenderer
extends TileEntitySpecialRenderer {
    private final ModelInfuser model = new ModelInfuser();
    public static ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/infuser.png");
    private RenderManager renderManager = RenderManager.field_78727_a;
    private double viewRot;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTickTime) {
        TileEntityInfuser infuser = (TileEntityInfuser)tile;
        int meta = infuser.func_145832_p();
        this.viewRot = 180.0 + Math.toDegrees(Math.atan2(this.renderManager.field_78730_l - (double)infuser.field_145851_c - 0.5, this.renderManager.field_78728_n - (double)infuser.field_145849_e - 0.5));
        this.func_147499_a(TEXTURE);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (meta) {
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.model.render();
        GL11.glPushMatrix();
        GL11.glRotatef((float)(infuser.getStirProgress() * 4), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.renderSpoon();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        ElixirRecipe recipe = infuser.getInfusingRecipe();
        if (ConfigHandler.DEBUG) {
            String elixirName = recipe != null ? recipe.name : " N/A";
            this.renderStirCount("Evap: " + infuser.getEvaporation() + " Temp: " + infuser.getTemperature() + " Time: " + infuser.getInfusionTime() + " Recipe: " + elixirName, x, y, z);
        }
        int amount = infuser.waterTank.getFluidAmount();
        int capacity = infuser.waterTank.getCapacity();
        float size = 1.0f / (float)capacity * (float)amount;
        if (amount >= 100) {
            Tessellator tess = Tessellator.field_78398_a;
            IIcon waterIcon = ((BlockSwampWater)BLBlockRegistry.swampWater).getWaterIcon(1);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.func_147499_a(TextureMap.field_110575_b);
            float tx = (float)x + 0.0f;
            float ty = (float)(y + (double)0.35f + (double)(size * 0.5f));
            float tz = (float)z + 0.0f;
            tess.func_78372_c(tx, ty, tz);
            tess.func_78382_b();
            float[] targetColor = infuser.getInfusionColorGradientTicks() > 0 ? new float[]{infuser.prevInfusionColor[0] + (infuser.currentInfusionColor[0] - infuser.prevInfusionColor[0]) / 30.0f * (float)infuser.getInfusionColorGradientTicks(), infuser.prevInfusionColor[1] + (infuser.currentInfusionColor[1] - infuser.prevInfusionColor[1]) / 30.0f * (float)infuser.getInfusionColorGradientTicks(), infuser.prevInfusionColor[2] + (infuser.currentInfusionColor[2] - infuser.prevInfusionColor[2]) / 30.0f * (float)infuser.getInfusionColorGradientTicks(), infuser.prevInfusionColor[3] + (infuser.currentInfusionColor[3] - infuser.prevInfusionColor[3]) / 30.0f * (float)infuser.getInfusionColorGradientTicks()} : infuser.currentInfusionColor;
            tess.func_78369_a(targetColor[0], targetColor[1], targetColor[2], targetColor[3]);
            tess.func_78374_a(0.1875, 0.0, 0.1875, (double)waterIcon.func_94209_e(), (double)waterIcon.func_94206_g());
            tess.func_78374_a(0.1875, 0.0, 0.8125, (double)waterIcon.func_94209_e(), (double)waterIcon.func_94210_h());
            tess.func_78374_a(0.8125, 0.0, 0.8125, (double)waterIcon.func_94212_f(), (double)waterIcon.func_94210_h());
            tess.func_78374_a(0.8125, 0.0, 0.1875, (double)waterIcon.func_94212_f(), (double)waterIcon.func_94206_g());
            tess.func_78381_a();
            tess.func_78372_c(-tx, -ty, -tz);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        int itemBob = infuser.getItemBob();
        int stirProgress = infuser.getStirProgress();
        float crystalRotation = infuser.getCrystalRotation();
        double itemY = y + 0.3 + (double)size * 0.5;
        Random rand = new Random();
        rand.setSeed(tile.field_145851_c + tile.field_145848_d + tile.field_145849_e);
        for (int i = 0; i <= 6; ++i) {
            float randRot = rand.nextFloat() * 360.0f;
            double xo = -0.2 + (double)rand.nextFloat() * 0.4;
            double zo = -0.2 + (double)rand.nextFloat() * 0.4;
            double rot = (stirProgress < 90 && amount >= 100 ? (double)stirProgress * 4.0 + 45.0 : 45.0) + (double)randRot;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)0.0, (double)(z + 0.5));
            GL11.glRotated((double)(-rot), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)xo, (double)0.0, (double)zo);
            this.renderItemInSlot(infuser, i, 0.0, itemY, 0.0, amount >= 100 ? (i % 2 == 0 ? (double)itemBob * 0.01 : (double)(-itemBob + 20) * 0.01) : 0.0, -rot);
            GL11.glPopMatrix();
        }
        this.renderItemInSlot(infuser, 7, x + 0.5, y + 1.43, z + 0.5, (double)itemBob * 0.01, crystalRotation);
    }

    private void renderItemInSlot(TileEntityInfuser infuser, int slotIndex, double x, double y, double z, double itemBob, double rotation) {
        if (infuser.func_70301_a(slotIndex) != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glPushMatrix();
            GL11.glScaled((double)0.15, (double)0.15, (double)0.15);
            GL11.glTranslated((double)0.0, (double)itemBob, (double)0.0);
            GL11.glRotated((double)rotation, (double)0.0, (double)1.0, (double)0.0);
            for (int i = 0; i < infuser.func_70301_a(slotIndex).func_77973_b().getRenderPasses(infuser.func_70301_a(slotIndex).func_77960_j()); ++i) {
                ItemRenderHelper.renderItem(infuser.func_70301_a(slotIndex), i);
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    private void renderStirCount(String count, double x, double y, double z) {
        float scale = 0.02666667f;
        float height = 0.8f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + (double)height + 0.75), (double)(z + 0.5));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontrenderer.func_78256_a(count) / 2;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.func_78377_a((double)(-width - 1), -1.0, 0.0);
        tessellator.func_78377_a((double)(-width - 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(width + 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(width + 1), -1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        fontrenderer.func_78276_b(count, -fontrenderer.func_78256_a(count) / 2, 0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.func_78276_b(count, -fontrenderer.func_78256_a(count) / 2, 0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

