/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.model.block.ModelAltar;
import thebetweenlands.client.model.block.ModelStone4;
import thebetweenlands.tileentities.TileEntityDruidAltar;
import thebetweenlands.utils.ItemRenderHelper;
import thebetweenlands.utils.LightingUtil;

@SideOnly(value=Side.CLIENT)
public class TileEntityDruidAltarRenderer
extends TileEntitySpecialRenderer {
    private final ModelAltar model = new ModelAltar();
    private final ModelStone4 stone4 = new ModelStone4();
    private final ResourceLocation ACTIVE = new ResourceLocation("thebetweenlands:textures/tiles/druidAltarActive.png");
    private final ResourceLocation ACTIVEGLOW = new ResourceLocation("thebetweenlands:textures/tiles/druidAltarActiveGlow.png");
    private final ResourceLocation NORMAL = new ResourceLocation("thebetweenlands:textures/tiles/druidAltar.png");
    private final ResourceLocation NORMALGLOW = new ResourceLocation("thebetweenlands:textures/tiles/druidAltarGlow.png");
    public static TileEntityDruidAltarRenderer instance;

    public void func_147497_a(TileEntityRendererDispatcher renderer) {
        super.func_147497_a(renderer);
        instance = this;
    }

    public void renderTileAsItem(double x, double y, double z) {
        this.func_147499_a(this.NORMAL);
        GL11.glPushMatrix();
        this.renderMainModel(x, y, z);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.renderStones(x, y, z, 0.0f);
        GL11.glPopMatrix();
        LightingUtil.INSTANCE.setLighting(255);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDepthMask((boolean)true);
        this.func_147499_a(this.NORMALGLOW);
        GL11.glPushMatrix();
        this.renderMainModel(x, y, z);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.renderStones(x, y, z, 0.0f);
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
        LightingUtil.INSTANCE.revert();
    }

    private void renderTile(TileEntityDruidAltar tile, double x, double y, double z, float partialTicks) {
        ItemStack itemTalisman;
        if (tile.field_145847_g == 1) {
            this.func_147499_a(this.ACTIVE);
        } else {
            this.func_147499_a(this.NORMAL);
        }
        GL11.glPushMatrix();
        this.renderMainModel(x, y, z);
        GL11.glPopMatrix();
        float renderRotation = tile.rotation + (tile.rotation - tile.prevRotation) * partialTicks;
        GL11.glPushMatrix();
        this.renderStones(x, y, z, renderRotation);
        GL11.glPopMatrix();
        LightingUtil.INSTANCE.setLighting(255);
        if (tile.field_145847_g == 1 && tile.craftingProgress != 0) {
            double yOff = tile.renderYOffset + (tile.renderYOffset - tile.prevRenderYOffset) * partialTicks;
            if (yOff > 3.0) {
                yOff = 3.0;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 3.1), (double)(z + 0.5));
            GL11.glRotated((double)((double)renderRotation * 2.0), (double)0.0, (double)1.0, (double)0.0);
            double shineScale = (double)0.04f * Math.pow(1.0 - (3.0 - yOff) / 2.0, 12.0);
            GL11.glScaled((double)shineScale, (double)shineScale, (double)shineScale);
            this.renderShine((float)Math.sin(Math.toRadians(renderRotation)) / 2.0f - 0.2f, (int)(80.0 * Math.pow(1.0 - (3.0 - yOff) / 2.0, 12.0)));
            GL11.glPopMatrix();
            boolean exit = false;
            for (int xi = 0; xi < 2; ++xi) {
                for (int zi = 0; zi < 2; ++zi) {
                    ItemStack item = tile.func_70301_a(zi * 2 + xi + 1);
                    if (item == null) {
                        exit = true;
                        break;
                    }
                    double xOff = xi == 0 ? -0.18 : 1.18;
                    double zOff = zi == 0 ? -0.18 : 1.18;
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)(x + xOff), (double)(y + 1.0), (double)(z + zOff));
                    this.renderCone(5);
                    GL11.glPopMatrix();
                    Vector3d midVec = new Vector3d(x + 0.5, 0.0, z + 0.5);
                    Vector3d diffVec = new Vector3d(x + xOff, 0.0, z + zOff);
                    diffVec.sub((Tuple3d)midVec);
                    double rProgress = 1.0 - Math.pow(1.0 - (3.0 - yOff) / 2.0, 6.0);
                    diffVec.scale(rProgress);
                    midVec.add((Tuple3d)diffVec);
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)midVec.x, (double)(y + yOff), (double)midVec.z);
                    GL11.glScaled((double)0.3f, (double)0.3f, (double)0.3f);
                    GL11.glRotated((double)((double)(-renderRotation) * 2.0), (double)0.0, (double)y, (double)0.0);
                    ItemRenderHelper.renderItem(item, 0);
                    GL11.glPopMatrix();
                }
                if (exit) break;
            }
        }
        if ((itemTalisman = tile.func_70301_a(0)) != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 3.1), (double)(z + 0.5));
            GL11.glRotated((double)((double)renderRotation * 2.0), (double)0.0, (double)1.0, (double)0.0);
            double shineScale = 0.04f;
            GL11.glScaled((double)shineScale, (double)shineScale, (double)shineScale);
            this.renderShine((float)Math.sin(Math.toRadians(renderRotation)) / 2.0f - 0.2f, 80);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 3.0), (double)(z + 0.5));
            GL11.glScaled((double)0.3f, (double)0.3f, (double)0.3f);
            GL11.glRotated((double)((double)(-renderRotation) * 2.0), (double)0.0, (double)1.0, (double)0.0);
            ItemRenderHelper.renderItem(itemTalisman, 0);
            GL11.glPopMatrix();
        }
        LightingUtil.INSTANCE.revert();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDepthMask((boolean)true);
        float lighting = 150.0f;
        if (tile.field_145847_g == 1) {
            lighting = (float)Math.sin(Math.toRadians(renderRotation) * 4.0) * 105.0f + 150.0f;
        }
        LightingUtil.INSTANCE.setLighting((int)lighting);
        if (tile.field_145847_g == 1) {
            this.func_147499_a(this.ACTIVEGLOW);
        } else {
            this.func_147499_a(this.NORMALGLOW);
        }
        GL11.glPushMatrix();
        this.renderMainModel(x, y, z);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.renderStones(x, y, z, renderRotation);
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
        LightingUtil.INSTANCE.revert();
    }

    private void renderMainModel(double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.renderAll(0.0625f);
        GL11.glPopMatrix();
    }

    private void renderStones(double x, double y, double z, float rotation) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.stone4.renderAll();
        GL11.glPopMatrix();
    }

    private void renderShine(float rotation, int iterations) {
        Random random = new Random(432L);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glPushMatrix();
        float f1 = rotation;
        float f2 = 0.0f;
        if (f1 > 0.8f) {
            f2 = (f1 - 0.8f) / 0.2f;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        int i = 0;
        while ((float)i < (float)iterations) {
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f + f1 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(6);
            float pos1 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float pos2 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            tessellator.func_78384_a(0xFFFFFF, (int)(255.0f * (1.0f - f2)));
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78370_a(0, 0, 255, 0);
            tessellator.func_78377_a(-0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2));
            tessellator.func_78377_a(0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2));
            tessellator.func_78377_a(0.0, (double)pos1, (double)(1.0f * pos2));
            tessellator.func_78377_a(-0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2));
            tessellator.func_78381_a();
            ++i;
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
    }

    private void renderCone(int faces) {
        GL11.glPushMatrix();
        float step = 360.0f / (float)faces;
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        for (float i = 0.0f; i < 360.0f; i += step) {
            Tessellator tessellator = Tessellator.field_78398_a;
            double lr = 0.1;
            double ur = 0.3;
            double height = 0.2;
            double sin = Math.sin(Math.toRadians(i));
            double cos = Math.cos(Math.toRadians(i));
            double sin2 = Math.sin(Math.toRadians(i + step));
            double cos2 = Math.cos(Math.toRadians(i + step));
            tessellator.func_78371_b(6);
            tessellator.func_78370_a(255, 255, 255, 0);
            tessellator.func_78377_a(sin * lr, 0.0, cos * lr);
            tessellator.func_78377_a(sin2 * lr, 0.0, cos2 * lr);
            tessellator.func_78370_a(0, 0, 255, 60);
            tessellator.func_78377_a(sin2 * ur, height, cos2 * ur);
            tessellator.func_78377_a(sin * ur, height, cos * ur);
            tessellator.func_78370_a(0, 0, 255, 60);
            tessellator.func_78377_a(sin * ur, height, cos * ur);
            tessellator.func_78377_a(sin2 * ur, height, cos2 * ur);
            tessellator.func_78370_a(255, 255, 255, 0);
            tessellator.func_78377_a(sin2 * lr, 0.0, cos2 * lr);
            tessellator.func_78377_a(sin * lr, 0.0, cos * lr);
            tessellator.func_78381_a();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTick) {
        this.renderTile((TileEntityDruidAltar)tile, x, y, z, partialTick);
    }
}

