/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.model.block.ModelCompostBin;
import thebetweenlands.tileentities.TileEntityCompostBin;
import thebetweenlands.utils.ItemRenderHelper;

@SideOnly(value=Side.CLIENT)
public class TileEntityCompostBinRenderer
extends TileEntitySpecialRenderer {
    public static ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/tiles/compostBin.png");
    private final ModelCompostBin model = new ModelCompostBin();
    private RenderBlocks blockRenderer;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTickTime) {
        TileEntityCompostBin compostBin = (TileEntityCompostBin)tile;
        int meta = compostBin.func_145832_p();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GL11.glRotatef((float)TileEntityCompostBinRenderer.getRotation(meta), (float)0.0f, (float)1.0f, (float)0.0f);
        float compostHeight = Math.min((float)compostBin.getTotalCompostedAmount() / 200.0f, 0.82f);
        if (compostHeight > 0.01f) {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78380_c(tile.func_145831_w().func_147439_a((int)x, (int)y, (int)z).func_149677_c((IBlockAccess)tile.func_145831_w(), (int)x, (int)y, (int)z));
            GL11.glPushMatrix();
            GL11.glScaled((double)0.8f, (double)compostHeight, (double)0.8f);
            GL11.glTranslated((double)((double)(-tile.field_145851_c) - 0.5), (double)(-tile.field_145848_d), (double)((double)(-tile.field_145849_e) - 0.5));
            tessellator.func_78386_a(0.5f, 0.8f, 0.1f);
            this.func_147499_a(TextureMap.field_110575_b);
            tessellator.func_78382_b();
            this.blockRenderer.func_147769_a(BLBlockRegistry.weedwoodLeaves, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glDisable((int)2884);
        this.func_147499_a(TEXTURE);
        this.model.render(compostBin.getLidAngle(partialTickTime));
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        for (int i = 0; i < compostBin.getSizeInventory(); ++i) {
            ItemStack stack = compostBin.getStackInSlot(i);
            if (stack == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(0.1f + compostHeight + (float)i * 0.4f / (float)compostBin.getSizeInventory()), (float)0.08f);
            GL11.glScalef((float)0.36f, (float)0.36f, (float)0.36f);
            GL11.glRotatef((float)(new Random(i * 12315).nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ItemRenderHelper.renderItem(stack, 0);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public void func_147496_a(World world) {
        this.blockRenderer = new RenderBlocks((IBlockAccess)world);
    }

    public static float getRotation(int meta) {
        switch (meta) {
            case 5: {
                return 180.0f;
            }
            default: {
                return 0.0f;
            }
            case 3: {
                return 90.0f;
            }
            case 2: 
        }
        return -90.0f;
    }
}

