/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sky;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import thebetweenlands.client.render.shader.GeometryBuffer;
import thebetweenlands.client.render.shader.MainShader;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.sky.AuroraRenderer;
import thebetweenlands.event.render.FogHandler;
import thebetweenlands.utils.GLUProjection;
import thebetweenlands.utils.Mesh;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.events.impl.EventAuroras;
import thebetweenlands.world.events.impl.EventSpoopy;

public class BLSkyRenderer
extends IRenderHandler {
    private Mesh starMesh;
    private int skyDispListStart;
    private int skyDispList1;
    private int skyDispList2;
    private static final ResourceLocation SKY_TEXTURE_RES = new ResourceLocation("thebetweenlands:textures/sky/skyTexture.png");
    private static final ResourceLocation FOG_TEXTURE_RES = new ResourceLocation("thebetweenlands:textures/sky/fogTexture.png");
    private static final ResourceLocation SKY_SPOOPY_TEXTURE_RES = new ResourceLocation("thebetweenlands:textures/sky/spoopy.png");
    private List<AuroraRenderer> auroras = new ArrayList<AuroraRenderer>();
    public final GeometryBuffer clipPlaneBuffer = new GeometryBuffer(true);
    public static final BLSkyRenderer INSTANCE = new BLSkyRenderer();

    public BLSkyRenderer() {
        int tileZ;
        int tileX;
        this.starMesh = this.createStarMesh();
        Tessellator tessellator = Tessellator.field_78398_a;
        int tileCount = 64;
        int tileSize = 256 / tileCount + 2;
        float skyY = 16.0f;
        this.skyDispListStart = GLAllocation.func_74526_a((int)3);
        GL11.glNewList((int)this.skyDispListStart, (int)4864);
        this.createSkyDispList();
        GL11.glEndList();
        skyY = -50.0f;
        this.skyDispList1 = this.skyDispListStart + 1;
        GL11.glNewList((int)this.skyDispList1, (int)4864);
        tessellator.func_78382_b();
        for (tileX = -tileCount * tileSize; tileX <= tileCount * tileSize; tileX += tileCount) {
            for (tileZ = -tileCount * tileSize; tileZ <= tileCount * tileSize; tileZ += tileCount) {
                tessellator.func_78377_a((double)(tileX + 0), (double)skyY, (double)(tileZ + 0));
                tessellator.func_78377_a((double)(tileX + tileCount), (double)skyY, (double)(tileZ + 0));
                tessellator.func_78377_a((double)(tileX + tileCount), (double)skyY, (double)(tileZ + tileCount));
                tessellator.func_78377_a((double)(tileX + 0), (double)skyY, (double)(tileZ + tileCount));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
        skyY = -16.0f;
        this.skyDispList2 = this.skyDispListStart + 2;
        GL11.glNewList((int)this.skyDispList2, (int)4864);
        tessellator.func_78382_b();
        for (tileX = -tileCount * tileSize; tileX <= tileCount * tileSize; tileX += tileCount) {
            for (tileZ = -tileCount * tileSize; tileZ <= tileCount * tileSize; tileZ += tileCount) {
                tessellator.func_78377_a((double)(tileX + tileCount), (double)skyY, (double)(tileZ + 0));
                tessellator.func_78377_a((double)(tileX + 0), (double)skyY, (double)(tileZ + 0));
                tessellator.func_78377_a((double)(tileX + 0), (double)skyY, (double)(tileZ + tileCount));
                tessellator.func_78377_a((double)(tileX + tileCount), (double)skyY, (double)(tileZ + tileCount));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    private Mesh createStarMesh() {
        ArrayList<Mesh.Triangle> triangles = new ArrayList<Mesh.Triangle>();
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < 1500; ++i) {
            double rz;
            double ry;
            double rx = random.nextFloat() * 2.0f - 1.0f;
            double centerDistance = rx * rx + (ry = (double)(random.nextFloat() * 0.5f - 1.0f)) * ry + (rz = (double)(random.nextFloat() * 2.0f - 1.0f)) * rz;
            if (!(centerDistance < 1.0) || !(centerDistance > 0.01)) continue;
            centerDistance = 1.0 / Math.sqrt(centerDistance);
            double farX = (rx *= centerDistance) * 100.0;
            double farY = (ry *= centerDistance) * 100.0;
            double farZ = (rz *= centerDistance) * 100.0;
            double xzAngle = Math.atan2(rx, rz);
            double xzRotX = Math.sin(xzAngle);
            double xzRotY = Math.cos(xzAngle);
            double distYAngle = Math.atan2(Math.sqrt(rx * rx + rz * rz), ry);
            double distYRotX = Math.sin(distYAngle);
            double distYRotZ = Math.cos(distYAngle);
            double randAngle = random.nextDouble() * Math.PI * 2.0;
            double randRotX = Math.sin(randAngle);
            double randRotY = Math.cos(randAngle);
            int color = -1;
            if (random.nextInt(2) == 1) {
                color = -16738048;
            }
            double randSize = 0.15f + random.nextFloat() * 0.1f;
            Mesh.Triangle.Vertex v1 = this.getQuadPoint(0, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle.Vertex v2 = this.getQuadPoint(1, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle.Vertex v3 = this.getQuadPoint(2, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle.Vertex v4 = this.getQuadPoint(3, randSize, randRotX, randRotY, distYRotX, distYRotZ, xzRotX, xzRotY, farX, farY, farZ, color);
            Mesh.Triangle t1 = new Mesh.Triangle(v1, v2, v3);
            Mesh.Triangle t2 = new Mesh.Triangle(v3, v4, v1);
            triangles.add(t1);
            triangles.add(t2);
        }
        return new Mesh(triangles);
    }

    private Mesh.Triangle.Vertex getQuadPoint(int vertex, double randSize, double randRotX, double randRotY, double distYRotX, double distYRotZ, double xzRotX, double xzRotY, double farX, double farY, double farZ, int color) {
        double randRotYMultiplier = 0.0;
        double vertX = (double)((vertex & 2) - 1) * randSize;
        double vertZ = (double)((vertex + 1 & 2) - 1) * randSize;
        double rotVertX = vertX * randRotY - vertZ * randRotX;
        double rotVertZ = vertZ * randRotY + vertX * randRotX;
        double rotVertX2 = rotVertX * distYRotX + randRotYMultiplier * distYRotZ;
        double rotVertZ2 = randRotYMultiplier * distYRotX - rotVertX * distYRotZ;
        vertX = rotVertZ2 * xzRotX - rotVertZ * xzRotY;
        vertZ = rotVertZ * xzRotX + rotVertZ2 * xzRotY;
        return new Mesh.Triangle.Vertex(farX + vertX, farY + rotVertX2, farZ + vertZ, new Mesh.Triangle.Vertex.Vector3D(0.0, -1.0, 0.0), color);
    }

    private void createSkyDispList() {
        double tileSize = 5.0;
        GLUProjection.Vector3D yOffset = new GLUProjection.Vector3D(0.0, 2.0, 0.0);
        GLUProjection.Vector3D cp = new GLUProjection.Vector3D(0.0, -20.0, 0.0);
        double radius = 50.0;
        int tiles = 30;
        GL11.glPushMatrix();
        GL11.glBegin((int)4);
        for (int tx = -tiles; tx < tiles; ++tx) {
            for (int tz = -tiles; tz < tiles; ++tz) {
                GLUProjection.Vector3D tp1 = new GLUProjection.Vector3D((double)tx * tileSize, 0.0, (double)tz * tileSize);
                tp1 = cp.add(tp1.sub(cp).normalized().mul(radius)).add(yOffset);
                GLUProjection.Vector3D tp2 = new GLUProjection.Vector3D((double)tx * tileSize, 0.0, (double)(tz + 1) * tileSize);
                tp2 = cp.add(tp2.sub(cp).normalized().mul(radius)).add(yOffset);
                GLUProjection.Vector3D tp3 = new GLUProjection.Vector3D((double)(tx + 1) * tileSize, 0.0, (double)(tz + 1) * tileSize);
                tp3 = cp.add(tp3.sub(cp).normalized().mul(radius)).add(yOffset);
                GLUProjection.Vector3D tp4 = new GLUProjection.Vector3D((double)(tx + 1) * tileSize, 0.0, (double)tz * tileSize);
                tp4 = cp.add(tp4.sub(cp).normalized().mul(radius)).add(yOffset);
                double u00 = tp1.x / (radius * 2.0) + 0.5;
                double u10 = tp4.x / (radius * 2.0) + 0.5;
                double u11 = tp3.x / (radius * 2.0) + 0.5;
                double u01 = tp2.x / (radius * 2.0) + 0.5;
                double v00 = 1.0 - (tp1.z / (radius * 2.0) + 0.5);
                double v10 = 1.0 - (tp4.z / (radius * 2.0) + 0.5);
                double v11 = 1.0 - (tp3.z / (radius * 2.0) + 0.5);
                double v01 = 1.0 - (tp2.z / (radius * 2.0) + 0.5);
                GL11.glTexCoord2d((double)u00, (double)v00);
                GL11.glVertex3d((double)tp1.x, (double)tp1.y, (double)tp1.z);
                GL11.glTexCoord2d((double)u11, (double)v11);
                GL11.glVertex3d((double)tp3.x, (double)tp3.y, (double)tp3.z);
                GL11.glTexCoord2d((double)u01, (double)v01);
                GL11.glVertex3d((double)tp2.x, (double)tp2.y, (double)tp2.z);
                GL11.glTexCoord2d((double)u11, (double)v11);
                GL11.glVertex3d((double)tp3.x, (double)tp3.y, (double)tp3.z);
                GL11.glTexCoord2d((double)u00, (double)v00);
                GL11.glVertex3d((double)tp1.x, (double)tp1.y, (double)tp1.z);
                GL11.glTexCoord2d((double)u10, (double)v10);
                GL11.glVertex3d((double)tp4.x, (double)tp4.y, (double)tp4.z);
            }
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void renderSkyTexture(Minecraft mc, boolean renderClipPlane) {
        MainShader shader;
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        GL11.glDepthMask((boolean)false);
        mc.field_71446_o.func_110577_a(SKY_TEXTURE_RES);
        if (ShaderHelper.INSTANCE.canUseShaders() && (shader = ShaderHelper.INSTANCE.getCurrentShader()) != null && shader.getStarfieldTextureID() >= 0) {
            GL11.glBindTexture((int)3553, (int)shader.getStarfieldTextureID());
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (!renderClipPlane) {
            tessellator.func_78382_b();
            tessellator.func_78374_a(-90.0, -40.0, -90.0, 0.0, 0.0);
            tessellator.func_78374_a(-90.0, -40.0, 90.0, 0.0, 1.0);
            tessellator.func_78374_a(90.0, -40.0, 90.0, 1.0, 1.0);
            tessellator.func_78374_a(90.0, -40.0, -90.0, 1.0, 0.0);
            tessellator.func_78381_a();
        } else {
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2912);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.clipPlaneBuffer.updateBuffers(Minecraft.func_71410_x().func_147110_a());
            this.clipPlaneBuffer.bind();
            this.clipPlaneBuffer.clear(0.0f, 0.0f, 0.0f, 0.0f);
            tessellator.func_78382_b();
            tessellator.func_78370_a(255, 255, 255, 255);
            tessellator.func_78377_a(-9000.0, -90.0, -9000.0);
            tessellator.func_78377_a(-9000.0, -90.0, 9000.0);
            tessellator.func_78377_a(9000.0, -90.0, 9000.0);
            tessellator.func_78377_a(9000.0, -90.0, -9000.0);
            tessellator.func_78381_a();
            this.clipPlaneBuffer.updateDepth();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
        }
        GL11.glPopMatrix();
    }

    private void renderAuroras(Minecraft mc) {
        Random rand = mc.field_71441_e.field_73012_v;
        double newAuroraPosX = mc.field_71439_g.field_70165_t + (double)rand.nextInt(160) - 80.0;
        double newAuroraPosZ = mc.field_71439_g.field_70161_v + (double)rand.nextInt(160) - 80.0;
        double newAuroraPosY = 180.0;
        double minDist = 0.0;
        Iterator<AuroraRenderer> auroraIT = this.auroras.iterator();
        while (auroraIT.hasNext()) {
            double dist;
            AuroraRenderer aurora = auroraIT.next();
            if (aurora.getDistance(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v) > 180.0) {
                auroraIT.remove();
                this.auroras.remove(aurora);
            }
            if (!((dist = aurora.getDistance(newAuroraPosX, newAuroraPosY, newAuroraPosZ)) < minDist) && minDist != 0.0) continue;
            minDist = dist;
        }
        if (minDist > 150.0 || this.auroras.size() == 0) {
            this.auroras.add(new AuroraRenderer(newAuroraPosX, newAuroraPosY, newAuroraPosZ, new Vector2d((double)(rand.nextFloat() * 2.0f - 1.0f), (double)(rand.nextFloat() * 2.0f - 1.0f)), rand.nextInt(40) + 15));
        }
        ArrayList<Vector4f> gradients = new ArrayList<Vector4f>();
        EventAuroras event = null;
        if (mc.field_71441_e != null && mc.field_71441_e.field_73011_w instanceof WorldProviderBetweenlands) {
            event = ((WorldProviderBetweenlands)mc.field_71441_e.field_73011_w).getWorldData().getEnvironmentEventRegistry().AURORAS;
        }
        if (event != null) {
            switch (event.getAuroraType()) {
                case 0: {
                    gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.01f));
                    gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.15f));
                    gradients.add(new Vector4f(0.0f, 1.0f, 0.8f, 0.8f));
                    gradients.add(new Vector4f(0.0f, 0.7f, 1.0f, 0.15f));
                    gradients.add(new Vector4f(0.0f, 0.4f, 1.0f, 0.01f));
                    break;
                }
                case 1: {
                    gradients.add(new Vector4f(1.0f, 0.0f, 0.0f, 0.05f));
                    gradients.add(new Vector4f(1.0f, 0.0f, 0.0f, 0.2f));
                    gradients.add(new Vector4f(1.0f, 0.0f, 0.5f, 0.5f));
                    gradients.add(new Vector4f(1.0f, 0.2f, 0.5f, 0.8f));
                    gradients.add(new Vector4f(1.0f, 0.0f, 0.5f, 0.5f));
                    gradients.add(new Vector4f(0.8f, 0.0f, 0.5f, 0.25f));
                    break;
                }
                case 2: {
                    gradients.add(new Vector4f(0.0f, 1.0f, 0.0f, 0.05f));
                    gradients.add(new Vector4f(0.5f, 1.0f, 0.0f, 0.15f));
                    gradients.add(new Vector4f(1.0f, 0.8f, 0.0f, 0.7f));
                    gradients.add(new Vector4f(0.5f, 0.4f, 0.0f, 0.15f));
                    gradients.add(new Vector4f(1.0f, 0.2f, 0.0f, 0.05f));
                }
            }
        }
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        for (AuroraRenderer aurora : this.auroras) {
            aurora.render(0.4f, gradients);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)3008);
        GL11.glDepthMask((boolean)true);
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        RenderGlobal renderGlobal = mc.field_71438_f;
        Vec3 skyColor = world.func_72833_a((Entity)mc.field_71451_h, partialTicks);
        float skyR = (float)skyColor.field_72450_a;
        float skyG = (float)skyColor.field_72448_b;
        float skyB = (float)skyColor.field_72449_c;
        float anaglyphR = 0.0f;
        float anaglyphG = 0.0f;
        float anaglyphB = 0.0f;
        if (mc.field_71474_y.field_74337_g) {
            anaglyphR = (skyR * 30.0f + skyG * 59.0f + skyB * 11.0f) / 100.0f;
            anaglyphG = (skyR * 30.0f + skyG * 70.0f) / 100.0f;
            anaglyphB = (skyR * 30.0f + skyB * 70.0f) / 100.0f;
            skyR = anaglyphR;
            skyG = anaglyphG;
            skyB = anaglyphB;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glFogf((int)2915, (float)FogHandler.INSTANCE.getCurrentFogStart());
        GL11.glFogf((int)2916, (float)(FogHandler.INSTANCE.getCurrentFogEnd() * FogHandler.INSTANCE.getCurrentFogEnd() / 15.0f));
        GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float sunriseSunsetR = 0.0f;
        float sunriseSunsetG = 0.0f;
        float sunriseSunsetB = 0.0f;
        float[] sunriseSunsetColors = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (sunriseSunsetColors != null) {
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            sunriseSunsetR = sunriseSunsetColors[0];
            sunriseSunsetG = sunriseSunsetColors[1];
            sunriseSunsetB = sunriseSunsetColors[2];
            if (mc.field_71474_y.field_74337_g) {
                anaglyphR = (sunriseSunsetR * 30.0f + sunriseSunsetG * 59.0f + sunriseSunsetB * 11.0f) / 100.0f;
                anaglyphG = (sunriseSunsetR * 30.0f + sunriseSunsetG * 70.0f) / 100.0f;
                anaglyphB = (sunriseSunsetR * 30.0f + sunriseSunsetB * 70.0f) / 100.0f;
                sunriseSunsetR = anaglyphR;
                sunriseSunsetG = anaglyphG;
                sunriseSunsetB = anaglyphB;
            }
            tessellator.func_78371_b(6);
            tessellator.func_78369_a(sunriseSunsetR, sunriseSunsetG, sunriseSunsetB, sunriseSunsetColors[3]);
            tessellator.func_78377_a(0.0, 100.0, 0.0);
            tessellator.func_78369_a(sunriseSunsetColors[0], sunriseSunsetColors[1], sunriseSunsetColors[2], 0.0f);
            int segments = 16;
            for (int j = 0; j <= segments; ++j) {
                float angle = (float)j * (float)Math.PI * 2.0f / (float)segments;
                float vx = MathHelper.func_76126_a((float)angle);
                float vy = MathHelper.func_76134_b((float)angle);
                tessellator.func_78377_a((double)(vx * 120.0f), (double)(vy * 120.0f), (double)(-vy * 40.0f * sunriseSunsetColors[3]));
            }
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        float invRainStrength = 1.0f - world.func_72867_j(partialTicks);
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        boolean useShaderSky = ShaderHelper.INSTANCE.canUseShaders() && ShaderHelper.INSTANCE.getCurrentShader() != null && ShaderHelper.INSTANCE.getCurrentShader().getStarfieldTextureID() >= 0;
        float starBrightness = (world.func_72880_h(partialTicks) + 0.5f) * invRainStrength * invRainStrength * invRainStrength;
        float fade = 1.0f;
        WorldProviderBetweenlands provider = WorldProviderBetweenlands.getProvider((World)mc.field_71441_e);
        if (provider != null) {
            fade = provider.getEnvironmentEventRegistry().DENSE_FOG.getFade(partialTicks) * 0.95f + 0.05f;
        }
        if ((starBrightness *= fade) > 0.0f && !useShaderSky) {
            GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)((starBrightness - 0.22f) * 3.5f));
            GL11.glBlendFunc((int)32771, (int)32772);
            GL11.glPushMatrix();
            GL11.glRotated((double)55.0, (double)1.0, (double)0.0, (double)0.0);
            this.starMesh.render();
            GL11.glPopMatrix();
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)32771, (int)32772);
        }
        GL11.glPopMatrix();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double horizon = mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b - world.func_72919_O();
        float relHorizon = -((float)(horizon + 65.0));
        if (horizon < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)this.skyDispList2);
            GL11.glPopMatrix();
            float boxWidth = 2.0f * relHorizon;
            float boxHeight = -boxWidth;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78377_a((double)(-boxWidth), (double)relHorizon, (double)boxWidth);
            tessellator.func_78377_a((double)boxWidth, (double)relHorizon, (double)boxWidth);
            tessellator.func_78377_a((double)boxWidth, (double)boxHeight, (double)boxWidth);
            tessellator.func_78377_a((double)(-boxWidth), (double)boxHeight, (double)boxWidth);
            tessellator.func_78377_a((double)(-boxWidth), (double)boxHeight, (double)(-boxWidth));
            tessellator.func_78377_a((double)boxWidth, (double)boxHeight, (double)(-boxWidth));
            tessellator.func_78377_a((double)boxWidth, (double)relHorizon, (double)(-boxWidth));
            tessellator.func_78377_a((double)(-boxWidth), (double)relHorizon, (double)(-boxWidth));
            tessellator.func_78377_a((double)boxWidth, (double)boxHeight, (double)(-boxWidth));
            tessellator.func_78377_a((double)boxWidth, (double)boxHeight, (double)boxWidth);
            tessellator.func_78377_a((double)boxWidth, (double)relHorizon, (double)boxWidth);
            tessellator.func_78377_a((double)boxWidth, (double)relHorizon, (double)(-boxWidth));
            tessellator.func_78377_a((double)(-boxWidth), (double)relHorizon, (double)(-boxWidth));
            tessellator.func_78377_a((double)(-boxWidth), (double)relHorizon, (double)boxWidth);
            tessellator.func_78377_a((double)(-boxWidth), (double)boxHeight, (double)boxWidth);
            tessellator.func_78377_a((double)(-boxWidth), (double)boxHeight, (double)(-boxWidth));
            tessellator.func_78377_a((double)(-boxWidth), (double)boxHeight, (double)(-boxWidth));
            tessellator.func_78377_a((double)(-boxWidth), (double)boxHeight, (double)boxWidth);
            tessellator.func_78377_a((double)boxWidth, (double)boxHeight, (double)boxWidth);
            tessellator.func_78377_a((double)boxWidth, (double)boxHeight, (double)(-boxWidth));
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GL11.glColor3f((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        }
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)0.1f, (float)0.8f, (float)0.55f, (float)(starBrightness / (!useShaderSky ? 1.5f : 1.0f)));
        if (useShaderSky) {
            GL11.glBindTexture((int)3553, (int)ShaderHelper.INSTANCE.getCurrentShader().getStarfieldTextureID());
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3553);
            RenderHelper.func_74518_a();
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glCallList((int)this.skyDispListStart);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            this.renderSkyTexture(mc, true);
        } else if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            mc.field_71446_o.func_110577_a(SKY_TEXTURE_RES);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3553);
            RenderHelper.func_74518_a();
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glCallList((int)this.skyDispListStart);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
        } else {
            this.renderSkyTexture(mc, false);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GL11.glPushMatrix();
            float renderRadius = 80.0f;
            GL11.glEnable((int)2912);
            GL11.glFogf((int)2915, (float)(renderRadius / 2.0f));
            GL11.glFogf((int)2916, (float)(renderRadius * 2.0f));
            GL11.glScaled((double)(0.02f * renderRadius), (double)(0.02f * renderRadius), (double)(0.02f * renderRadius));
            GL11.glTranslated((double)0.0, (double)10.0, (double)0.0);
            mc.field_71446_o.func_110577_a(FOG_TEXTURE_RES);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
            RenderHelper.func_74518_a();
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glCallList((int)this.skyDispListStart);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glPopMatrix();
            GL11.glFogf((int)2915, (float)FogHandler.INSTANCE.getCurrentFogStart());
            GL11.glFogf((int)2916, (float)FogHandler.INSTANCE.getCurrentFogEnd());
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2912);
            mc.field_71446_o.func_110577_a(SKY_SPOOPY_TEXTURE_RES);
            GL11.glPushMatrix();
            GL11.glRotatef((float)-120.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)50.0, (double)0.0);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3553);
            RenderHelper.func_74518_a();
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glCallList((int)this.skyDispListStart);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glPopMatrix();
        }
        if (mc.field_71441_e != null && mc.field_71441_e.field_73011_w instanceof WorldProviderBetweenlands && ((WorldProviderBetweenlands)mc.field_71441_e.field_73011_w).getWorldData().getEnvironmentEventRegistry().AURORAS.isActive()) {
            GL11.glDisable((int)2912);
            this.renderAuroras(mc);
        }
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

