/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sky;

import java.util.List;
import java.util.Random;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.utils.TextureAtlasHelper;

public class AuroraRenderer {
    private static final ResourceLocation AURORA_TEXTURE = new ResourceLocation("thebetweenlands:textures/sky/aurora.png");
    private static final TextureAtlasHelper atlas = new TextureAtlasHelper(320, 128, 64, 128, 0, 0);
    private double x;
    private double y;
    private double z;
    private Vector2d direction;
    private Vector2d currDirection;
    private int tiles = 14;

    public AuroraRenderer(double x, double y, double z, Vector2d direction, int tiles) {
        this.x = x;
        this.y = y;
        this.z = z;
        direction.normalize();
        this.direction = direction;
        this.tiles = tiles;
    }

    private Vector2d getRotatedVec(double offset, Vector2d direction) {
        Vector3d upVec = new Vector3d(0.0, 1.0, 0.0);
        upVec.cross(upVec, new Vector3d(direction.x, 0.0, direction.y));
        Vector2d res = new Vector2d(upVec.x, upVec.z);
        res.scale(offset);
        return res;
    }

    private float interpolatedNoise(float noisePos) {
        int posRounded = (int)noisePos;
        float posFraction = noisePos - (float)posRounded;
        float noiseGrad1 = this.getNoiseGradient(posRounded);
        float noiseGrad2 = this.getNoiseGradient(posRounded + 1);
        return this.cosineInterpolate(noiseGrad1, noiseGrad2, posFraction);
    }

    private float perlinNoise1D(float noisePos, float persistence, int octaves) {
        float octaveNoise = 0.0f;
        for (int i = 0; i < octaves; ++i) {
            float frequency = (float)Math.pow(2.0, i);
            double amplitude = Math.pow(persistence, i);
            octaveNoise = (float)((double)octaveNoise + (double)this.interpolatedNoise(noisePos * frequency) * amplitude);
        }
        return (int)octaveNoise;
    }

    private float getNoiseGradient(int noisePosRounded) {
        return this.getNoise(noisePosRounded) / 2.0f + this.getNoise(noisePosRounded - 1) / 4.0f + this.getNoise(noisePosRounded + 1) / 4.0f;
    }

    private float getNoise(int noisePosRounded) {
        noisePosRounded = noisePosRounded << 13 ^ noisePosRounded;
        return (float)(1.0 - (double)(noisePosRounded * (noisePosRounded * noisePosRounded * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9);
    }

    private float cosineInterpolate(float noiseGrad1, float noiseGrad2, float posFraction) {
        float cosVal = (float)((1.0 - Math.cos((float)((double)posFraction * Math.PI))) * 0.5);
        return noiseGrad1 * (1.0f - cosVal) + noiseGrad2 * cosVal;
    }

    public double getDistance(double x, double y, double z) {
        return Math.sqrt((this.x - x) * (this.x - x) + (this.y - y) * (this.y - y) + (this.z - z) * (this.z - z));
    }

    public void render(float alphaMultiplier, List<Vector4f> colorGradients) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int segments = this.tiles;
        int subSegments = 5;
        double segmentWidth = 15.0;
        double segmentHeight = 40.0;
        int cGradients = colorGradients.size();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2896);
        Random rand = new Random();
        rand.setSeed((int)(this.x + this.y + this.z) ^ (int)(this.x * this.y * this.z));
        int randNoiseOffset = rand.nextInt(100);
        Vector2d prevDirection = this.currDirection = new Vector2d(this.direction.x, this.direction.y);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AURORA_TEXTURE);
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        for (int i = 0; i < segments; ++i) {
            int textureSegment = rand.nextInt(5) + 1;
            for (int si = 0; si < subSegments; ++si) {
                prevDirection = new Vector2d(this.currDirection.x, this.currDirection.y);
                float dirXNoise = this.interpolatedNoise((float)(randNoiseOffset * 10) + 0.01f * ((float)i + (float)si / (float)subSegments + (float)((double)System.nanoTime() / 7.0E9))) * 0.1f - 0.05f;
                float dirYNoise = this.interpolatedNoise((float)(randNoiseOffset * 20) + 0.01f * (((float)i + (float)si / (float)subSegments + (float)((double)System.nanoTime() / 7.0E9)) * 5.0f)) * 0.1f - 0.05f;
                this.currDirection = new Vector2d(this.currDirection.x + (double)dirXNoise, this.currDirection.y + (double)dirYNoise);
                this.currDirection.normalize();
                float offset1 = this.interpolatedNoise((float)randNoiseOffset + ((float)i + (float)si / (float)subSegments) * 2.0f + (float)((double)System.nanoTime() / 4.0E9)) * 10.0f;
                float offset2 = this.interpolatedNoise((float)randNoiseOffset + ((float)i + (float)(si + 1) / (float)subSegments) * 2.0f + (float)((double)System.nanoTime() / 4.0E9)) * 10.0f;
                double segStartX = this.x + prevDirection.x * (double)((float)i + (float)si / (float)subSegments) * segmentWidth + this.getRotatedVec((double)((double)offset1), (Vector2d)prevDirection).x;
                double segStartZ = this.z + prevDirection.y * (double)((float)i + (float)si / (float)subSegments) * segmentWidth + this.getRotatedVec((double)((double)offset1), (Vector2d)prevDirection).y;
                double segStopX = this.x + this.currDirection.x * (double)((float)i + (float)(si + 1) / (float)subSegments) * segmentWidth + this.getRotatedVec((double)((double)offset2), (Vector2d)this.currDirection).x;
                double segStopZ = this.z + this.currDirection.y * (double)((float)i + (float)(si + 1) / (float)subSegments) * segmentWidth + this.getRotatedVec((double)((double)offset2), (Vector2d)this.currDirection).y;
                double relUMin = (float)(si + 1) / (float)subSegments;
                double relUMax = (float)si / (float)subSegments;
                float salphaGradMultiplier = 1.0f;
                float salphaGradMultiplierNext = 1.0f;
                if (i == 0) {
                    salphaGradMultiplier = 1.0f / (float)subSegments * (float)si;
                    salphaGradMultiplierNext = 1.0f / (float)subSegments * (float)(si + 1);
                } else if (i == segments - 1) {
                    salphaGradMultiplier = 1.0f / (float)subSegments * (float)(subSegments - si);
                    salphaGradMultiplierNext = 1.0f / (float)subSegments * (float)(subSegments - (si + 1));
                }
                for (int gi = 0; gi < cGradients - 1; ++gi) {
                    double segStartY = this.y + segmentHeight / (double)(cGradients - 1) * (double)gi;
                    double segStopY = this.y + segmentHeight / (double)(cGradients - 1) * (double)(gi + 1);
                    double vmax = (float)(gi + 1) / (float)(cGradients - 1);
                    double vmin = (float)gi / (float)(cGradients - 1);
                    float[][] interpolatedUVs = atlas.getInterpolatedUVs(textureSegment, (float)relUMin, (float)vmin, (float)relUMax, (float)vmax);
                    vmin = interpolatedUVs[0][1];
                    vmax = interpolatedUVs[1][1];
                    float umin = interpolatedUVs[0][0];
                    float umax = interpolatedUVs[1][0];
                    Vector4f bottomGradient = colorGradients.get(gi);
                    Vector4f topGradient = colorGradients.get(gi + 1);
                    double camDist = Minecraft.func_71410_x().field_71451_h.func_70011_f(segStopX, Minecraft.func_71410_x().field_71451_h.field_70163_u, segStopZ);
                    float alphaGradMultiplier = salphaGradMultiplier;
                    float alphaGradMultiplierNext = salphaGradMultiplierNext;
                    float viewDist = (float)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0f - 10.0f;
                    if (camDist > (double)viewDist) {
                        alphaGradMultiplier = (float)((double)alphaGradMultiplier * (10.0 / (camDist - (double)(viewDist - 10.0f))));
                        alphaGradMultiplierNext = (float)((double)alphaGradMultiplierNext * (10.0 / (camDist - (double)(viewDist - 10.0f))));
                    }
                    tessellator.func_78369_a(topGradient.x, topGradient.y, topGradient.z, topGradient.w * alphaGradMultiplier * alphaMultiplier);
                    tessellator.func_78374_a(segStartX, segStopY, segStartZ, (double)umax, vmax);
                    tessellator.func_78369_a(topGradient.x, topGradient.y, topGradient.z, topGradient.w * alphaGradMultiplierNext * alphaMultiplier);
                    tessellator.func_78374_a(segStopX, segStopY, segStopZ, (double)umin, vmax);
                    tessellator.func_78369_a(bottomGradient.x, bottomGradient.y, bottomGradient.z, bottomGradient.w * alphaGradMultiplierNext * alphaMultiplier);
                    tessellator.func_78374_a(segStopX, segStartY, segStopZ, (double)umin, vmin);
                    tessellator.func_78369_a(bottomGradient.x, bottomGradient.y, bottomGradient.z, bottomGradient.w * alphaGradMultiplier * alphaMultiplier);
                    tessellator.func_78374_a(segStartX, segStartY, segStartZ, (double)umax, vmin);
                    tessellator.func_78369_a(topGradient.x, topGradient.y, topGradient.z, topGradient.w * alphaGradMultiplier * alphaMultiplier);
                    tessellator.func_78374_a(segStartX, segStopY, segStartZ, (double)umax, vmax);
                    tessellator.func_78369_a(bottomGradient.x, bottomGradient.y, bottomGradient.z, bottomGradient.w * alphaGradMultiplier * alphaMultiplier);
                    tessellator.func_78374_a(segStartX, segStartY, segStartZ, (double)umax, vmin);
                    tessellator.func_78369_a(bottomGradient.x, bottomGradient.y, bottomGradient.z, bottomGradient.w * alphaGradMultiplierNext * alphaMultiplier);
                    tessellator.func_78374_a(segStopX, segStartY, segStopZ, (double)umin, vmin);
                    tessellator.func_78369_a(topGradient.x, topGradient.y, topGradient.z, topGradient.w * alphaGradMultiplierNext * alphaMultiplier);
                    tessellator.func_78374_a(segStopX, segStopY, segStopZ, (double)umin, vmax);
                }
            }
        }
        tessellator.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
    }
}

