/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader.effect;

import java.nio.FloatBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.shader.effect.PostProcessingEffect;

public class StarfieldEffect
extends PostProcessingEffect {
    private final boolean faded;
    private float timeScale = 1.0f;
    private float zoom = 1.0f;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;
    private int timeUniformID = -1;
    private int timeScaleUniformID = -1;
    private int zoomUniformID = -1;
    private int offsetXUniformID = -1;
    private int offsetYUniformID = -1;
    private int offsetZUniformID = -1;

    public StarfieldEffect(boolean faded) {
        this.faded = faded;
    }

    public StarfieldEffect setTimeScale(float timeScale) {
        this.timeScale = timeScale;
        return this;
    }

    public StarfieldEffect setZoom(float zoom) {
        this.zoom = zoom;
        return this;
    }

    public StarfieldEffect setOffset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    @Override
    protected ResourceLocation[] getShaders() {
        return new ResourceLocation[]{new ResourceLocation("thebetweenlands:shaders/postprocessing/starfield/starfield.vsh"), this.faded ? new ResourceLocation("thebetweenlands:shaders/postprocessing/starfield/starfieldFaded.fsh") : new ResourceLocation("thebetweenlands:shaders/postprocessing/starfield/starfield.fsh")};
    }

    @Override
    protected boolean initEffect() {
        this.timeUniformID = OpenGlHelper.func_153194_a((int)this.getShaderProgram(), (CharSequence)"u_msTime");
        this.timeScaleUniformID = OpenGlHelper.func_153194_a((int)this.getShaderProgram(), (CharSequence)"u_timeScale");
        this.zoomUniformID = OpenGlHelper.func_153194_a((int)this.getShaderProgram(), (CharSequence)"u_zoom");
        this.offsetXUniformID = OpenGlHelper.func_153194_a((int)this.getShaderProgram(), (CharSequence)"u_offsetX");
        this.offsetYUniformID = OpenGlHelper.func_153194_a((int)this.getShaderProgram(), (CharSequence)"u_offsetY");
        this.offsetZUniformID = OpenGlHelper.func_153194_a((int)this.getShaderProgram(), (CharSequence)"u_offsetZ");
        return true;
    }

    @Override
    protected void uploadUniforms() {
        OpenGlHelper.func_153168_a((int)this.timeUniformID, (FloatBuffer)this.getSingleFloatBuffer((float)System.nanoTime() / 1000000.0f));
        OpenGlHelper.func_153168_a((int)this.timeScaleUniformID, (FloatBuffer)this.getSingleFloatBuffer(this.timeScale));
        OpenGlHelper.func_153168_a((int)this.zoomUniformID, (FloatBuffer)this.getSingleFloatBuffer(this.zoom));
        OpenGlHelper.func_153168_a((int)this.offsetXUniformID, (FloatBuffer)this.getSingleFloatBuffer(this.offsetX));
        OpenGlHelper.func_153168_a((int)this.offsetYUniformID, (FloatBuffer)this.getSingleFloatBuffer(this.offsetY));
        OpenGlHelper.func_153168_a((int)this.offsetZUniformID, (FloatBuffer)this.getSingleFloatBuffer(this.offsetZ));
    }
}

