/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader.effect;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public abstract class PostProcessingEffect {
    private float cr;
    private float cg;
    private float cb;
    private float ca;
    private PostProcessingEffect[] stages;
    private static final FloatBuffer TEXEL_SIZE_BUFFER = BufferUtils.createFloatBuffer((int)2);
    private int shaderProgramID = -1;
    private int diffuseSamplerUniformID = -1;
    private int texelSizeUniformID = -1;

    public final PostProcessingEffect init() {
        this.initShaders();
        this.stages = this.getStages();
        if (this.stages != null && this.stages.length > 0) {
            for (PostProcessingEffect stage : this.stages) {
                stage.init();
            }
        }
        if (!this.initEffect()) {
            throw new RuntimeException("Couldn't initialize shaders for post processing effect: " + this.toString());
        }
        return this;
    }

    public final PostProcessingEffect setBackgroundColor(float r, float g, float b, float a) {
        this.cr = r;
        this.cg = g;
        this.cb = b;
        this.ca = a;
        return this;
    }

    public final int getShaderProgram() {
        return this.shaderProgramID;
    }

    public final void delete() {
        OpenGlHelper.func_153187_e((int)this.shaderProgramID);
        if (this.stages != null && this.stages.length > 0) {
            for (PostProcessingEffect stage : this.stages) {
                stage.delete();
            }
        }
        this.deleteEffect();
    }

    public EffectBuilder create(Framebuffer dst) {
        return new EffectBuilder(this, dst);
    }

    private final void render(int src, Framebuffer dst, Framebuffer blitBuffer, Framebuffer prev, double renderWidth, double renderHeight, boolean restore) {
        if (this.shaderProgramID == -1 || dst == null) {
            return;
        }
        dst.func_147610_a(true);
        int prevShaderProgram = 0;
        if (restore) {
            GL11.glPushAttrib((int)7072);
            prevShaderProgram = GL11.glGetInteger((int)35725);
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)dst.field_147621_c, (double)dst.field_147618_d, (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
        GL11.glClearColor((float)this.cr, (float)this.cg, (float)this.cb, (float)this.ca);
        GL11.glClear((int)16640);
        OpenGlHelper.func_153161_d((int)this.shaderProgramID);
        if (this.diffuseSamplerUniformID >= 0 && src >= 0) {
            OpenGlHelper.func_153163_f((int)this.diffuseSamplerUniformID, (int)0);
            GL13.glActiveTexture((int)33984);
            GL11.glEnable((int)3553);
            GL11.glBindTexture((int)3553, (int)src);
        }
        if (this.texelSizeUniformID >= 0) {
            TEXEL_SIZE_BUFFER.position(0);
            TEXEL_SIZE_BUFFER.put(1.0f / (float)dst.field_147621_c);
            TEXEL_SIZE_BUFFER.put(1.0f / (float)dst.field_147618_d);
            TEXEL_SIZE_BUFFER.flip();
            OpenGlHelper.func_153177_b((int)this.texelSizeUniformID, (FloatBuffer)TEXEL_SIZE_BUFFER);
        }
        this.uploadUniforms();
        GL11.glBegin((int)4);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)0.0, (double)renderHeight);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2d((double)renderWidth, (double)0.0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glEnd();
        if (blitBuffer != null && this.stages != null && this.stages.length > 0) {
            for (PostProcessingEffect stage : this.stages) {
                stage.render(dst.field_147617_g, blitBuffer, dst, null, renderWidth, renderHeight, false);
                dst.func_147610_a(true);
                GL11.glBindTexture((int)3553, (int)blitBuffer.field_147617_g);
                GL11.glBegin((int)4);
                GL11.glTexCoord2d((double)0.0, (double)1.0);
                GL11.glVertex2d((double)0.0, (double)0.0);
                GL11.glTexCoord2d((double)0.0, (double)0.0);
                GL11.glVertex2d((double)0.0, (double)renderHeight);
                GL11.glTexCoord2d((double)1.0, (double)0.0);
                GL11.glVertex2d((double)renderWidth, (double)renderHeight);
                GL11.glTexCoord2d((double)1.0, (double)0.0);
                GL11.glVertex2d((double)renderWidth, (double)renderHeight);
                GL11.glTexCoord2d((double)1.0, (double)1.0);
                GL11.glVertex2d((double)renderWidth, (double)0.0);
                GL11.glTexCoord2d((double)0.0, (double)1.0);
                GL11.glVertex2d((double)0.0, (double)0.0);
                GL11.glEnd();
            }
        }
        OpenGlHelper.func_153161_d((int)prevShaderProgram);
        if (restore) {
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            if (prev != null) {
                prev.func_147610_a(true);
            }
        }
    }

    private void initShaders() {
        if (this.shaderProgramID == -1) {
            this.shaderProgramID = OpenGlHelper.func_153183_d();
            int vertexShaderID = -1;
            int fragmentShaderID = -1;
            try {
                ResourceLocation[] shaderLocations = this.getShaders();
                String[] shaders = new String[2];
                for (int i = 0; i < 2; ++i) {
                    StringWriter strBuf = new StringWriter();
                    IOUtils.copy((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(shaderLocations[i]).func_110527_b(), (Writer)strBuf, (String)"UTF-8");
                    shaders[i] = strBuf.toString();
                }
                vertexShaderID = PostProcessingEffect.createShader(shaders[0], 35633);
                fragmentShaderID = PostProcessingEffect.createShader(shaders[1], 35632);
            }
            catch (Exception ex) {
                this.shaderProgramID = -1;
                vertexShaderID = -1;
                fragmentShaderID = -1;
                throw new RuntimeException("Error creating shader", ex);
            }
            if (this.shaderProgramID != -1 && vertexShaderID != -1 && fragmentShaderID != -1) {
                OpenGlHelper.func_153178_b((int)this.shaderProgramID, (int)vertexShaderID);
                OpenGlHelper.func_153178_b((int)this.shaderProgramID, (int)fragmentShaderID);
                OpenGlHelper.func_153179_f((int)this.shaderProgramID);
                if (OpenGlHelper.func_153175_a((int)this.shaderProgramID, (int)35714) == 0) {
                    throw new RuntimeException("Error creating shader: " + PostProcessingEffect.getLogInfoProgram(this.shaderProgramID));
                }
                GL20.glValidateProgram((int)this.shaderProgramID);
                if (OpenGlHelper.func_153175_a((int)this.shaderProgramID, (int)35715) == 0) {
                    throw new RuntimeException("Error creating shader: " + PostProcessingEffect.getLogInfoProgram(this.shaderProgramID));
                }
                OpenGlHelper.func_153180_a((int)vertexShaderID);
                OpenGlHelper.func_153180_a((int)fragmentShaderID);
                this.diffuseSamplerUniformID = OpenGlHelper.func_153194_a((int)this.shaderProgramID, (CharSequence)"s_diffuse");
                this.texelSizeUniformID = OpenGlHelper.func_153194_a((int)this.shaderProgramID, (CharSequence)"u_oneTexel");
                OpenGlHelper.func_153161_d((int)0);
            } else {
                if (vertexShaderID != -1) {
                    OpenGlHelper.func_153180_a((int)vertexShaderID);
                }
                if (fragmentShaderID != 1) {
                    OpenGlHelper.func_153180_a((int)fragmentShaderID);
                }
                if (this.shaderProgramID != -1) {
                    OpenGlHelper.func_153187_e((int)this.shaderProgramID);
                }
            }
        }
    }

    private static int createShader(String shaderCode, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = OpenGlHelper.func_153195_b((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            byte[] shaderCodeBytes = shaderCode.getBytes();
            ByteBuffer shaderCodeByteBuffer = BufferUtils.createByteBuffer((int)shaderCodeBytes.length);
            shaderCodeByteBuffer.put(shaderCodeBytes);
            shaderCodeByteBuffer.position(0);
            OpenGlHelper.func_153169_a((int)shader, (ByteBuffer)shaderCodeByteBuffer);
            OpenGlHelper.func_153170_c((int)shader);
            if (OpenGlHelper.func_153157_c((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + PostProcessingEffect.getLogInfoShader(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            OpenGlHelper.func_153180_a((int)shader);
            throw exc;
        }
    }

    private static String getLogInfoShader(int obj) {
        return OpenGlHelper.func_153158_d((int)obj, (int)OpenGlHelper.func_153157_c((int)obj, (int)35716));
    }

    private static String getLogInfoProgram(int obj) {
        return OpenGlHelper.func_153166_e((int)obj, (int)OpenGlHelper.func_153175_a((int)obj, (int)35716));
    }

    protected abstract ResourceLocation[] getShaders();

    protected void uploadUniforms() {
    }

    protected PostProcessingEffect[] getStages() {
        return null;
    }

    protected void deleteEffect() {
    }

    protected boolean initEffect() {
        return true;
    }

    protected FloatBuffer getSingleFloatBuffer(float value) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)1);
        floatBuffer.put(value);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static final class EffectBuilder {
        private final PostProcessingEffect effect;
        private final Framebuffer dst;
        private int src = -1;
        private Framebuffer blitFBO = null;
        private Framebuffer prevFBO = null;
        private double renderWidth = -1.0;
        private double renderHeight = -1.0;
        private boolean restore = true;

        protected EffectBuilder(PostProcessingEffect effect, Framebuffer dst) {
            this.effect = effect;
            this.dst = dst;
        }

        public EffectBuilder setSource(int src) {
            this.src = src;
            return this;
        }

        public EffectBuilder setBlitFBO(Framebuffer blitFBO) {
            this.blitFBO = blitFBO;
            return this;
        }

        public EffectBuilder setPreviousFBO(Framebuffer prevFBO) {
            this.prevFBO = prevFBO;
            return this;
        }

        public EffectBuilder setRenderDimensions(double renderWidth, double renderHeight) {
            this.renderWidth = renderWidth;
            this.renderHeight = renderHeight;
            return this;
        }

        public EffectBuilder setRestoreGlState(boolean restore) {
            this.restore = restore;
            return this;
        }

        public void render() {
            double renderWidth = this.renderWidth;
            double renderHeight = this.renderHeight;
            if (renderWidth < 0.0 || renderHeight < 0.0) {
                renderWidth = this.dst.field_147621_c;
                renderHeight = this.dst.field_147618_d;
            }
            this.effect.render(this.src, this.dst, this.blitFBO, this.prevFBO, renderWidth, renderHeight, this.restore);
        }
    }
}

