/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader.base;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JsonException;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.shader.base.CShaderGroup;
import thebetweenlands.client.render.shader.base.CShaderInt;
import thebetweenlands.client.render.shader.base.ResourceManagerWrapper;

public class WorldShader {
    private ShaderGroup shaderGroup = null;
    private final ResourceLocation shaderDescription;
    private final ResourceLocation shaderPath;
    private final ResourceLocation assetsPath;
    private final IResourceManager resourceManager;
    private final Framebuffer frameBuffer;
    private final TextureManager textureManager;
    private final HashMap<String, Object> samplers = new HashMap();
    private final HashMap<String, CShaderInt> shaderMap = new HashMap();

    public WorldShader(TextureManager textureManager, IResourceManager resourceManager, Framebuffer frameBuffer, ResourceLocation shaderDescription, ResourceLocation shaderPath, ResourceLocation assetsPath) {
        this.shaderDescription = shaderDescription;
        this.shaderPath = shaderPath;
        this.frameBuffer = frameBuffer;
        this.resourceManager = resourceManager;
        this.textureManager = textureManager;
        this.assetsPath = assetsPath;
    }

    public final ResourceLocation getShaderDescription() {
        return this.shaderDescription;
    }

    public final ResourceLocation getShaderPath() {
        return this.shaderPath;
    }

    public final ResourceLocation getAssetsPath() {
        return this.assetsPath;
    }

    public final HashMap<String, Object> getSamplers() {
        return this.samplers;
    }

    protected final void addShader(CShaderInt shader) {
        this.shaderMap.put(shader.getName(), shader);
    }

    public final ShaderGroup getShaderGroup() {
        return this.shaderGroup;
    }

    public final ShaderGroup createShaderGroup() throws JsonException {
        if (this.shaderGroup == null) {
            this.shaderGroup = new CShaderGroup(this.textureManager, new ResourceManagerWrapper(this.resourceManager, this), this.frameBuffer, this.shaderDescription, this);
        }
        return this.shaderGroup;
    }

    public final WorldShader updateSampler(String name, Framebuffer frameBuffer) {
        this.samplers.put(name, frameBuffer);
        return this;
    }

    public final WorldShader updateSampler(String name, ITextureObject texture) {
        this.samplers.put(name, texture);
        return this;
    }

    public final WorldShader updateSampler(String name, int texture) {
        this.samplers.put(name, texture);
        return this;
    }

    public final Map<CShaderInt, ShaderUniform> getShaderUniforms(String name) {
        HashMap<CShaderInt, ShaderUniform> uniformMap = new HashMap<CShaderInt, ShaderUniform>();
        for (Map.Entry<String, CShaderInt> shaderEntry : this.shaderMap.entrySet()) {
            uniformMap.put(shaderEntry.getValue(), shaderEntry.getValue().getUniform(name));
        }
        return uniformMap;
    }

    public final ShaderUniform getShaderUniform(String shaderName, String uniformName) {
        CShaderInt shader = this.shaderMap.get(shaderName);
        if (shader != null) {
            return shader.getUniform(uniformName);
        }
        return null;
    }

    public void updateShader(CShaderInt shader) {
    }

    public void postShader(CShaderGroup shaderGroup, float partialTicks) {
    }
}

