/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.util.JsonException;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.MainShader;
import thebetweenlands.client.render.shader.base.CShaderGroup;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesPortal;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.WorldProviderBetweenlands;

public class ShaderHelper
implements IResourceManagerReloadListener {
    public static final ShaderHelper INSTANCE = new ShaderHelper();
    private MainShader currentShader;
    private boolean failedLoading = false;
    private ShaderGroup currentShaderGroup;
    private boolean checked = false;
    private boolean shadersSupported = false;
    private boolean needsReload = false;

    public boolean isWorldShaderActive() {
        return this.canUseShaders() && this.currentShader != null && Minecraft.func_71410_x().field_71460_t.field_147707_d != null && Minecraft.func_71410_x().field_71460_t.field_147707_d == this.currentShader.getShaderGroup();
    }

    public boolean canUseShaders() {
        return OpenGlHelper.func_148822_b() && this.isShaderSupported() && ConfigHandler.USE_SHADER;
    }

    public boolean isShaderSupported() {
        if (!this.checked) {
            this.checked = true;
            ContextCapabilities contextCapabilities = GLContext.getCapabilities();
            boolean supportsGL21 = contextCapabilities.OpenGL21;
            boolean supported = supportsGL21 || contextCapabilities.GL_ARB_vertex_shader && contextCapabilities.GL_ARB_fragment_shader && contextCapabilities.GL_ARB_shader_objects;
            this.shadersSupported = OpenGlHelper.func_153193_b() && supported && OpenGlHelper.field_148823_f;
        }
        return this.shadersSupported;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enableWorldShader() {
        if (!this.failedLoading && !this.isShaderSupported() && ConfigHandler.USE_SHADER) {
            this.failedLoading = true;
            System.err.println("Your system does not support shaders. Please disable shaders in the betweenlands config file.");
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147110_a() == null || mc.func_110442_L() == null || mc.func_110434_K() == null) return;
        if (this.isRequired()) {
            if (this.currentShader != null && mc.field_71460_t.field_147707_d != null && mc.field_71460_t.field_147707_d == this.currentShaderGroup && !this.needsShaderReload()) return;
            MainShader shaderWrapper = this.currentShader;
            if (shaderWrapper != null) {
                shaderWrapper.delete();
            }
            shaderWrapper = new MainShader(mc.func_110434_K(), mc.func_110442_L(), mc.func_147110_a(), new ResourceLocation("thebetweenlands:shaders/mc/config/blmain.json"), new ResourceLocation("thebetweenlands:shaders/mc/program/"), new ResourceLocation("thebetweenlands:textures/shader/"));
            try {
                if (ShaderLinkHelper.func_148074_b() == null) {
                    ShaderLinkHelper.func_148076_a();
                }
                this.currentShaderGroup = mc.field_71460_t.field_147707_d = shaderWrapper.createShaderGroup();
                this.currentShader = shaderWrapper;
                mc.field_71460_t.field_147707_d.func_148026_a(mc.field_71443_c, mc.field_71440_d);
                if (!this.needsShaderReload()) return;
                this.needsReload = false;
                return;
            }
            catch (JsonException e) {
                this.failedLoading = true;
                throw new RuntimeException("Failed loading shader files!", e);
            }
        } else {
            if (!(mc.field_71460_t.field_147707_d instanceof CShaderGroup)) return;
            mc.field_71460_t.field_147707_d = null;
        }
    }

    private boolean isRequired() {
        Minecraft mc = Minecraft.func_71410_x();
        boolean inPortal = false;
        if (mc.field_71439_g != null) {
            EntityPropertiesPortal props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)mc.field_71439_g, EntityPropertiesPortal.class);
            inPortal = props.inPortal;
        }
        return inPortal || mc.field_71441_e != null && mc.field_71441_e.field_73011_w instanceof WorldProviderBetweenlands && mc.field_71439_g.field_71093_bK == ConfigHandler.DIMENSION_ID;
    }

    private boolean needsShaderReload() {
        return this.needsReload;
    }

    public void scheduleShaderReload() {
        this.needsReload = true;
    }

    public void updateShader() {
        if (!this.isShaderSupported() || this.failedLoading || !ConfigHandler.USE_SHADER) {
            return;
        }
        if (this.currentShader != null) {
            this.currentShader.updateMatrices();
            this.currentShader.updateBuffers(Minecraft.func_71410_x().func_147110_a());
        }
    }

    public void clearDynLights() {
        if (ConfigHandler.USE_SHADER && !this.failedLoading && this.isShaderSupported() && this.currentShader != null) {
            this.currentShader.clearLights();
        }
    }

    public void addDynLight(LightSource light) {
        if (ConfigHandler.USE_SHADER && !this.failedLoading && this.isShaderSupported() && this.currentShader != null) {
            this.currentShader.addLight(light);
        }
    }

    public MainShader getCurrentShader() {
        return this.currentShader;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.scheduleShaderReload();
    }
}

