/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import thebetweenlands.client.render.shader.GeometryBuffer;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.base.CShaderGroup;
import thebetweenlands.client.render.shader.base.CShaderInt;
import thebetweenlands.client.render.shader.base.WorldShader;
import thebetweenlands.client.render.shader.effect.GodRayEffect;
import thebetweenlands.client.render.shader.effect.OcclusionExtractor;
import thebetweenlands.client.render.shader.effect.StarfieldEffect;
import thebetweenlands.client.render.shader.effect.SwirlEffect;
import thebetweenlands.client.render.shader.effect.WarpEffect;
import thebetweenlands.client.render.sky.BLSkyRenderer;
import thebetweenlands.entities.mobs.EntityGasCloud;
import thebetweenlands.utils.GLUProjection;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.WorldProviderBetweenlands;

public class MainShader
extends WorldShader {
    private Framebuffer depthBuffer;
    private List<LightSource> lightSources = new ArrayList<LightSource>();
    private javax.vecmath.Matrix4f INVMVP;
    private javax.vecmath.Matrix4f MVP;
    private javax.vecmath.Matrix4f MV;
    private javax.vecmath.Matrix4f PM;
    private FloatBuffer mvBuffer = GLAllocation.func_74529_h((int)16);
    private FloatBuffer pmBuffer = GLAllocation.func_74529_h((int)16);
    private Map<String, GeometryBuffer> geometryBuffers = new HashMap<String, GeometryBuffer>();
    private Map<String, Framebuffer> blitBuffers = new HashMap<String, Framebuffer>();
    private static final Comparator<LightSource> lightSourceSorter = new Comparator<LightSource>(){

        @Override
        public int compare(LightSource o1, LightSource o2) {
            double d2;
            double dx1 = o1.x - RenderManager.field_78725_b;
            double dy1 = o1.y - RenderManager.field_78726_c;
            double dz1 = o1.z - RenderManager.field_78723_d;
            double dx2 = o2.x - RenderManager.field_78725_b;
            double dy2 = o2.y - RenderManager.field_78726_c;
            double dz2 = o2.z - RenderManager.field_78723_d;
            double d1 = Math.sqrt(dx1 * dx1 + dy1 * dy1 + dz1 * dz1);
            if (d1 > (d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2))) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return 0;
        }
    };
    private SwirlEffect swirlEffect = null;
    private float swirlAngle = 0.0f;
    private float lastSwirlAngle = 0.0f;
    private OcclusionExtractor occlusionExtractor = null;
    private GodRayEffect godRayEffect = null;
    private Framebuffer gasTextureBaseFBO = null;
    private Framebuffer gasTextureFBO = null;
    private WarpEffect gasWarpEffect = null;
    private Framebuffer starfieldTextureFBO = null;
    private StarfieldEffect starfieldEffect = null;

    public MainShader(TextureManager textureManager, IResourceManager resourceManager, Framebuffer frameBuffer, ResourceLocation shaderDescription, ResourceLocation shaderPath, ResourceLocation assetsPath) {
        super(textureManager, resourceManager, frameBuffer, shaderDescription, shaderPath, assetsPath);
    }

    public GeometryBuffer getGeometryBuffer(String samplerName) {
        GeometryBuffer geomBuffer = this.geometryBuffers.get(samplerName);
        if (geomBuffer == null) {
            geomBuffer = new GeometryBuffer(true);
            this.geometryBuffers.put(samplerName, geomBuffer);
        }
        return geomBuffer;
    }

    public Framebuffer getBlitBuffer(String name) {
        Framebuffer fbo = this.blitBuffers.get(name);
        if (fbo == null) {
            fbo = new Framebuffer(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, true);
            this.blitBuffers.put(name, fbo);
        }
        return fbo;
    }

    public void addLight(LightSource light) {
        this.lightSources.add(light);
    }

    public void clearLights() {
        this.lightSources.clear();
    }

    public Framebuffer getDepthBuffer() {
        if (this.depthBuffer == null) {
            this.depthBuffer = new Framebuffer(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, false);
        }
        return this.depthBuffer;
    }

    public void delete() {
        if (this.getShaderGroup() != null) {
            this.getShaderGroup().func_148021_a();
        }
        this.deleteBuffers();
    }

    private void deleteBuffers() {
        this.depthBuffer.func_147608_a();
        for (GeometryBuffer gBuffer : this.geometryBuffers.values()) {
            gBuffer.deleteBuffers();
        }
        this.geometryBuffers.clear();
        for (Framebuffer fbo : this.blitBuffers.values()) {
            fbo.func_147608_a();
        }
        this.blitBuffers.clear();
    }

    public void updateBuffers(Framebuffer input) {
        if (this.depthBuffer == null) {
            this.depthBuffer = new Framebuffer(input.field_147621_c, input.field_147618_d, false);
            this.updateSampler("diffuse_depth", this.depthBuffer);
        }
        if (input.field_147621_c != this.depthBuffer.field_147621_c || input.field_147618_d != this.depthBuffer.field_147618_d) {
            this.depthBuffer.func_147608_a();
            this.depthBuffer = new Framebuffer(input.field_147621_c, input.field_147618_d, false);
            this.updateSampler("diffuse_depth", this.depthBuffer);
        }
        input.func_147610_a(false);
        GL11.glBindTexture((int)3553, (int)this.depthBuffer.field_147617_g);
        GL11.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)this.depthBuffer.field_147622_a, (int)this.depthBuffer.field_147620_b, (int)0);
        for (Map.Entry<String, GeometryBuffer> entry : this.geometryBuffers.entrySet()) {
            entry.getValue().updateBuffers(input);
            if (entry.getValue().hasDepthBuffer()) {
                entry.getValue().updateDepth();
            }
            String samplerName = entry.getKey();
            int geomBuffer = entry.getValue().getDiffuseTexture();
            int geomDepthBuffer = entry.getValue().getDepthTexture();
            this.updateSampler(samplerName, geomBuffer);
            if (geomDepthBuffer < 0) continue;
            this.updateSampler(samplerName + "_depth", geomDepthBuffer);
        }
        for (Map.Entry<String, GeometryBuffer> entry : this.blitBuffers.entrySet()) {
            Framebuffer fbo = (Framebuffer)entry.getValue();
            if (input.field_147621_c == fbo.field_147621_c && input.field_147618_d == fbo.field_147618_d) continue;
            fbo.func_147608_a();
            fbo = new Framebuffer(input.field_147621_c, input.field_147618_d, true);
            this.blitBuffers.put(entry.getKey(), fbo);
        }
        input.func_147610_a(false);
    }

    @Override
    public void updateShader(CShaderInt shader) {
        this.uploadMatrices(shader);
        this.uploadLights(shader);
        this.uploadMisc(shader);
    }

    private void uploadMisc(CShaderInt shader) {
        ShaderUniform uniform = shader.getUniform("u_zNear");
        if (uniform != null) {
            uniform.func_148090_a(0.05f);
        }
        if ((uniform = shader.getUniform("u_zFar")) != null) {
            uniform.func_148090_a((float)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16) * 2.0f);
        }
        if ((uniform = shader.getUniform("u_camPos")) != null) {
            uniform.func_148095_a((float)RenderManager.field_78725_b, (float)RenderManager.field_78726_c, (float)RenderManager.field_78723_d);
        }
        if ((uniform = shader.getUniform("u_msTime")) != null) {
            uniform.func_148090_a((float)System.nanoTime() / 1000000.0f);
        }
    }

    private void uploadMatrices(CShaderInt shader) {
        ShaderUniform uniform = shader.getUniform("u_INVMVP");
        if (uniform != null) {
            uniform.func_148088_a(this.INVMVP);
        }
        if ((uniform = shader.getUniform("u_MVP")) != null) {
            uniform.func_148088_a(this.MVP);
        }
        if ((uniform = shader.getUniform("u_MV")) != null) {
            uniform.func_148088_a(this.MV);
        }
        if ((uniform = shader.getUniform("u_PM")) != null) {
            uniform.func_148088_a(this.PM);
        }
    }

    private void uploadLights(CShaderInt shader) {
        int i;
        float[] posArray;
        Collections.sort(this.lightSources, lightSourceSorter);
        ShaderUniform uniform = shader.getUniform("u_lightColorsR");
        if (uniform != null) {
            posArray = new float[32];
            for (i = 0; i < this.lightSources.size() && i < 32; ++i) {
                posArray[i] = this.lightSources.get((int)i).r;
            }
            uniform.func_148097_a(posArray);
        }
        if ((uniform = shader.getUniform("u_lightColorsG")) != null) {
            posArray = new float[32];
            for (i = 0; i < this.lightSources.size() && i < 32; ++i) {
                posArray[i] = this.lightSources.get((int)i).g;
            }
            uniform.func_148097_a(posArray);
        }
        if ((uniform = shader.getUniform("u_lightColorsB")) != null) {
            posArray = new float[32];
            for (i = 0; i < this.lightSources.size() && i < 32; ++i) {
                posArray[i] = this.lightSources.get((int)i).b;
            }
            uniform.func_148097_a(posArray);
        }
        if ((uniform = shader.getUniform("u_lightSourcesX")) != null) {
            posArray = new float[32];
            for (i = 0; i < this.lightSources.size() && i < 32; ++i) {
                posArray[i] = (float)(-RenderManager.field_78725_b + this.lightSources.get((int)i).x);
            }
            uniform.func_148097_a(posArray);
        }
        if ((uniform = shader.getUniform("u_lightSourcesY")) != null) {
            posArray = new float[32];
            for (i = 0; i < this.lightSources.size() && i < 32; ++i) {
                posArray[i] = (float)(-RenderManager.field_78726_c + this.lightSources.get((int)i).y);
            }
            uniform.func_148097_a(posArray);
        }
        if ((uniform = shader.getUniform("u_lightSourcesZ")) != null) {
            posArray = new float[32];
            for (i = 0; i < this.lightSources.size() && i < 32; ++i) {
                posArray[i] = (float)(-RenderManager.field_78723_d + this.lightSources.get((int)i).z);
            }
            uniform.func_148097_a(posArray);
        }
        if ((uniform = shader.getUniform("u_lightRadii")) != null) {
            posArray = new float[32];
            for (i = 0; i < this.lightSources.size() && i < 32; ++i) {
                posArray[i] = this.lightSources.get((int)i).radius;
            }
            uniform.func_148097_a(posArray);
        }
        if ((uniform = shader.getUniform("u_lightSources")) != null) {
            int count = this.lightSources.size();
            if (count > 32) {
                count = 32;
            }
            uniform.func_148090_a((float)count);
        }
    }

    public void updateMatrices() {
        GL11.glGetFloat((int)2982, (FloatBuffer)this.mvBuffer);
        GL11.glGetFloat((int)2983, (FloatBuffer)this.pmBuffer);
        Matrix4f modelviewMatrix = (Matrix4f)new Matrix4f().load(this.mvBuffer.asReadOnlyBuffer());
        Matrix4f invModelviewMatrix = (Matrix4f)new Matrix4f().load(this.mvBuffer.asReadOnlyBuffer()).invert();
        this.MV = this.toVecMathMatrix(modelviewMatrix);
        Matrix4f projectionMatrix = (Matrix4f)new Matrix4f().load(this.pmBuffer.asReadOnlyBuffer());
        this.PM = this.toVecMathMatrix(projectionMatrix);
        Matrix4f MVP = new Matrix4f();
        Matrix4f.mul((Matrix4f)projectionMatrix, (Matrix4f)modelviewMatrix, (Matrix4f)MVP);
        this.MVP = this.toVecMathMatrix(MVP);
        this.INVMVP = this.toVecMathMatrix((Matrix4f)MVP.invert());
    }

    private javax.vecmath.Matrix4f toVecMathMatrix(Matrix4f mat) {
        javax.vecmath.Matrix4f vecMath = new javax.vecmath.Matrix4f();
        vecMath.m00 = mat.m00;
        vecMath.m01 = mat.m01;
        vecMath.m02 = mat.m02;
        vecMath.m03 = mat.m03;
        vecMath.m10 = mat.m10;
        vecMath.m11 = mat.m11;
        vecMath.m12 = mat.m12;
        vecMath.m13 = mat.m13;
        vecMath.m20 = mat.m20;
        vecMath.m21 = mat.m21;
        vecMath.m22 = mat.m22;
        vecMath.m23 = mat.m23;
        vecMath.m30 = mat.m30;
        vecMath.m31 = mat.m31;
        vecMath.m32 = mat.m32;
        vecMath.m33 = mat.m33;
        return vecMath;
    }

    public void setSwirlAngle(float swirlAngle) {
        this.swirlAngle = swirlAngle;
        this.lastSwirlAngle = swirlAngle;
    }

    public float getSwirlAngle() {
        return this.swirlAngle;
    }

    @Override
    public void postShader(CShaderGroup shaderGroup, float partialTicks) {
        if (!ShaderHelper.INSTANCE.canUseShaders()) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledResolution.func_78326_a(), (double)scaledResolution.func_78328_b(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        this.applyBloodSky(partialTicks);
        this.applySwirl(partialTicks);
        this.updateTextures(partialTicks);
    }

    private void applyBloodSky(float partialTicks) {
        float skyTransparency = 0.0f;
        boolean hasBeat = false;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
            if ((skyTransparency += provider.getWorldData().getEnvironmentEventRegistry().BLOODSKY.getSkyTransparency(partialTicks)) > 0.01f) {
                hasBeat = true;
            }
            skyTransparency += provider.getWorldData().getEnvironmentEventRegistry().SPOOPY.getSkyTransparency(partialTicks);
        }
        if (skyTransparency <= 0.01f) {
            return;
        }
        if (skyTransparency > 1.0f) {
            skyTransparency = 1.0f;
        }
        if (this.occlusionExtractor == null) {
            this.occlusionExtractor = (OcclusionExtractor)new OcclusionExtractor().init();
        }
        if (this.godRayEffect == null) {
            this.godRayEffect = (GodRayEffect)new GodRayEffect().init();
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        double renderWidth = scaledResolution.func_78326_a();
        double renderHeight = scaledResolution.func_78328_b();
        float rayX = 0.5f;
        float rayY = 1.0f;
        Vec3 lightPos = Vec3.func_72443_a((double)45.0, (double)30.0, (double)30.0);
        GLUProjection.Projection p = GLUProjection.getInstance().project(lightPos.field_72450_a, lightPos.field_72448_b, lightPos.field_72449_c, GLUProjection.ClampMode.NONE, false);
        rayX = (float)(p.getX() / renderWidth);
        rayY = 1.0f - (float)(p.getY() / renderHeight);
        Vec3 lookVec = Minecraft.func_71410_x().field_71439_g.func_70676_i(partialTicks);
        lookVec.field_72448_b = 0.0;
        lookVec = lookVec.func_72432_b();
        Vec3 sLightPos = Vec3.func_72443_a((double)lightPos.field_72450_a, (double)0.0, (double)lightPos.field_72449_c).func_72432_b();
        float lightXZAngle = (float)Math.toDegrees(Math.acos(sLightPos.func_72430_b(lookVec)));
        float fovX = GLUProjection.getInstance().getFovX() / 2.0f;
        float angDiff = Math.abs(lightXZAngle);
        float decay = 0.96f;
        float illuminationDecay = 0.44f;
        float weight = 0.12f;
        if (angDiff > fovX) {
            float mult = (angDiff - fovX) / 400.0f;
            decay *= 1.0f - mult;
            illuminationDecay *= 1.0f - mult;
            weight *= 1.0f - mult;
        }
        Framebuffer worldDepthBuffer = this.getDepthBuffer();
        int clipPlaneBuffer = BLSkyRenderer.INSTANCE.clipPlaneBuffer.getDepthTexture();
        if (worldDepthBuffer == null || clipPlaneBuffer < 0) {
            return;
        }
        this.occlusionExtractor.setDepthTextures(worldDepthBuffer.field_147617_g, clipPlaneBuffer);
        this.occlusionExtractor.create(this.getBlitBuffer("bloodSkyBlitBuffer1")).setSource(Minecraft.func_71410_x().func_147110_a().field_147617_g).setPreviousFBO(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d).render();
        float beat = 0.0f;
        if (hasBeat) {
            beat = Math.abs((float)Math.sin((double)System.nanoTime() / 1.0E8) / 3.0f / (Math.abs((float)Math.sin((double)System.nanoTime() / 4.0E9) * (float)Math.sin((double)System.nanoTime() / 4.0E9) * (float)Math.sin((double)System.nanoTime() / 4.0E9 + (double)0.05f) * 120.0f) * 180.0f + 15.5f) * 30.0f);
        }
        float density = 0.1f + beat;
        this.godRayEffect.setOcclusionMap(this.getBlitBuffer("bloodSkyBlitBuffer1")).setParams(0.8f, decay, density * 4.0f, weight, illuminationDecay).setRayPos(rayX, rayY);
        this.godRayEffect.create(this.getBlitBuffer("bloodSkyBlitBuffer0")).setSource(this.getBlitBuffer((String)"bloodSkyBlitBuffer1").field_147617_g).setPreviousFBO(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d).render();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        this.getBlitBuffer("bloodSkyBlitBuffer2").func_147610_a(false);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)Minecraft.func_71410_x().func_147110_a().field_147617_g);
        GL11.glBegin((int)4);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)renderWidth, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glEnd();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)0.8f, (float)0.2f, (float)skyTransparency);
        GL11.glBindTexture((int)3553, (int)this.getBlitBuffer((String)"bloodSkyBlitBuffer2").field_147617_g);
        GL11.glBegin((int)4);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)renderWidth, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)0.7f, (float)0.1f, (float)0.0f, (float)(skyTransparency / 2.5f));
        GL11.glBindTexture((int)3553, (int)this.getBlitBuffer((String)"bloodSkyBlitBuffer0").field_147617_g);
        GL11.glBegin((int)4);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)renderWidth, (double)renderHeight);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)renderWidth, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glEnd();
    }

    private void applySwirl(float partialTicks) {
        if (this.swirlEffect == null) {
            this.swirlEffect = (SwirlEffect)new SwirlEffect().init();
        }
        this.swirlAngle += (this.swirlAngle - this.lastSwirlAngle) * partialTicks;
        this.lastSwirlAngle = this.swirlAngle;
        if (this.swirlAngle != 0.0f) {
            this.swirlEffect.setAngle(this.swirlAngle);
            this.swirlEffect.create(this.getBlitBuffer("swirlBlitBuffer")).setSource(Minecraft.func_71410_x().func_147110_a().field_147617_g).setPreviousFBO(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d).render();
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            GL11.glPushMatrix();
            double renderWidth = scaledResolution.func_78326_a();
            double renderHeight = scaledResolution.func_78328_b();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glBindTexture((int)3553, (int)this.getBlitBuffer((String)"swirlBlitBuffer").field_147617_g);
            GL11.glBegin((int)4);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)0.0, (double)renderHeight);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)renderWidth, (double)renderHeight);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)renderWidth, (double)renderHeight);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex2d((double)renderWidth, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }

    public int getGasTextureID() {
        return this.gasTextureFBO != null ? this.gasTextureFBO.field_147617_g : -1;
    }

    public int getStarfieldTextureID() {
        return this.starfieldTextureFBO != null ? this.starfieldTextureFBO.field_147617_g : -1;
    }

    private void updateTextures(float partialTicks) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            boolean hasCloud = false;
            for (Entity e : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
                if (!(e instanceof EntityGasCloud)) continue;
                hasCloud = true;
                break;
            }
            if (hasCloud) {
                if (this.gasTextureFBO == null) {
                    this.gasTextureFBO = new Framebuffer(64, 64, false);
                    this.gasTextureBaseFBO = new Framebuffer(64, 64, false);
                    this.gasWarpEffect = new WarpEffect().setTimeScale(4.0E-5f).setScale(40.0f).setMultiplier(3.55f);
                    this.gasWarpEffect.init();
                }
                float worldTimeInterp = (float)world.func_72820_D() + partialTicks;
                float offsetX = ((float)Math.sin((double)(worldTimeInterp / 20.0f) % (Math.PI * 2)) + 1.0f) / 800.0f;
                float offsetY = ((float)Math.cos((double)(worldTimeInterp / 20.0f) % (Math.PI * 2)) + 1.0f) / 800.0f;
                this.gasWarpEffect.setOffset(offsetX, offsetY).setWarpDir(0.75f, 0.75f);
                this.gasTextureFBO.func_147610_a(false);
                GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glClear((int)16384);
                this.gasTextureBaseFBO.func_147610_a(false);
                GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glClear((int)16384);
                this.gasWarpEffect.create(this.gasTextureFBO).setSource(this.gasTextureBaseFBO.field_147617_g).setPreviousFBO(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(1280.0, 1280.0).render();
            }
        }
        if (this.starfieldTextureFBO == null) {
            this.starfieldTextureFBO = new Framebuffer(ConfigHandler.SKY_RESOLUTION, ConfigHandler.SKY_RESOLUTION, false);
            this.starfieldEffect = (StarfieldEffect)new StarfieldEffect(true).init();
        }
        float offX = (float)(RenderManager.field_78725_b / 8000.0);
        float offY = (float)(-RenderManager.field_78723_d / 8000.0);
        float offZ = (float)(-RenderManager.field_78726_c / 10000.0);
        this.starfieldEffect.setTimeScale(2.5E-7f).setZoom(0.8f).setOffset(offX, offY, offZ);
        this.starfieldEffect.create(this.starfieldTextureFBO).setPreviousFBO(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(ConfigHandler.SKY_RESOLUTION, ConfigHandler.SKY_RESOLUTION).render();
    }
}

