/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.model.item.ModelVolarkite;
import thebetweenlands.entities.EntityVolarkite;

@SideOnly(value=Side.CLIENT)
public class ItemVolarKiteRenderer
implements IItemRenderer {
    private final ModelVolarkite model = new ModelVolarkite();
    private final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/items/volarkite.png");

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityLivingBase entity = (EntityLivingBase)data[1];
        if (EntityVolarkite.isEntityHoldingGlider((Entity)entity)) {
            return;
        }
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.TEXTURE);
        switch (type) {
            case ENTITY: {
                this.renderBlock(0.0f, 2.0f, 0.0f, 0.125);
                break;
            }
            case EQUIPPED: {
                this.renderHeld(0.5f, 0.0f, 0.0f, 0.75);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderHeld(0.5f, 0.25f, 0.5f, 0.5);
                break;
            }
            case INVENTORY: {
                this.renderBlock(0.0f, 1.75f, 0.0f, 0.4);
                break;
            }
        }
    }

    private void renderBlock(float x, float y, float z, double size) {
        if (RenderItem.field_82407_g) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)(y - 1.825f), (float)z);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScaled((double)(size + (double)0.2f), (double)(size + (double)0.2f), (double)(size + (double)0.2f));
            this.model.render();
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)(y - 1.825f), (float)z);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScaled((double)size, (double)size, (double)size);
            this.model.render();
            GL11.glPopMatrix();
        }
    }

    private void renderHeld(float x, float y, float z, double size) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.model.render();
        GL11.glPopMatrix();
    }
}

