/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.model.entity.ModelTarminion;
import thebetweenlands.entities.projectiles.EntityThrownTarminion;

@SideOnly(value=Side.CLIENT)
public class ItemTarminionRenderer
extends Render
implements IItemRenderer {
    private final ModelTarminion model;
    public final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/entity/tarminion.png");
    public final ResourceLocation textureDrip = new ResourceLocation("thebetweenlands:textures/entity/tarminionOverlay.png");

    public ItemTarminionRenderer() {
        this.model = new ModelTarminion();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        float ticks = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.texture);
        switch (type) {
            case ENTITY: {
                this.render(0.0f, 2.5f, 0.0f, 1.5, ticks);
                break;
            }
            case EQUIPPED: {
                this.renderEquipped(0.3f, 5.0f, 1.0f, 3.0, ticks);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderFirstPerson(0.0f, 4.75f, -1.0f, 3.0, ticks);
                break;
            }
            case INVENTORY: {
                this.renderInventory(0.1f, 4.625f, 0.0f, 3.0);
                break;
            }
        }
    }

    private void renderEquipped(float x, float y, float z, double size, float ticks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glScaled((double)(-size), (double)(-size), (double)size);
        this.model.render();
        this.renderDrips(ticks);
        GL11.glPopMatrix();
    }

    private void render(float x, float y, float z, double size, float ticks) {
        if (RenderItem.field_82407_g) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)(y + 0.28f), (float)z);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            this.model.render();
            this.renderDrips(ticks);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScaled((double)size, (double)size, (double)size);
            this.model.render();
            this.renderDrips(ticks);
            GL11.glPopMatrix();
        }
    }

    private void renderFirstPerson(float x, float y, float z, double size, float ticks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)160.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)65.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.model.render();
        this.renderDrips(ticks);
        GL11.glPopMatrix();
    }

    private void renderInventory(float x, float y, float z, double size) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.model.render();
        GL11.glPopMatrix();
    }

    public void renderDrips(float ticks) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.textureDrip);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        float yScroll = ticks * 0.004f;
        GL11.glTranslatef((float)0.0f, (float)(-yScroll), (float)0.0f);
        GL11.glMatrixMode((int)5888);
        float colour = 0.5f;
        GL11.glColor4f((float)colour, (float)colour, (float)colour, (float)1.0f);
        GL11.glDisable((int)2896);
        this.model.render();
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glEnable((int)2896);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float rotationYaw, float partialTickTime) {
        this.renderTarminion((EntityThrownTarminion)entity, x, y, z, rotationYaw, partialTickTime);
    }

    public void renderTarminion(EntityThrownTarminion tarminion, double x, double y, double z, float rotationYaw, float partialTickTime) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.texture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.5f), (float)((float)z));
        GL11.glRotatef((float)(tarminion.field_70126_B + (tarminion.field_70177_z - tarminion.field_70126_B) * partialTickTime - EntityThrownTarminion.rotationticks), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScaled((double)1.0, (double)-1.0, (double)1.0);
        this.model.render();
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.texture;
    }
}

