/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import java.util.EnumMap;
import javax.vecmath.Point3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.model.entity.ModelWeedwoodRowboat;
import thebetweenlands.client.render.entity.RenderPlayerRower;
import thebetweenlands.entities.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.entities.rowboat.ShipSide;
import thebetweenlands.utils.CubicBezier;
import thebetweenlands.utils.MathUtils;
import thebetweenlands.utils.Matrix;

public class RenderWeedwoodRowboat
extends Render {
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/weedwoodRowboat.png");
    private static final CubicBezier PULL_CURVE = new CubicBezier(1.0f, 0.0f, 1.0f, 0.25f);
    public static boolean shouldPreventRidingRender = true;
    private RenderPlayerRower rowerRenderer = new RenderPlayerRower();
    private ModelWeedwoodRowboat model = new ModelWeedwoodRowboat();
    private int maskId = -1;
    private Matrix matrix = new Matrix(16);
    private EnumMap<ShipSide, Point3f> grips = ShipSide.newEnumMap(Point3f.class, new Point3f(), new Point3f());
    private EnumMap<ShipSide, ArmArticulation> arms = ShipSide.newEnumMap(ArmArticulation.class, new ArmArticulation(), new ArmArticulation());
    private Point3f arm = new Point3f();
    private float bodyRotateAngleX;
    private float bodyRotateAngleY;

    public void func_76986_a(Entity entity, double x, double y, double z, float yawn, float delta) {
        boolean lines = false;
        EntityWeedwoodRowboat rowboat = (EntityWeedwoodRowboat)entity;
        this.model.animateOar(rowboat, ShipSide.STARBOARD, delta);
        this.model.animateOar(rowboat, ShipSide.PORT, delta);
        float yaw = 270.0f - yawn;
        GL11.glPushMatrix();
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        this.roll(rowboat, delta);
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderPilot(rowboat, x, y, z, yaw, delta);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)(y + (double)1.05f), (double)z);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        this.roll(rowboat, delta);
        this.func_110777_b(entity);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.model.render(rowboat, 0.0625f, delta);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.renderWaterMask();
        GL11.glPopMatrix();
    }

    private void roll(EntityWeedwoodRowboat rowboat, float delta) {
        float timeSinceHit = (float)rowboat.getTimeSinceHit() - delta;
        float damageTaken = rowboat.getDamageTaken() - delta;
        if (damageTaken < 0.0f) {
            damageTaken = 0.0f;
        }
        if (timeSinceHit > 0.0f) {
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)timeSinceHit) * timeSinceHit * damageTaken / 10.0f * (float)rowboat.getHitRollDirection()), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void renderPilot(EntityWeedwoodRowboat boat, double x, double y, double z, float yaw, float delta) {
        Entity pilot = boat.field_70153_n;
        if (!(pilot instanceof EntityPlayer)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (pilot != mc.field_71439_g || mc.field_71474_y.field_74320_O != 0) {
            this.calculateGrip(ShipSide.STARBOARD);
            this.calculateGrip(ShipSide.PORT);
            this.articulateBody();
            this.articulateArm(ShipSide.STARBOARD, x, y, z, yaw);
            this.articulateArm(ShipSide.PORT, x, y, z, yaw);
            AbstractClientPlayer player = (AbstractClientPlayer)pilot;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)(y - 0.5 + (double)pilot.field_70129_M), (double)z);
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.26);
            GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            shouldPreventRidingRender = false;
            this.rowerRenderer.renderPilot(pilot, this.arms.get((Object)ShipSide.STARBOARD), this.arms.get((Object)ShipSide.PORT), this.bodyRotateAngleX, this.bodyRotateAngleY, delta);
            shouldPreventRidingRender = true;
            GL11.glPopMatrix();
        }
    }

    private void calculateGrip(ShipSide side) {
        int dir = side == ShipSide.PORT ? 1 : -1;
        float pivotX = 0.5625f * (float)dir;
        float pivotY = -0.625f;
        float pivotZ = -0.4375f;
        this.createOarTransformationMatrix(side);
        Point3f grip = this.grips.get((Object)side);
        grip.set(0.0f, 0.375f, 0.0f);
        this.matrix.transform(grip);
        grip.x += pivotX;
        grip.y += pivotY;
        grip.z += pivotZ;
    }

    private void createOarTransformationMatrix(ShipSide side) {
        ModelRenderer oar = this.model.getOar(side);
        this.matrix.setIdentity();
        this.matrix.rotate(oar.field_78808_h, 0.0, 0.0, 1.0);
        this.matrix.rotate(oar.field_78795_f, -1.0, 0.0, 0.0);
        this.matrix.rotate(oar.field_78796_g, 0.0, -1.0, 0.0);
    }

    private void articulateBody() {
        float leftZ = this.grips.get((Object)((Object)ShipSide.STARBOARD)).z;
        float rightZ = this.grips.get((Object)((Object)ShipSide.PORT)).z;
        float tilt = (float)Math.atan2(leftZ, rightZ) + 2.3561945f;
        this.bodyRotateAngleY = tilt * 0.65f;
        float straightness = 1.0f - Math.abs(tilt) / 0.7853982f;
        if (straightness > 1.0f) {
            straightness = 1.0f;
        }
        if (straightness < 0.0f) {
            straightness = 0.0f;
        }
        float z = (leftZ + rightZ) / 2.0f;
        float y = (this.grips.get((Object)((Object)ShipSide.STARBOARD)).y + this.grips.get((Object)((Object)ShipSide.PORT)).y) / 2.0f;
        float forward = Math.abs(z);
        float downward = (-y - 0.3f) / 0.35f;
        if (downward > 1.0f) {
            downward = 1.0f;
        }
        if (downward < 0.0f) {
            downward = 0.0f;
        }
        float upward = 0.0f;
        if (downward < 0.6f) {
            upward = MathUtils.linearTransformf(downward, 0.0f, 0.6f, 1.0f, 0.0f);
            upward = PULL_CURVE.eval(upward) * 0.6f;
        }
        float lean = (forward + downward * 0.1f) * (1.0f - upward) + upward * 0.2f;
        this.bodyRotateAngleX = MathUtils.linearTransformf(lean, 0.2f, 0.72f, -0.45f, 0.5f);
    }

    private void articulateArm(ShipSide side, double x, double y, double z, float yaw) {
        int dir = side == ShipSide.PORT ? 1 : -1;
        float ps = 0.9375f;
        this.createBodyTransformationMatrix();
        this.matrix.translate(-0.375f * (float)dir, -0.625, 0.0);
        this.arm.set(0.0f, 0.0f, 0.0f);
        this.matrix.transform(this.arm);
        Point3f grip = this.grips.get((Object)side);
        float targetX = grip.x - this.arm.x;
        float targetY = grip.y - this.arm.y;
        float targetZ = grip.z - this.arm.z;
        float horizontalDistSq = targetX * targetX + targetZ * targetZ;
        float targetPitch = (float)Math.atan2(targetY, MathHelper.func_76129_c((float)horizontalDistSq));
        float targetLen = MathHelper.func_76129_c((float)(horizontalDistSq + targetY * targetY));
        float upperArmLen = 0.25f;
        float lowerArmLen = 0.265625f;
        float shoulderAngle = (float)Math.acos((upperArmLen * upperArmLen + targetLen * targetLen - lowerArmLen * lowerArmLen) / (2.0f * upperArmLen * targetLen));
        float flexionAngle = (float)Math.acos((upperArmLen * upperArmLen + lowerArmLen * lowerArmLen - targetLen * targetLen) / (2.0f * upperArmLen * lowerArmLen));
        ArmArticulation armArt = this.arms.get((Object)side);
        armArt.setShoulderAngleX((shoulderAngle != shoulderAngle ? -1.5707964f - targetPitch : shoulderAngle - 1.5707964f - targetPitch) - this.bodyRotateAngleX);
        armArt.setShoulderAngleY((float)Math.atan2(targetZ, targetX) + 1.5707964f - this.bodyRotateAngleY);
        armArt.setFlexionAngle(shoulderAngle != shoulderAngle ? 0.0f : (flexionAngle - (float)Math.PI) * 57.29578f);
        if (shoulderAngle != shoulderAngle) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        } else if ((flexionAngle - (float)Math.PI) * 57.29578f < -90.0f) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void createBodyTransformationMatrix() {
        this.matrix.setIdentity();
        this.matrix.translate(0.0, -1.62, 0.0);
        this.matrix.scale(-1.0, -1.0, 1.0);
        this.matrix.scale(0.9375, 0.9375, 0.9375);
        this.matrix.translate(0.0, -1.5078125, 0.0);
        this.matrix.translate(0.0, 0.75, 0.0);
        this.matrix.rotate(this.bodyRotateAngleY, 0.0, 1.0, 0.0);
        this.matrix.rotate(this.bodyRotateAngleX, 1.0, 0.0, 0.0);
    }

    private void renderWaterMask() {
        if (this.maskId == -1) {
            this.maskId = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.maskId, (int)4865);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            double y = -0.687;
            double midWidth = 0.55;
            double midDepth = 0.65;
            double endWidth = 0.4;
            double endDepth = 0.16;
            double endOffset = 0.81;
            tessellator.func_78377_a(-midWidth, y, midDepth);
            tessellator.func_78377_a(midWidth, y, midDepth);
            tessellator.func_78377_a(midWidth, y, -midDepth);
            tessellator.func_78377_a(-midWidth, y, -midDepth);
            tessellator.func_78377_a(-endWidth, y, endDepth - endOffset);
            tessellator.func_78377_a(endWidth, y, endDepth - endOffset);
            tessellator.func_78377_a(endWidth, y, -endDepth - endOffset);
            tessellator.func_78377_a(-endWidth, y, -endDepth - endOffset);
            tessellator.func_78377_a(-endWidth, y, endDepth + endOffset);
            tessellator.func_78377_a(endWidth, y, endDepth + endOffset);
            tessellator.func_78377_a(endWidth, y, -endDepth + endOffset);
            tessellator.func_78377_a(-endWidth, y, -endDepth + endOffset);
            GL11.glDisable((int)3553);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            tessellator.func_78381_a();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)3553);
            GL11.glEndList();
        } else {
            GL11.glCallList((int)this.maskId);
        }
    }

    public void func_76976_a(RenderManager renderManager) {
        super.func_76976_a(renderManager);
        this.rowerRenderer.func_76976_a(renderManager);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE;
    }

    public static class ArmArticulation {
        private float shoulderAngleX;
        private float shoulderAngleY;
        private float flexionAngle;

        public void setShoulderAngleX(float shoulderAngleX) {
            this.shoulderAngleX = shoulderAngleX;
        }

        public float getShoulderAngleX() {
            return this.shoulderAngleX;
        }

        public void setShoulderAngleY(float shoulderAngleY) {
            this.shoulderAngleY = shoulderAngleY;
        }

        public float getShoulderAngleY() {
            return this.shoulderAngleY;
        }

        public void setFlexionAngle(float flexionAngle) {
            this.flexionAngle = flexionAngle;
        }

        public float getFlexionAngle() {
            return this.flexionAngle;
        }
    }
}

