/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.block.water;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.roots.RootData;
import thebetweenlands.blocks.stalactite.StalactiteHelper;
import thebetweenlands.client.render.block.water.IWaterRenderer;

public class WaterRootRenderer
implements IWaterRenderer {
    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)2896);
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            tessellator.func_78380_c(mc.field_71441_e.func_72802_i((int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70163_u, (int)mc.field_71439_g.field_70161_v, 0));
        }
        tessellator.func_78382_b();
        WaterRootRenderer.renderBlock(block, 0, 0, 0, true, 1, true, 0, mc.field_71441_e.func_72802_i((int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70163_u, (int)mc.field_71439_g.field_70161_v, 0));
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        WaterRootRenderer.renderBlock(block, x, y, z, world);
        return true;
    }

    public static boolean renderBlock(Block block, int x, int y, int z, IBlockAccess blockAccess) {
        RootData info = RootData.getData(blockAccess, x, y, z);
        return WaterRootRenderer.renderBlock(block, info.posX, info.posY, info.posZ, info.noBottom, info.distDown, info.noTop, info.distUp, block.func_149677_c(blockAccess, x, y, z));
    }

    public static boolean renderBlock(Block block, int _x, int _y, int _z, boolean noBottom, int distDown, boolean noTop, int distUp, int brightness) {
        float distToMidTop;
        float distToMidBottom;
        double halfTotalHeightSQ;
        int totalHeight = 1 + distDown + distUp;
        double squareAmount = 1.2;
        if (noTop) {
            halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
            distToMidBottom = Math.abs(distUp + 1);
            distToMidTop = Math.abs(distUp);
        } else if (noBottom) {
            halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
            distToMidBottom = Math.abs(distDown);
            distToMidTop = Math.abs(distDown + 1);
        } else {
            float halfTotalHeight = (float)totalHeight * 0.5f;
            halfTotalHeightSQ = Math.pow(halfTotalHeight, squareAmount);
            distToMidBottom = Math.abs(halfTotalHeight - (float)distUp - 1.0f);
            distToMidTop = Math.abs(halfTotalHeight - (float)distUp);
        }
        int minValBottom = noBottom && distDown == 0 ? 0 : 1;
        int minValTop = noTop && distUp == 0 ? 0 : 1;
        int scaledValBottom = (int)(Math.pow(distToMidBottom, squareAmount) / halfTotalHeightSQ * (double)(8 - minValBottom)) + minValBottom;
        int scaledValTop = (int)(Math.pow(distToMidTop, squareAmount) / halfTotalHeightSQ * (double)(8 - minValTop)) + minValTop;
        IIcon icon = BLBlockRegistry.root.func_149691_a(0, 0);
        float u0 = icon.func_94209_e();
        float u1 = icon.func_94212_f();
        float v0 = icon.func_94206_g();
        float v1 = icon.func_94210_h();
        double halfSize = (double)scaledValBottom / 16.0;
        double halfSizeTexW = halfSize * (double)(u1 - u0);
        double halfSize1 = (double)scaledValTop / 16.0;
        double halfSizeTex1 = halfSize1 * (double)(u1 - u0);
        StalactiteHelper core = StalactiteHelper.getValsFor(_x, _y, _z);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78380_c(brightness);
        float f = 0.9f;
        t.func_78386_a(f, f, f);
        t.func_78374_a((double)_x + core.bX - halfSize, (double)_y, (double)_z + core.bZ - halfSize, (double)u0 + halfSizeTexW * 2.0, (double)v1);
        t.func_78374_a((double)_x + core.bX - halfSize, (double)_y, (double)_z + core.bZ + halfSize, (double)u0, (double)v1);
        t.func_78374_a((double)_x + core.tX - halfSize1, (double)(_y + 1), (double)_z + core.tZ + halfSize1, (double)u0, (double)v0);
        t.func_78374_a((double)_x + core.tX - halfSize1, (double)(_y + 1), (double)_z + core.tZ - halfSize1, (double)u0 + halfSizeTex1 * 2.0, (double)v0);
        t.func_78374_a((double)_x + core.bX + halfSize, (double)_y, (double)_z + core.bZ + halfSize, (double)u0 + halfSizeTexW * 2.0, (double)v1);
        t.func_78374_a((double)_x + core.bX + halfSize, (double)_y, (double)_z + core.bZ - halfSize, (double)u0, (double)v1);
        t.func_78374_a((double)_x + core.tX + halfSize1, (double)(_y + 1), (double)_z + core.tZ - halfSize1, (double)u0, (double)v0);
        t.func_78374_a((double)_x + core.tX + halfSize1, (double)(_y + 1), (double)_z + core.tZ + halfSize1, (double)u0 + halfSizeTex1 * 2.0, (double)v0);
        t.func_78374_a((double)_x + core.bX + halfSize, (double)_y, (double)_z + core.bZ - halfSize, (double)u0 + halfSizeTexW * 2.0, (double)v1);
        t.func_78374_a((double)_x + core.bX - halfSize, (double)_y, (double)_z + core.bZ - halfSize, (double)u0, (double)v1);
        t.func_78374_a((double)_x + core.tX - halfSize1, (double)(_y + 1), (double)_z + core.tZ - halfSize1, (double)u0, (double)v0);
        t.func_78374_a((double)_x + core.tX + halfSize1, (double)(_y + 1), (double)_z + core.tZ - halfSize1, (double)u0 + halfSizeTex1 * 2.0, (double)v0);
        t.func_78374_a((double)_x + core.bX - halfSize, (double)_y, (double)_z + core.bZ + halfSize, (double)u0 + halfSizeTexW * 2.0, (double)v1);
        t.func_78374_a((double)_x + core.bX + halfSize, (double)_y, (double)_z + core.bZ + halfSize, (double)u0, (double)v1);
        t.func_78374_a((double)_x + core.tX + halfSize1, (double)(_y + 1), (double)_z + core.tZ + halfSize1, (double)u0, (double)v0);
        t.func_78374_a((double)_x + core.tX - halfSize1, (double)(_y + 1), (double)_z + core.tZ + halfSize1, (double)u0 + halfSizeTex1 * 2.0, (double)v0);
        icon = BLBlockRegistry.root.func_149691_a(2, 0);
        u0 = icon.func_94209_e();
        v0 = icon.func_94206_g();
        if (distUp == 0) {
            t.func_78374_a((double)_x + core.tX - halfSize1, (double)(_y + 1), (double)_z + core.tZ - halfSize1, (double)u0, (double)v0);
            t.func_78374_a((double)_x + core.tX - halfSize1, (double)(_y + 1), (double)_z + core.tZ + halfSize1, (double)u0 + halfSizeTex1 * 2.0, (double)v0);
            t.func_78374_a((double)_x + core.tX + halfSize1, (double)(_y + 1), (double)_z + core.tZ + halfSize1, (double)u0 + halfSizeTex1 * 2.0, (double)v0 + halfSizeTex1 * 2.0);
            t.func_78374_a((double)_x + core.tX + halfSize1, (double)(_y + 1), (double)_z + core.tZ - halfSize1, (double)u0, (double)v0 + halfSizeTex1 * 2.0);
        }
        if (distDown == 0) {
            t.func_78374_a((double)_x + core.bX - halfSize, (double)_y, (double)_z + core.bZ + halfSize, (double)u0 + halfSizeTexW * 2.0, (double)v0);
            t.func_78374_a((double)_x + core.bX - halfSize, (double)_y, (double)_z + core.bZ - halfSize, (double)u0, (double)v0);
            t.func_78374_a((double)_x + core.bX + halfSize, (double)_y, (double)_z + core.bZ - halfSize, (double)u0, (double)v0 + halfSizeTexW * 2.0);
            t.func_78374_a((double)_x + core.bX + halfSize, (double)_y, (double)_z + core.bZ + halfSize, (double)u0 + halfSizeTexW * 2.0, (double)v0 + halfSizeTexW * 2.0);
        }
        return true;
    }

    @Override
    public IIcon getIcon() {
        return null;
    }
}

