/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import thebetweenlands.blocks.terrain.BlockSwampWater;
import thebetweenlands.client.render.block.water.IWaterRenderer;
import thebetweenlands.proxy.ClientProxy;

public class BlockSwampWaterRenderer
implements ISimpleBlockRenderingHandler {
    private Field f_GuiIngame_itemRenderer = ReflectionHelper.findField(GuiIngame.class, (String[])new String[]{"itemRenderer", "field_73841_b", "i"});
    private Field f_RenderItem_renderBlocksRi = ReflectionHelper.findField(RenderItem.class, (String[])new String[]{"renderBlocksRi", "field_147913_i", "i"});
    private Field f_Render_renderBlocks = ReflectionHelper.findField(Render.class, (String[])new String[]{"field_147909_c", "c"});
    private Field f_GuiScreen_itemRenderer = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"itemRender", "field_146296_j", "j"});

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        IWaterRenderer specialRenderer = ((BlockSwampWater)block).getSpecialRenderer();
        if (specialRenderer != null) {
            if (specialRenderer.getIcon() != null) {
                boolean isInInventory = false;
                try {
                    RenderItem renderItem1 = (RenderItem)this.f_GuiIngame_itemRenderer.get(Minecraft.func_71410_x().field_71456_v);
                    RenderBlocks renderBlocks1 = (RenderBlocks)this.f_RenderItem_renderBlocksRi.get(renderItem1);
                    RenderBlocks renderBlocks2 = (RenderBlocks)this.f_Render_renderBlocks.get(renderItem1);
                    RenderBlocks renderBlocks3 = null;
                    Minecraft.func_71410_x();
                    if (Minecraft.func_71410_x().field_71462_r != null) {
                        RenderItem renderItem2 = (RenderItem)this.f_GuiScreen_itemRenderer.get(null);
                        renderBlocks3 = (RenderBlocks)this.f_RenderItem_renderBlocksRi.get(renderItem2);
                    }
                    isInInventory = renderBlocks1 == renderer || renderBlocks2 == renderer || renderBlocks3 == renderer;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (isInInventory) {
                    GL11.glPushMatrix();
                    GL11.glDisable((int)2896);
                    GL11.glRotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)-1.0f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    IIcon icon = specialRenderer.getIcon();
                    double size = 0.82;
                    Tessellator tessellator = Tessellator.field_78398_a;
                    tessellator.func_78376_a(255, 255, 255);
                    tessellator.func_78382_b();
                    tessellator.func_78374_a(0.0, size, size, (double)icon.func_94209_e(), (double)icon.func_94206_g());
                    tessellator.func_78374_a(0.0, -size, size, (double)icon.func_94209_e(), (double)icon.func_94210_h());
                    tessellator.func_78374_a(0.0, -size, -size, (double)icon.func_94212_f(), (double)icon.func_94210_h());
                    tessellator.func_78374_a(0.0, size, -size, (double)icon.func_94212_f(), (double)icon.func_94206_g());
                    tessellator.func_78381_a();
                    GL11.glEnable((int)2896);
                    GL11.glPopMatrix();
                } else {
                    specialRenderer.renderInventoryBlock(block, metadata, modelID, renderer);
                }
            } else {
                specialRenderer.renderInventoryBlock(block, metadata, modelID, renderer);
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        float f11;
        float f10;
        float f9;
        BlockSwampWater swampWaterBlock = (BlockSwampWater)block;
        Tessellator tessellator = Tessellator.field_78398_a;
        int colorMultiplier = block.func_149720_d(blockAccess, x, y, z);
        float colorR = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(colorMultiplier & 0xFF) / 255.0f;
        boolean isBreakingBlock = renderer.field_147840_d != null;
        boolean renderTop = block.func_149646_a(blockAccess, x, y + 1, z, 1);
        boolean renderBottom = block.func_149646_a(blockAccess, x, y - 1, z, 0);
        boolean[] renderSides = new boolean[]{block.func_149646_a(blockAccess, x, y, z - 1, 2), block.func_149646_a(blockAccess, x, y, z + 1, 3), block.func_149646_a(blockAccess, x - 1, y, z, 4), block.func_149646_a(blockAccess, x + 1, y, z, 5)};
        IWaterRenderer specialRenderer = ((BlockSwampWater)block).getSpecialRenderer();
        if (specialRenderer != null) {
            tessellator.func_78380_c(blockAccess.func_72802_i(x, y, z, 0));
            specialRenderer.renderWorldBlock(blockAccess, x, y, z, block, modelId, renderer);
        }
        if (!(!isBreakingBlock && (renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3]))) {
            return false;
        }
        boolean flag2 = false;
        float f3 = 0.5f;
        float colorMult = 1.0f;
        tessellator.func_78386_a(colorMult * colorR, colorMult * colorG, colorMult * colorB);
        float f5 = 0.8f;
        float f6 = 0.6f;
        double d0 = 0.0;
        double d1 = 1.0;
        int i1 = blockAccess.func_72805_g(x, y, z);
        Material material = block.func_149688_o();
        double wch = this.getLiquidHeight(blockAccess, x, y, z, Material.field_151586_h);
        double wzh = this.getLiquidHeight(blockAccess, x, y, z + 1, Material.field_151586_h);
        double wxzh = this.getLiquidHeight(blockAccess, x + 1, y, z + 1, Material.field_151586_h);
        double wxh = this.getLiquidHeight(blockAccess, x + 1, y, z, Material.field_151586_h);
        double minHeightSub = 0.001f;
        if (renderer.field_147837_f || renderTop) {
            double d20;
            double d12;
            double d18;
            double d10;
            double d16;
            double d8;
            double d14;
            double d7;
            flag2 = true;
            IIcon iicon = swampWaterBlock.getWaterIcon(1);
            float f7 = 0.0f;
            if (!(material != Material.field_151586_h && material != Material.field_151587_i || block instanceof BlockSwampWater)) {
                f7 = (float)BlockLiquid.func_149802_a((IBlockAccess)blockAccess, (int)x, (int)y, (int)z, (Material)material);
            } else {
                BlockSwampWater cfr_ignored_0 = (BlockSwampWater)block;
                f7 = (float)BlockSwampWater.getFlowDirection((IBlockAccess)blockAccess, (int)x, (int)y, (int)z);
            }
            if (f7 > -999.0f) {
                iicon = swampWaterBlock.getWaterIcon(2);
            }
            wch -= minHeightSub;
            wzh -= minHeightSub;
            wxzh -= minHeightSub;
            wxh -= minHeightSub;
            if (f7 < -999.0f) {
                d7 = iicon.func_94214_a(0.0);
                d14 = iicon.func_94207_b(0.0);
                d8 = d7;
                d16 = iicon.func_94207_b(16.0);
                d10 = iicon.func_94214_a(16.0);
                d18 = d16;
                d12 = d10;
                d20 = d14;
            } else {
                f9 = MathHelper.func_76126_a((float)f7) * 0.25f;
                f10 = MathHelper.func_76134_b((float)f7) * 0.25f;
                f11 = 8.0f;
                d7 = iicon.func_94214_a((double)(8.0f + (-f10 - f9) * 16.0f));
                d14 = iicon.func_94207_b((double)(8.0f + (-f10 + f9) * 16.0f));
                d8 = iicon.func_94214_a((double)(8.0f + (-f10 + f9) * 16.0f));
                d16 = iicon.func_94207_b((double)(8.0f + (f10 + f9) * 16.0f));
                d10 = iicon.func_94214_a((double)(8.0f + (f10 + f9) * 16.0f));
                d18 = iicon.func_94207_b((double)(8.0f + (f10 - f9) * 16.0f));
                d12 = iicon.func_94214_a((double)(8.0f + (f10 - f9) * 16.0f));
                d20 = iicon.func_94207_b((double)(8.0f + (-f10 - f9) * 16.0f));
            }
            tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y, z));
            tessellator.func_78386_a(colorMult * colorR, colorMult * colorG, colorMult * colorB);
            tessellator.func_78374_a((double)(x + 0), (double)y + wch, (double)(z + 0), d7, d14);
            tessellator.func_78374_a((double)(x + 0), (double)y + wzh, (double)(z + 1), d8, d16);
            tessellator.func_78374_a((double)(x + 1), (double)y + wxzh, (double)(z + 1), d10, d18);
            tessellator.func_78374_a((double)(x + 1), (double)y + wxh, (double)(z + 0), d12, d20);
            tessellator.func_78374_a((double)(x + 0), (double)y + wch, (double)(z + 0), d7, d14);
            tessellator.func_78374_a((double)(x + 1), (double)y + wxh, (double)(z + 0), d12, d20);
            tessellator.func_78374_a((double)(x + 1), (double)y + wxzh, (double)(z + 1), d10, d18);
            tessellator.func_78374_a((double)(x + 0), (double)y + wzh, (double)(z + 1), d8, d16);
        }
        if ((renderer.field_147837_f || renderBottom) && !(blockAccess.func_147439_a(x, y - 1, z) instanceof BlockSwampWater)) {
            tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y - 1, z));
            tessellator.func_78386_a(colorMult * colorR, colorMult * colorG, colorMult * colorB);
            renderer.func_147768_a(block, (double)x, (double)y + minHeightSub, (double)z, swampWaterBlock.getWaterIcon(0));
            flag2 = true;
        }
        for (int k1 = 0; k1 < 4; ++k1) {
            double d19;
            double d15;
            double d17;
            double d13;
            double d11;
            double d9;
            int l1 = x;
            int j1 = z;
            if (k1 == 0) {
                j1 = z - 1;
            }
            if (k1 == 1) {
                ++j1;
            }
            if (k1 == 2) {
                l1 = x - 1;
            }
            if (k1 == 3) {
                ++l1;
            }
            IIcon iicon1 = swampWaterBlock.getWaterIcon(k1 + 2);
            if (!renderer.field_147837_f && !renderSides[k1]) continue;
            if (k1 == 0) {
                d9 = wch;
                d11 = wxh;
                d13 = x;
                d17 = x + 1;
                d15 = (double)z + minHeightSub;
                d19 = (double)z + minHeightSub;
            } else if (k1 == 1) {
                d9 = wxzh;
                d11 = wzh;
                d13 = x + 1;
                d17 = x;
                d15 = (double)(z + 1) - minHeightSub;
                d19 = (double)(z + 1) - minHeightSub;
            } else if (k1 == 2) {
                d9 = wzh;
                d11 = wch;
                d13 = (double)x + minHeightSub;
                d17 = (double)x + minHeightSub;
                d15 = z + 1;
                d19 = z;
            } else {
                d9 = wxh;
                d11 = wxzh;
                d13 = (double)(x + 1) - minHeightSub;
                d17 = (double)(x + 1) - minHeightSub;
                d15 = z;
                d19 = z + 1;
            }
            flag2 = true;
            float f8 = iicon1.func_94214_a(0.0);
            f9 = iicon1.func_94214_a(8.0);
            f10 = iicon1.func_94207_b((1.0 - d9) * 16.0 * 0.5);
            f11 = iicon1.func_94207_b((1.0 - d11) * 16.0 * 0.5);
            float f12 = iicon1.func_94207_b(8.0);
            tessellator.func_78380_c(block.func_149677_c(blockAccess, l1, y, j1));
            float f13 = 1.0f;
            tessellator.func_78386_a(colorMult * (f13 *= k1 < 2 ? f5 : f6) * colorR, colorMult * f13 * colorG, colorMult * f13 * colorB);
            tessellator.func_78374_a(d13, (double)y + d9, d15, (double)f8, (double)f10);
            tessellator.func_78374_a(d17, (double)y + d11, d19, (double)f9, (double)f11);
            tessellator.func_78374_a(d17, (double)(y + 0), d19, (double)f9, (double)f12);
            tessellator.func_78374_a(d13, (double)(y + 0), d15, (double)f8, (double)f12);
            tessellator.func_78374_a(d13, (double)(y + 0), d15, (double)f8, (double)f12);
            tessellator.func_78374_a(d17, (double)(y + 0), d19, (double)f9, (double)f12);
            tessellator.func_78374_a(d17, (double)y + d11, d19, (double)f9, (double)f11);
            tessellator.func_78374_a(d13, (double)y + d9, d15, (double)f8, (double)f10);
        }
        renderer.field_147855_j = d0;
        renderer.field_147857_k = d1;
        return flag2;
    }

    public float getLiquidHeight(IBlockAccess blockAccess, int x, int y, int z, Material liquidMaterial) {
        int l = 0;
        float f = 0.0f;
        for (int sb = 0; sb < 4; ++sb) {
            int xp = x - (sb & 1);
            int zp = z - (sb >> 1 & 1);
            if (blockAccess.func_147439_a(xp, y + 1, zp).func_149688_o() == liquidMaterial) {
                return 1.0f;
            }
            if (blockAccess.func_147439_a(xp, y, zp) instanceof BlockSwampWater) {
                f = (float)((double)f + (1.1 - (double)((BlockSwampWater)blockAccess.func_147439_a(xp, y, zp)).getQuantaPercentage(blockAccess, xp, y, zp)));
                ++l;
                continue;
            }
            Material material = blockAccess.func_147439_a(xp, y, zp).func_149688_o();
            if (material == liquidMaterial) {
                int l1 = blockAccess.func_72805_g(xp, y, zp);
                if (l1 >= 8 || l1 == 0) {
                    f += BlockLiquid.func_149801_b((int)l1) * 10.0f;
                    l += 10;
                }
                f += BlockLiquid.func_149801_b((int)l1);
                ++l;
                continue;
            }
            if (material.func_76220_a()) continue;
            f += 1.0f;
            ++l;
        }
        return 1.0f - f / (float)l;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.BlockRenderIDs.SWAMP_WATER.id();
    }
}

