/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.tree.BlockRubberLog;
import thebetweenlands.proxy.ClientProxy;

@SideOnly(value=Side.CLIENT)
public class BlockRubberLogRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            tessellator.func_78380_c(mc.field_71441_e.func_72802_i((int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70163_u, (int)mc.field_71439_g.field_70161_v, 0));
        }
        IIcon topIcon = ((BlockRubberLog)block).func_150161_d(0);
        IIcon sideIcon = ((BlockRubberLog)block).func_150163_b(0);
        tessellator.func_78382_b();
        this.renderBoxX(topIcon, sideIcon, 3, tessellator, 0.32, 0.0, 0.32, 0.68, 1.0, 0.68);
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(world.func_72802_i(x, y, z, 0));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        IIcon topIcon = ((BlockRubberLog)block).func_150161_d(meta);
        IIcon sideIcon = ((BlockRubberLog)block).func_150163_b(meta);
        boolean yp = this.isValidBlock(world, x, y + 1, z, meta);
        boolean ym = this.isValidBlock(world, x, y - 1, z, meta) || world.func_147439_a(x, y - 1, z).isSideSolid(world, x, y - 1, z, ForgeDirection.UP);
        boolean xp = this.isValidBlock(world, x + 1, y, z, meta);
        boolean xm = this.isValidBlock(world, x - 1, y, z, meta);
        boolean zp = this.isValidBlock(world, x, y, z + 1, meta);
        boolean zm = this.isValidBlock(world, x, y, z - 1, meta);
        int sideIndex = 0;
        int sideCount = 0;
        if (yp) {
            ++sideCount;
        }
        if (ym) {
            ++sideCount;
        }
        if (xp) {
            ++sideCount;
        }
        if (xm) {
            ++sideCount;
        }
        if (zp) {
            ++sideCount;
        }
        if (zm) {
            ++sideCount;
        }
        if (sideCount == 1) {
            if (yp) {
                sideIndex |= 2;
            }
            if (ym) {
                sideIndex |= 1;
            }
            if (xp) {
                sideIndex |= 8;
            }
            if (xm) {
                sideIndex |= 4;
            }
            if (zp) {
                sideIndex |= 0x20;
            }
            if (zm) {
                sideIndex |= 0x10;
            }
        }
        if (!yp && !ym) {
            if (xp || xm) {
                this.renderBoxSideX(topIcon, sideIcon, sideIndex, tessellator, (double)x + 0.25, (double)y + 0.25, (double)z + 0.25, (double)x + 0.75, (double)y + 0.75, (double)z + 0.75);
            } else {
                this.renderBoxSideZ(topIcon, sideIcon, sideIndex, tessellator, (double)x + 0.25, (double)y + 0.25, (double)z + 0.25, (double)x + 0.75, (double)y + 0.75, (double)z + 0.75);
            }
        } else {
            this.renderBoxX(topIcon, sideIcon, sideIndex, tessellator, (double)x + 0.25, (double)y + 0.25, (double)z + 0.25, (double)x + 0.75, (double)y + 0.75, (double)z + 0.75);
        }
        if (yp) {
            this.renderBoxXS(topIcon, sideIcon, 1, tessellator, (double)x + 0.25, (double)y + 0.75, (double)z + 0.25, (double)x + 0.75, (double)y + 1.0, (double)z + 0.75);
        }
        if (ym) {
            this.renderBoxXS(topIcon, sideIcon, 2, tessellator, (double)x + 0.25, y, (double)z + 0.25, (double)x + 0.75, (double)y + 0.25, (double)z + 0.75);
        }
        if (xp) {
            this.renderBoxSideXS(topIcon, sideIcon, 4, tessellator, (double)x + 0.75, (double)y + 0.25, (double)z + 0.25, (double)x + 1.0, (double)y + 0.75, (double)z + 0.75);
        }
        if (xm) {
            this.renderBoxSideXS(topIcon, sideIcon, 8, tessellator, x, (double)y + 0.25, (double)z + 0.25, (double)x + 0.25, (double)y + 0.75, (double)z + 0.75);
        }
        if (zp) {
            this.renderBoxSideZS(topIcon, sideIcon, 16, tessellator, (double)x + 0.25, (double)y + 0.25, (double)z + 0.75, (double)x + 0.75, (double)y + 0.75, (double)z + 1.0);
        }
        if (zm) {
            this.renderBoxSideZS(topIcon, sideIcon, 32, tessellator, (double)x + 0.25, (double)y + 0.25, z, (double)x + 0.75, (double)y + 0.75, (double)z + 0.25);
        }
        return true;
    }

    public void renderQuad(IIcon icon, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        double umin = icon.func_94209_e();
        double vmin = icon.func_94206_g();
        double umax = icon.func_94212_f();
        double vmax = icon.func_94210_h();
        double du = umax - umin;
        double dv = vmax - vmin;
        tessellator.func_78374_a(x1, y1, z1, umin += du / 16.0 * 4.0, vmin += dv / 16.0 * 4.0);
        tessellator.func_78374_a(x2, y2, z2, umax -= du / 16.0 * 4.0, vmin);
        tessellator.func_78374_a(x3, y3, z3, umax, vmax -= dv / 16.0 * 4.0);
        tessellator.func_78374_a(x4, y4, z4, umin, vmax);
    }

    public void renderQuadS(IIcon icon, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        double umin = icon.func_94209_e();
        double vmin = icon.func_94206_g();
        double umax = icon.func_94212_f();
        double vmax = icon.func_94210_h();
        double du = umax - umin;
        double dv = vmax - vmin;
        tessellator.func_78374_a(x1, y1, z1, umin += du / 16.0 * 4.0, vmin += dv / 16.0 * 4.0);
        tessellator.func_78374_a(x2, y2, z2, umax -= du / 16.0 * 4.0, vmin);
        tessellator.func_78374_a(x3, y3, z3, umax, vmax -= dv / 16.0 * 8.0);
        tessellator.func_78374_a(x4, y4, z4, umin, vmax);
    }

    public void renderBoxX(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderQuad((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderQuad((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y2, z1, x2, y2, z2, x2, y1, z2, x2, y1, z1);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuad((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuad((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1);
    }

    public void renderBoxZ(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderQuad((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderQuad((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y2, z1, x2, y2, z2, x2, y1, z2, x2, y1, z1);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuad((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuad((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1);
    }

    public void renderBoxSideX(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderQuad((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderQuad((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x2, y1, z2, x1, y1, z2, x1, y1, z1);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuad((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuad((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
    }

    public void renderBoxSideZ(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderQuad((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x2, y2, z1, x1, y2, z1, x1, y2, z2, x2, y2, z2);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderQuad((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuad((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuad((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuad((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
    }

    public void renderBoxXS(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderQuadS((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderQuadS((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y2, z1, x2, y2, z2, x2, y1, z2, x2, y1, z1);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuadS((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuadS((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1);
    }

    public void renderBoxZS(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderQuadS((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderQuadS((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y2, z1, x2, y2, z2, x2, y1, z2, x2, y1, z1);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuadS((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuadS((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1);
    }

    public void renderBoxSideXS(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x2, y1, z2, x1, y1, z2, x1, y1, z1);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuadS((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuadS((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
    }

    public void renderBoxSideZS(IIcon topIcon, IIcon sideIcon, int topIconIndex, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.renderQuadS((topIconIndex & 1) == 0 ? sideIcon : topIcon, tessellator, x2, y2, z1, x1, y2, z1, x1, y2, z2, x2, y2, z2);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderQuadS((topIconIndex & 2) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 4) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderQuadS((topIconIndex & 8) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderQuadS((topIconIndex & 0x10) == 0 ? sideIcon : topIcon, tessellator, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderQuadS((topIconIndex & 0x20) == 0 ? sideIcon : topIcon, tessellator, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
    }

    public boolean isValidBlock(IBlockAccess world, int x, int y, int z, int centerMeta) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        return block == BLBlockRegistry.rubberTreeLog && meta == centerMeta || block == BLBlockRegistry.rubberTreeLeaves;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.BlockRenderIDs.RUBBER_LOG.id();
    }
}

