/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.render.block.BlockRenderHelper;
import thebetweenlands.proxy.ClientProxy;
import thebetweenlands.utils.ConnectedTexture;

public class BlockFarmedDirtRenderer
implements ISimpleBlockRenderingHandler {
    private static final ConnectedTexture farmedDirtTextureHelper = new ConnectedTexture(64, 18, 1);

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.func_147782_a(0.0, -0.1, 0.0, 1.0, 0.9, 1.0);
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            Tessellator.field_78398_a.func_78380_c(mc.field_71441_e.func_72802_i((int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70163_u, (int)mc.field_71439_g.field_70161_v, 0));
        }
        Tessellator.field_78398_a.func_78382_b();
        BlockRenderHelper.renderSimpleBlock(block, metadata, renderer);
        if (metadata != 0) {
            IIcon icon = BLBlockRegistry.farmedDirt.func_149691_a(1, metadata);
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            for (int bsx = 0; bsx <= 1; ++bsx) {
                for (int bsz = 0; bsz <= 1; ++bsz) {
                    int quadrant = bsx + bsz * 2;
                    float rxOffset = 0.5f * (float)bsx;
                    float rzOffset = 0.5f * (float)bsz;
                    float[][] relIconUVs = farmedDirtTextureHelper.getUVs(0, quadrant);
                    Tessellator.field_78398_a.func_78372_c(rxOffset, 0.901f, rzOffset);
                    Tessellator.field_78398_a.func_78374_a(-0.0, 0.0, 0.0, (double)icon.func_94214_a((double)relIconUVs[0][0] * 16.0), (double)icon.func_94207_b((double)relIconUVs[0][1] * 16.0));
                    Tessellator.field_78398_a.func_78374_a(-0.0, 0.0, 0.5, (double)icon.func_94214_a((double)relIconUVs[0][0] * 16.0), (double)icon.func_94207_b((double)relIconUVs[1][1] * 16.0));
                    Tessellator.field_78398_a.func_78374_a(0.5, 0.0, 0.5, (double)icon.func_94214_a((double)relIconUVs[1][0] * 16.0), (double)icon.func_94207_b((double)relIconUVs[1][1] * 16.0));
                    Tessellator.field_78398_a.func_78374_a(0.5, 0.0, 0.0, (double)icon.func_94214_a((double)relIconUVs[1][0] * 16.0), (double)icon.func_94207_b((double)relIconUVs[0][1] * 16.0));
                    Tessellator.field_78398_a.func_78372_c(-rxOffset, -0.901f, -rzOffset);
                }
            }
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        if (meta == 0) {
            renderer.field_147837_f = true;
        }
        renderer.func_147784_q(block, x, y, z);
        renderer.field_147837_f = false;
        IIcon icon = BLBlockRegistry.farmedDirt.func_149691_a(1, meta);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78380_c(block.func_149677_c(world, x, y + 1, z));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        float ry = (float)y + 1.0f;
        tessellator.func_78372_c((float)x, ry, (float)z);
        if (meta != 0) {
            boolean[] blockArray = new boolean[9];
            boolean isPure = meta == 6 || meta == 9 || meta == 10;
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    int currentMeta = world.func_72805_g(x + xo, y, z + zo);
                    boolean isCurrentPure = currentMeta == 6 || currentMeta == 9 || currentMeta == 10;
                    blockArray[ConnectedTexture.getIndex((int)(xo + 1), (int)(zo + 1), (int)3)] = world.func_147439_a(x + xo, y, z + zo) == BLBlockRegistry.farmedDirt && (isCurrentPure && isPure || currentMeta == meta);
                }
            }
            float[][][] blockRelIconUVs = farmedDirtTextureHelper.getFaceUVs(blockArray);
            for (int bsx = 0; bsx <= 1; ++bsx) {
                for (int bsz = 0; bsz <= 1; ++bsz) {
                    float rxOffset = 0.5f * (float)bsx;
                    float rzOffset = 0.5f * (float)bsz;
                    float[][] quadrantRelIconUVs = blockRelIconUVs[ConnectedTexture.getIndex(bsx, bsz, 2)];
                    tessellator.func_78372_c(rxOffset, 0.0f, rzOffset);
                    tessellator.func_78374_a(-0.0, 0.0, 0.0, (double)icon.func_94214_a((double)quadrantRelIconUVs[0][0] * 16.0), (double)icon.func_94207_b((double)quadrantRelIconUVs[0][1] * 16.0));
                    tessellator.func_78374_a(-0.0, 0.0, 0.5, (double)icon.func_94214_a((double)quadrantRelIconUVs[0][0] * 16.0), (double)icon.func_94207_b((double)quadrantRelIconUVs[1][1] * 16.0));
                    tessellator.func_78374_a(0.5, 0.0, 0.5, (double)icon.func_94214_a((double)quadrantRelIconUVs[1][0] * 16.0), (double)icon.func_94207_b((double)quadrantRelIconUVs[1][1] * 16.0));
                    tessellator.func_78374_a(0.5, 0.0, 0.0, (double)icon.func_94214_a((double)quadrantRelIconUVs[1][0] * 16.0), (double)icon.func_94207_b((double)quadrantRelIconUVs[0][1] * 16.0));
                    tessellator.func_78372_c(-rxOffset, 0.0f, -rzOffset);
                }
            }
        }
        tessellator.func_78372_c((float)(-x), -ry, (float)(-z));
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.BlockRenderIDs.FARMED_DIRT.id();
    }
}

