/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureCorrosion
extends TextureAtlasSprite {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random(0L);
    private static final ResourceLocation CORROSION_RESOURCE = new ResourceLocation("thebetweenlands", "textures/items/toolCorrosion.png");
    private static int[] corrosionPixels;
    private static int corrosionWidth;
    private static int corrosionHeight;
    private AnimationMetadataSection animationMetadata;
    private long seed;
    private String baseIconName;
    private int corrosionAmount;

    public TextureCorrosion(String iconName, String baseIconName, int corrosionAmount, long seed) {
        super(iconName);
        this.baseIconName = baseIconName;
        this.corrosionAmount = corrosionAmount;
        this.seed = seed;
    }

    private void resetSprite() {
        this.animationMetadata = null;
        this.func_110968_a(Lists.newArrayList());
        this.field_110973_g = 0;
        this.field_110983_h = 0;
    }

    private void loadCorrosionPixels(IResourceManager manager) {
        try {
            BufferedImage corrosionImg = ImageIO.read(manager.func_110536_a(CORROSION_RESOURCE).func_110527_b());
            corrosionPixels = new int[corrosionImg.getWidth() * corrosionImg.getHeight()];
            corrosionImg.getRGB(0, 0, corrosionImg.getWidth(), corrosionImg.getHeight(), corrosionPixels, 0, corrosionImg.getWidth());
            corrosionWidth = corrosionImg.getWidth();
            corrosionHeight = corrosionImg.getHeight();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        if (corrosionPixels == null) {
            this.loadCorrosionPixels(manager);
        }
        location = new ResourceLocation(this.baseIconName);
        ResourceLocation resourcelocation1 = this.completeResourceLocation(location, 0);
        try {
            IResource resource = manager.func_110536_a(resourcelocation1);
            BufferedImage[] bufferedImage = new BufferedImage[]{ImageIO.read(resource.func_110527_b())};
            this.func_147964_a(bufferedImage, (AnimationMetadataSection)resource.func_110526_a("animation"), false);
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.error("Unable to parse metadata from " + resourcelocation1, (Throwable)runtimeexception);
        }
        catch (IOException ioexception1) {
            ioexception1.printStackTrace();
        }
        return false;
    }

    private ResourceLocation completeResourceLocation(ResourceLocation location, int level) {
        return level == 0 ? new ResourceLocation(location.func_110624_b(), String.format("textures/items/%s.png", location.func_110623_a())) : new ResourceLocation(location.func_110624_b(), String.format("textures/items/mipmaps/%s.%d.png", location.func_110623_a(), level));
    }

    public void func_147964_a(BufferedImage[] mipmapImages, AnimationMetadataSection metadata, boolean useAnisotropicFiltering) {
        this.resetSprite();
        int width = mipmapImages[0].getWidth();
        int height = mipmapImages[0].getHeight();
        this.field_130223_c = width;
        this.field_130224_d = height;
        int[][] mipmapLevels = new int[mipmapImages.length][];
        BufferedImage bufferedimage = mipmapImages[0];
        mipmapLevels[0] = new int[bufferedimage.getWidth() * bufferedimage.getHeight()];
        bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), mipmapLevels[0], 0, bufferedimage.getWidth());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (y % width == 0) {
                    RANDOM.setSeed(this.seed);
                }
                int pixel = mipmapLevels[0][x + y * width];
                int corrosion = 0;
                if (pixel >>> 24 != 0 && RANDOM.nextInt(3) != 0) {
                    corrosion = corrosionPixels[x % width % corrosionWidth + y % width % corrosionWidth * corrosionWidth];
                }
                int r1 = pixel >> 16 & 0xFF;
                int g1 = pixel >> 8 & 0xFF;
                int b1 = pixel & 0xFF;
                float alpha = (float)this.corrosionAmount / 5.0f * ((float)(corrosion >>> 24 & 0xFF) / 255.0f) * (0.25f + RANDOM.nextFloat() * 0.75f);
                int r2 = corrosion >> 16 & 0xFF;
                int g2 = corrosion >> 8 & 0xFF;
                int b2 = corrosion & 0xFF;
                pixel &= 0xFF000000;
                pixel |= (int)(alpha * (float)r2 + (1.0f - alpha) * (float)r1 + 0.5f) << 16;
                pixel |= (int)(alpha * (float)g2 + (1.0f - alpha) * (float)g1 + 0.5f) << 8;
                mipmapLevels[0][x + y * width] = pixel |= (int)(alpha * (float)b2 + (1.0f - alpha) * (float)b1 + 0.5f);
            }
        }
        if (metadata == null) {
            if (height != width) {
                throw new RuntimeException("broken aspect ratio and not an animation");
            }
            this.field_110976_a.add(mipmapLevels);
        } else {
            int frameIndex;
            int frameCount = height / width;
            int frameWidth = width;
            int frameHeight = width;
            this.field_130224_d = width;
            if (metadata.func_110473_c() > 0) {
                Iterator frameIndexIterator = metadata.func_130073_e().iterator();
                frameIndex = 0;
                while (frameIndexIterator.hasNext()) {
                    frameIndex = (Integer)frameIndexIterator.next();
                    if (frameIndex >= frameCount) {
                        throw new RuntimeException("invalid frameindex " + frameIndex);
                    }
                    this.allocateFrameTextureData(frameIndex);
                    this.field_110976_a.set(frameIndex, TextureCorrosion.getFrameTextureData(mipmapLevels, frameWidth, frameHeight, frameIndex));
                }
                this.animationMetadata = metadata;
            } else {
                ArrayList arraylist = Lists.newArrayList();
                for (frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                    this.field_110976_a.add(TextureCorrosion.getFrameTextureData(mipmapLevels, frameWidth, frameHeight, frameIndex));
                    arraylist.add(new AnimationFrame(frameIndex, -1));
                }
                this.animationMetadata = new AnimationMetadataSection((List)arraylist, width, height, metadata.func_110469_d());
            }
        }
    }

    private void allocateFrameTextureData(int frameCount) {
        if (this.field_110976_a.size() <= frameCount) {
            for (int i = this.field_110976_a.size(); i <= frameCount; ++i) {
                this.field_110976_a.add(null);
            }
        }
    }

    private static int[][] getFrameTextureData(int[][] framesData, int width, int height, int offset) {
        int[][] newFrameData = new int[framesData.length][];
        for (int frame = 0; frame < framesData.length; ++frame) {
            int[] frameData = framesData[frame];
            if (frameData == null) continue;
            newFrameData[frame] = new int[(width >> frame) * (height >> frame)];
            System.arraycopy(frameData, offset * newFrameData[frame].length, newFrameData[frame], 0, newFrameData[frame].length);
        }
        return newFrameData;
    }

    public void func_94219_l() {
        ++this.field_110983_h;
        if (this.field_110983_h >= this.animationMetadata.func_110472_a(this.field_110973_g)) {
            int i = this.animationMetadata.func_110468_c(this.field_110973_g);
            int j = this.animationMetadata.func_110473_c() == 0 ? this.field_110976_a.size() : this.animationMetadata.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % j;
            this.field_110983_h = 0;
            int k = this.animationMetadata.func_110468_c(this.field_110973_g);
            if (i != k && k >= 0 && k < this.field_110976_a.size()) {
                TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(k)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        }
    }

    public boolean func_130098_m() {
        return this.animationMetadata != null;
    }
}

