/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public final class PlayerLimbPreMirrorer {
    private static final LoadingCache<AbstractClientPlayer, ResourceLocation> PRE_MIRRORED_SKINS = CacheBuilder.newBuilder().weakKeys().maximumSize(2622L).expireAfterAccess(20L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AbstractClientPlayer, ResourceLocation>(){

        public void onRemoval(RemovalNotification<AbstractClientPlayer, ResourceLocation> notification) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c((ResourceLocation)notification.getValue());
        }
    }).build((CacheLoader)new CacheLoader<AbstractClientPlayer, ResourceLocation>(){

        public ResourceLocation load(AbstractClientPlayer key) throws Exception {
            final BufferedImage image = PlayerLimbPreMirrorer.getPlayerSkinImage(key);
            if (image == null) {
                return STEVE_PRE_MIRRORED;
            }
            ResourceLocation resourceLocation = PlayerLimbPreMirrorer.createResourceLocation(key);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, new ITextureObject(){
                private int textureId;

                public void func_110551_a(IResourceManager resourceManager) throws IOException {
                    BufferedImage adjusted = new BufferedImage(64, 64, 2);
                    Graphics2D g = adjusted.createGraphics();
                    g.drawImage((Image)image, 0, 0, null);
                    int[] pixels = ((DataBufferInt)adjusted.getRaster().getDataBuffer()).getData();
                    PlayerLimbPreMirrorer.mirrorLimb(pixels, 0, 16, 16, 48);
                    PlayerLimbPreMirrorer.mirrorLimb(pixels, 40, 16, 32, 48);
                    this.textureId = TextureUtil.func_110996_a();
                    TextureUtil.func_110987_a((int)this.textureId, (BufferedImage)adjusted);
                }

                public int func_110552_b() {
                    return this.textureId;
                }
            });
            return resourceLocation;
        }
    });
    private static final ResourceLocation STEVE_PRE_MIRRORED = new ResourceLocation("thebetweenlands", "textures/entity/steve_mirror_adjusted.png");
    private static final int TEXTURE_SIZE = 64;

    private PlayerLimbPreMirrorer() {
    }

    public static ResourceLocation getPlayerSkin(AbstractClientPlayer player) {
        try {
            return (ResourceLocation)PRE_MIRRORED_SKINS.get((Object)player);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return STEVE_PRE_MIRRORED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getPlayerSkinImage(AbstractClientPlayer player) {
        BufferedImage image;
        block7: {
            Minecraft mc = Minecraft.func_71410_x();
            image = null;
            InputStream steveInputStream = null;
            Map map = mc.func_152342_ad().func_152788_a(player.func_146103_bH());
            try {
                ITextureObject texture = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? mc.field_71446_o.func_110581_b(mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : mc.field_71446_o.func_110581_b(player.func_110306_p());
                if (texture instanceof ThreadDownloadImageData) {
                    image = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)((ThreadDownloadImageData)texture), (String[])new String[]{"field_110560_d", "bufferedImage"});
                    break block7;
                }
                if (texture instanceof DynamicTexture) {
                    int width = (Integer)ObfuscationReflectionHelper.getPrivateValue(DynamicTexture.class, (Object)((DynamicTexture)texture), (String[])new String[]{"field_94233_j", "width"});
                    int height = (Integer)ObfuscationReflectionHelper.getPrivateValue(DynamicTexture.class, (Object)((DynamicTexture)texture), (String[])new String[]{"field_94234_k", "height"});
                    image = new BufferedImage(width, height, 2);
                    image.setRGB(0, 0, width, height, ((DynamicTexture)texture).func_110565_c(), 0, width);
                    break block7;
                }
                BufferedImage width = null;
                return width;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(steveInputStream);
            }
        }
        return image;
    }

    private static ResourceLocation createResourceLocation(AbstractClientPlayer player) {
        return new ResourceLocation("thebetweenlands", "skins_madj/" + player.func_110306_p().hashCode());
    }

    private static void mirrorLimb(int[] pixels, int sx, int sy, int dx, int dy) {
        PlayerLimbPreMirrorer.mirrorX(pixels, sx + 4, sy, dx + 4, dy, 8, 4);
        PlayerLimbPreMirrorer.mirrorY(pixels, sx, sy + 4, dx, dy + 4, 12, 12);
        PlayerLimbPreMirrorer.mirrorY(pixels, sx + 12, sy + 4, dx + 12, dy + 4, 4, 12);
    }

    private static void mirrorY(int[] pixels, int sx, int sy, int dx, int dy, int width, int height) {
        for (int y = 0; y < height; ++y) {
            int si = sx + (sy + y) * 64;
            int di = dx + (dy + y) * 64;
            int x = 0;
            int mx = width - 1;
            while (x < width) {
                pixels[di + mx] = pixels[si + x];
                ++x;
                --mx;
            }
        }
    }

    private static void mirrorX(int[] pixels, int sx, int sy, int dx, int dy, int width, int height) {
        int y = 0;
        int my = height - 1;
        while (y < height) {
            int si = sx + (sy + y) * 64;
            int di = dx + (dy + my) * 64;
            for (int x = 0; x < width; ++x) {
                pixels[di + x] = pixels[si + x];
            }
            ++y;
            --my;
        }
    }
}

