/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.perspective.rowboat;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.input.WeedwoodRowboatHandler;
import thebetweenlands.client.perspective.Perspective;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class PerspectiveWeedwoodRowboatThirdPerson
extends Perspective {
    private float prevYaw;
    private float yaw;
    private float prevPitch;
    private float pitch;

    @Override
    protected boolean canCycleTo(Perspective perspective) {
        return perspective == WeedwoodRowboatHandler.FIRST_PERSON_PERSPECTIVE;
    }

    @Override
    protected boolean canCycleFrom(Perspective perspective) {
        return WeedwoodRowboatHandler.INSTANCE.isPlayerInRowboat();
    }

    @Override
    protected void onCycleTo() {
        ConfigHandler.rowboatView = true;
        ConfigHandler.INSTANCE.save();
    }

    @Override
    protected void onChangeTo() {
        GuiIngameForge.renderCrosshairs = false;
    }

    @Override
    protected void onChangeOff() {
        GuiIngameForge.renderCrosshairs = true;
    }

    @Override
    protected void applyMovement(Entity entity, float x, float y) {
        float currentPitch = this.pitch;
        float currentYaw = this.yaw;
        this.yaw += x * 0.15f;
        this.pitch -= y * 0.15f;
        if (this.pitch < 0.0f) {
            this.pitch = 0.0f;
        }
        if (this.pitch > 90.0f) {
            this.pitch = 90.0f;
        }
        this.prevPitch += this.pitch - currentPitch;
        this.prevYaw += this.yaw - currentYaw;
    }

    @Override
    protected void orient(Minecraft mc, World world, EntityRenderer entityRenderer, EntityLivingBase viewer, double x, double y, double z, float viewerYaw, float viewerPitch, float delta) {
        float yaw = this.prevYaw + (this.yaw - this.prevYaw) * delta;
        float pitch = this.prevPitch + (this.pitch - this.prevPitch) * delta;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-this.getDistance(world, x, y, z, yaw, pitch))));
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(yaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private double getDistance(World world, double x, double y, double z, float yaw, float pitch) {
        double extent = 5.0;
        float cosPitch = MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        double extentX = (double)(-MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * cosPitch) * extent;
        double extentZ = (double)(MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * cosPitch) * extent;
        double extentY = (double)(-MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)))) * extent;
        for (int zyx = 0; zyx < 8; ++zyx) {
            double distance;
            float dx = (float)((zyx & 1) * 2 - 1) * 0.1f;
            float dy = (float)((zyx >> 1 & 1) * 2 - 1) * 0.1f;
            float dz = (float)((zyx >> 2 & 1) * 2 - 1) * 0.1f;
            MovingObjectPosition vector = world.func_72933_a(Vec3.func_72443_a((double)(x + (double)dx), (double)(y + (double)dy), (double)(z + (double)dz)), Vec3.func_72443_a((double)(x - extentX + (double)dx), (double)(y - extentY + (double)dy), (double)(z - extentZ + (double)dz)));
            if (vector == null || !((distance = vector.field_72307_f.func_72438_d(Vec3.func_72443_a((double)x, (double)y, (double)z))) < extent)) continue;
            extent = distance;
        }
        return extent;
    }

    @SubscribeEvent
    protected void update(TickEvent.ClientTickEvent event) {
        if (PerspectiveWeedwoodRowboatThirdPerson.getCurrentPerspective() == this && event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.yaw > 180.0f) {
            this.yaw -= 360.0f;
        }
        if (this.yaw < -180.0f) {
            this.yaw += 360.0f;
        }
        if (this.pitch > 180.0f) {
            this.pitch -= 360.0f;
        }
        if (this.pitch < -180.0f) {
            this.pitch += 360.0f;
        }
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
    }

    @Override
    protected Perspective getPerspectiveForOpaqueBlockView() {
        return WeedwoodRowboatHandler.FIRST_PERSON_PERSPECTIVE;
    }
}

