/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.perspective.rowboat;

import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import thebetweenlands.client.input.WeedwoodRowboatHandler;
import thebetweenlands.client.perspective.Perspective;
import thebetweenlands.client.perspective.PerspectiveFirstPerson;
import thebetweenlands.utils.MathUtils;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class PerspectiveWeedwoodRowboatFirstPerson
extends PerspectiveFirstPerson {
    @Override
    protected boolean canCycleTo(Perspective perspective) {
        return perspective == WeedwoodRowboatHandler.THIRD_PERSON_PERSPECTIVE;
    }

    @Override
    protected boolean canCycleFrom(Perspective perspective) {
        return WeedwoodRowboatHandler.INSTANCE.isPlayerInRowboat();
    }

    @Override
    protected void onCycleTo() {
        ConfigHandler.rowboatView = false;
        ConfigHandler.INSTANCE.save();
    }

    @Override
    protected void applyMovement(Entity entity, float x, float y) {
        if (entity.field_70154_o == null) {
            return;
        }
        float yawLimit = 135.0f;
        float yawResistance = 45.0f;
        float currentPitch = entity.field_70125_A;
        float currentYaw = MathHelper.func_76142_g((float)entity.field_70177_z);
        float rowboatYawOffset = MathHelper.func_76142_g((float)(entity.field_70154_o.field_70177_z - 90.0f));
        float relativeYaw = MathHelper.func_76142_g((float)(currentYaw - rowboatYawOffset));
        float scaleX = 0.15f;
        float scaleY = 0.15f;
        float distanceToLimit = Math.abs(135.0f - Math.abs(relativeYaw));
        if (distanceToLimit < 45.0f) {
            if (x * relativeYaw > 0.0f) {
                scaleX *= distanceToLimit / 45.0f;
            }
            scaleY = scaleY * distanceToLimit / 45.0f * 0.7f + scaleY * 0.3f;
        }
        entity.field_70177_z += x * scaleX;
        entity.field_70125_A -= y * scaleY;
        float pitchLimit = 90.0f;
        if (entity.field_70125_A > 90.0f) {
            entity.field_70125_A = 90.0f;
        }
        if (entity.field_70125_A < -90.0f) {
            entity.field_70125_A = -90.0f;
        }
        entity.field_70177_z -= rowboatYawOffset;
        entity.field_70177_z = MathHelper.func_76142_g((float)entity.field_70177_z);
        if (entity.field_70177_z > 135.0f) {
            entity.field_70177_z = 135.0f;
        }
        if (entity.field_70177_z < -135.0f) {
            entity.field_70177_z = -135.0f;
        }
        entity.field_70177_z += rowboatYawOffset;
        entity.field_70126_B = MathUtils.adjustAngleForInterpolation(entity.field_70177_z, entity.field_70126_B);
    }

    @Override
    protected Perspective getPerspectiveForOpaqueBlockView() {
        return this;
    }
}

