/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.perspective;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.perspective.PerspectiveFirstPerson;

public class PerspectiveThirdPerson
extends PerspectiveFirstPerson {
    private static RayTracer rayTracer = PerspectiveThirdPerson.createRayTracer();

    @Override
    protected final void orient(World world, EntityLivingBase viewer, double x, double y, double z, float yaw, float pitch) {
        double extent = 4.0;
        if (this.isFrontFacing()) {
            pitch += 180.0f;
        }
        double extentX = (double)(-MathHelper.func_76126_a((float)(yaw / 57.295776f)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * extent;
        double extentZ = (double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * extent;
        double extentY = (double)(-MathHelper.func_76126_a((float)(pitch / 180.0f * (float)Math.PI))) * extent;
        for (int zyx = 0; zyx < 8; ++zyx) {
            double dist;
            float dx = (float)((zyx & 1) * 2 - 1) * 0.1f;
            float dy = (float)((zyx >> 1 & 1) * 2 - 1) * 0.1f;
            float dz = (float)((zyx >> 2 & 1) * 2 - 1) * 0.1f;
            MovingObjectPosition movingobjectposition = PerspectiveThirdPerson.rayTrace(world, Vec3.func_72443_a((double)(x + (double)dx), (double)(y + (double)dy), (double)(z + (double)dz)), Vec3.func_72443_a((double)(x - extentX + (double)dx), (double)(y - extentY + (double)dy), (double)(z - extentZ + (double)dz)));
            if (movingobjectposition == null || !((dist = movingobjectposition.field_72307_f.func_72438_d(Vec3.func_72443_a((double)x, (double)y, (double)z))) < extent)) continue;
            extent = dist;
        }
        if (this.isFrontFacing()) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)(viewer.field_70125_A - pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(viewer.field_70177_z - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-extent)));
        GL11.glRotatef((float)(yaw - viewer.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(pitch - viewer.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected boolean isFrontFacing() {
        return false;
    }

    @Override
    public boolean shouldRenderPlayer() {
        return true;
    }

    private static RayTracer createRayTracer() {
        RayTracer factorizationBoxTrace = null;
        if (Loader.isModLoaded((String)"factorization")) {
            try {
                Class<?> hookTargetsClient = Class.forName("factorization.coremodhooks.HookTargetsClient");
                factorizationBoxTrace = new RayTracerFactorization(hookTargetsClient.getMethod("boxTrace", World.class, Vec3.class, Vec3.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factorizationBoxTrace == null ? new RayTracerNormal() : factorizationBoxTrace;
    }

    private static MovingObjectPosition rayTrace(World world, Vec3 start, Vec3 end) {
        MovingObjectPosition result;
        try {
            result = rayTracer.rayTrace(world, start, end);
        }
        catch (Exception e) {
            rayTracer = new RayTracerNormal();
            try {
                result = rayTracer.rayTrace(world, start, end);
            }
            catch (Exception notGonnaHappen) {
                throw new RuntimeException(notGonnaHappen);
            }
        }
        return result;
    }

    private static class RayTracerFactorization
    implements RayTracer {
        private Method boxTrace;

        public RayTracerFactorization(Method boxTrace) {
            this.boxTrace = boxTrace;
        }

        @Override
        public MovingObjectPosition rayTrace(World world, Vec3 start, Vec3 end) throws Exception {
            return (MovingObjectPosition)this.boxTrace.invoke(null, world, start, end);
        }
    }

    private static class RayTracerNormal
    implements RayTracer {
        private RayTracerNormal() {
        }

        @Override
        public MovingObjectPosition rayTrace(World world, Vec3 start, Vec3 end) {
            return world.func_72933_a(start, end);
        }
    }

    private static interface RayTracer {
        public MovingObjectPosition rayTrace(World var1, Vec3 var2, Vec3 var3) throws Exception;
    }
}

