/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.perspective;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.util.glu.GLU;
import thebetweenlands.client.perspective.PerspectiveFirstPerson;
import thebetweenlands.client.perspective.PerspectiveThirdPerson;
import thebetweenlands.client.perspective.PerspectiveThirdPersonFront;

public abstract class Perspective {
    private static final List<Perspective> PERSPECTIVES = new ArrayList<Perspective>();
    public static final Perspective FIRST_PERSON = new PerspectiveFirstPerson();
    public static final Perspective THIRD_PERSON = new PerspectiveThirdPerson();
    public static final Perspective THIRD_PERSON_FRONT = new PerspectiveThirdPersonFront();
    private static float yaw;
    private static float pitch;
    private static int currentPerspective;
    private int id;
    private boolean doesRenderPlayer = this.shouldRenderPlayer();

    private void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean shouldRenderPlayer() {
        return true;
    }

    protected boolean canCycleFrom(Perspective perspective) {
        return true;
    }

    protected void applyMovement(Entity entity, float x, float y) {
    }

    protected void orient(Minecraft mc, World world, EntityRenderer entityRenderer, EntityLivingBase viewer, double x, double y, double z, float yaw, float pitch, float delta) {
    }

    protected boolean canCycleTo(Perspective perspective) {
        return true;
    }

    protected void onCycleTo() {
    }

    protected void onCycleOff() {
    }

    protected void onChangeTo() {
    }

    protected void onChangeOff() {
    }

    public final void switchTo() {
        Perspective.switchTo(this);
    }

    public final boolean doesRenderPlayer() {
        return this.doesRenderPlayer;
    }

    public final boolean isCurrentPerspective() {
        return this == Perspective.getCurrentPerspective();
    }

    public static Perspective getCurrentPerspective() {
        return Perspective.getPerspective(Perspective.getCurrentPerspectiveId());
    }

    public static int getCurrentPerspectiveId() {
        return currentPerspective;
    }

    public static Perspective getPerspective(int view) {
        int viewCount = PERSPECTIVES.size();
        if (view < 0 || view >= viewCount) {
            throw new IllegalStateException(String.format("The view (%s) is an invalid camera view ordinal, should be in range [0,%s]. I can't believe you've done this.", view, viewCount - 1));
        }
        return PERSPECTIVES.get(view);
    }

    public static void register(Perspective perspective) {
        perspective.setId(PERSPECTIVES.size());
        PERSPECTIVES.add(perspective);
    }

    public static void updateRenderInfo(float winx, float winz, FloatBuffer modelview, FloatBuffer projection, IntBuffer viewport, FloatBuffer objectCoords) {
        GLU.gluUnProject((float)winx, (float)winz, (float)1.0f, (FloatBuffer)modelview, (FloatBuffer)projection, (IntBuffer)viewport, (FloatBuffer)objectCoords);
        float lookVecX = objectCoords.get(0) - ActiveRenderInfo.field_74592_a;
        float lookVecY = objectCoords.get(1) - ActiveRenderInfo.field_74590_b;
        float lookVecZ = objectCoords.get(2) - ActiveRenderInfo.field_74591_c;
        float frustumDepth = MathHelper.func_76129_c((float)(lookVecX * lookVecX + lookVecY * lookVecY + lookVecZ * lookVecZ));
        lookVecY /= frustumDepth;
        yaw = (float)(Math.atan2(lookVecZ /= frustumDepth, lookVecX /= frustumDepth) - 1.5707963267948966);
        if ((double)yaw < -Math.PI) {
            yaw = (float)((double)yaw + Math.PI * 2);
        }
        pitch = (float)(-Math.atan2(lookVecY, Math.sqrt(lookVecX * lookVecX + lookVecZ * lookVecZ)));
        float sinPitch = MathHelper.func_76126_a((float)pitch);
        ActiveRenderInfo.field_74588_d = MathHelper.func_76134_b((float)yaw);
        ActiveRenderInfo.field_74586_f = MathHelper.func_76126_a((float)yaw);
        ActiveRenderInfo.field_74587_g = -ActiveRenderInfo.field_74586_f * sinPitch;
        ActiveRenderInfo.field_74596_h = ActiveRenderInfo.field_74588_d * sinPitch;
        ActiveRenderInfo.field_74589_e = MathHelper.func_76134_b((float)pitch);
    }

    public static boolean orient(float delta) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase viewer = mc.field_71451_h;
        double x = viewer.field_70169_q + (viewer.field_70165_t - viewer.field_70169_q) * (double)delta;
        double y = viewer.field_70167_r + (viewer.field_70163_u - viewer.field_70167_r) * (double)delta;
        double z = viewer.field_70166_s + (viewer.field_70161_v - viewer.field_70166_s) * (double)delta;
        float yaw = viewer.field_70126_B + (viewer.field_70177_z - viewer.field_70126_B) * delta;
        float pitch = viewer.field_70127_C + (viewer.field_70125_A - viewer.field_70127_C) * delta;
        Perspective.getCurrentPerspective().orient(mc, (World)mc.field_71441_e, mc.field_71460_t, viewer, x, y, z, yaw, pitch, delta);
        return mc.field_71438_f.func_72721_a(x, y, z, delta);
    }

    public static int getInsideOpaqueBlockView() {
        Perspective perspective = Perspective.getCurrentPerspective();
        Perspective newPerspective = perspective.getPerspectiveForOpaqueBlockView();
        if (newPerspective == null) {
            newPerspective = perspective;
        }
        Perspective.changeTo(newPerspective);
        return newPerspective.doesRenderPlayer() ? currentPerspective : 0;
    }

    protected Perspective getPerspectiveForOpaqueBlockView() {
        return FIRST_PERSON;
    }

    public static int cyclePerspective() {
        int currentView = Perspective.getCurrentPerspectiveId();
        Perspective perspective = Perspective.getPerspective(currentView);
        for (int i = 1; i < PERSPECTIVES.size(); ++i) {
            Perspective candidate = Perspective.getPerspective((currentView + i) % PERSPECTIVES.size());
            if (!perspective.canCycleTo(candidate) || !candidate.canCycleFrom(perspective)) continue;
            candidate.onCycleTo();
            perspective.onCycleOff();
            perspective = candidate;
            break;
        }
        return Perspective.cycleTo(perspective);
    }

    public static void switchTo(Perspective perspective) {
        Perspective.changeTo(perspective);
        Minecraft.func_71410_x().field_71474_y.field_74320_O = perspective.doesRenderPlayer() ? currentPerspective : 0;
    }

    public static int cycleTo(Perspective perspective) {
        Perspective.changeTo(perspective);
        return perspective.doesRenderPlayer() ? perspective.getId() : 0;
    }

    private static void changeTo(Perspective perspective) {
        Perspective.getCurrentPerspective().onChangeOff();
        perspective.onChangeTo();
        currentPerspective = perspective.getId();
    }

    public static void cacheActiveRenderInfo() {
        RenderManager renderManager = RenderManager.field_78727_a;
        renderManager.field_78735_i = yaw * 57.29578f;
        renderManager.field_78732_j = pitch * 57.29578f;
        renderManager.field_78730_l += (double)ActiveRenderInfo.field_74592_a;
        renderManager.field_78731_m += (double)ActiveRenderInfo.field_74590_b;
        renderManager.field_78728_n += (double)ActiveRenderInfo.field_74591_c;
        TileEntityRendererDispatcher dispatcher = TileEntityRendererDispatcher.field_147556_a;
        dispatcher.field_147562_h = renderManager.field_78735_i;
        dispatcher.field_147563_i = renderManager.field_78732_j;
        dispatcher.field_147560_j = renderManager.field_78730_l;
        dispatcher.field_147561_k = renderManager.field_78731_m;
        dispatcher.field_147558_l = renderManager.field_78728_n;
    }

    public static void setAngles(Entity entity, float x, float y) {
        Perspective.getCurrentPerspective().applyMovement(entity, x, y);
    }

    static {
        Perspective.register(FIRST_PERSON);
        Perspective.register(THIRD_PERSON);
        Perspective.register(THIRD_PERSON_FRONT);
    }
}

