/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.client.particle.ParticleArgs;
import thebetweenlands.entities.particles.EntityAltarCraftingFX;
import thebetweenlands.entities.particles.EntityBLBubbleFX;
import thebetweenlands.entities.particles.EntityBugFX;
import thebetweenlands.entities.particles.EntityCaveWaterDripFX;
import thebetweenlands.entities.particles.EntityDruidCastingFX;
import thebetweenlands.entities.particles.EntityLeafFX;
import thebetweenlands.entities.particles.EntityLeafSwirlFX;
import thebetweenlands.entities.particles.EntityPortalFX;
import thebetweenlands.entities.particles.EntitySplashFX;
import thebetweenlands.entities.particles.EntityTarBeastDrip;
import thebetweenlands.entities.particles.EntityWeedWoodRustleFX;
import thebetweenlands.tileentities.TileEntityDruidAltar;

@SideOnly(value=Side.CLIENT)
public enum BLParticle {
    DRUID_MAGIC(EntityDruidCastingFX.class, ParticleArgs.VX_VY_VZ_SCALE, new Class[0]),
    DRUID_MAGIC_BIG(EntityDruidCastingFX.class, 0.0f, 1.0f, 1.0f, ParticleArgs.VX_VY_VZ_SCALE, new Class[0]),
    ALTAR_CRAFTING((Class)EntityAltarCraftingFX.class, ParticleArgs.SCALE, new Class[]{TileEntityDruidAltar.class}){

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{data[0]};
        }
    }
    ,
    SMOKE(EntitySmokeFX.class),
    SWAMP_SMOKE(EntitySmokeFX.class, 45.0f, 66.0f, 49.0f),
    FLAME(EntityFlameFX.class),
    GREEN_FLAME(EntityFlameFX.class, 0.176f, 0.259f, 0.192f),
    SULFUR_TORCH(EntitySmokeFX.class, 1.0f, 0.9294f, 0.0f, ParticleArgs.V0_V0_V0, new Class[0]),
    SULFUR_ORE(EntitySpellParticleFX.class, 1.0f, 0.9294f, 0.0f),
    SNAIL_POSION(EntitySpellParticleFX.class, 1.0f, 0.0f, 0.0f),
    DIRT_DECAY(EntitySpellParticleFX.class, 0.306f, 0.576f, 0.192f),
    BUBBLE_PRUIFIER(EntityBLBubbleFX.class, 0.306f, 0.576f, 0.192f),
    BUBBLE_INFUSION((Class)EntityBLBubbleFX.class, 0.5f, 0.0f, 0.125f){

        @Override
        protected void onSpawn(EntityFX entityFX) {
            entityFX.func_82338_g(0.5f);
        }
    }
    ,
    BUBBLE_TAR_BEAST(EntityBLBubbleFX.class, 0.0f, 0.0f, 0.0f),
    SPLASH_TAR_BEAST((Class)EntityBreakingFX.class, 0.0f, 0.0f, 0.0f, ParticleArgs.VX_VY_VZ, new Class[]{Item.class, Integer.TYPE}){

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{Items.field_151123_aH, 0};
        }
    }
    ,
    DRIP_TAR_BEAST(EntityTarBeastDrip.class, 0.0f, 0.0f, 0.0f),
    STEAM_PURIFIER(EntitySmokeFX.class, 1.0f, 1.0f, 1.0f, ParticleArgs.V0_V0_V0, new Class[0]),
    PORTAL((Class)EntityPortalFX.class, ParticleArgs.VX_VY_VZ, new Class[]{Integer.TYPE, Float.TYPE, Integer.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/particle/portal.png");

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{20, Float.valueOf(0.18f * world.field_73012_v.nextFloat()), -1, this.texture, 6};
        }
    }
    ,
    MOTH((Class)EntityBugFX.class, ParticleArgs.NONE, new Class[]{Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/particle/moth1.png"), new ResourceLocation("thebetweenlands:textures/particle/moth2.png")};

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{400, Float.valueOf(0.02f), Float.valueOf(0.005f), Float.valueOf(0.18f * world.field_73012_v.nextFloat()), -1, false, this.textures[world.field_73012_v.nextInt(this.textures.length)], 2};
        }
    }
    ,
    FISH((Class)EntityBugFX.class, ParticleArgs.NONE, new Class[]{Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/particle/fish1.png"), new ResourceLocation("thebetweenlands:textures/particle/fish2.png"), new ResourceLocation("thebetweenlands:textures/particle/fish3.png")};

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{400, Float.valueOf(0.02f), Float.valueOf(0.005f), Float.valueOf(0.18f * world.field_73012_v.nextFloat()), -1, true, this.textures[world.field_73012_v.nextInt(this.textures.length)], 1};
        }
    }
    ,
    FLY((Class)EntityBugFX.class, ParticleArgs.NONE, new Class[]{Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/particle/fly.png");

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{400, Float.valueOf(0.05f), Float.valueOf(0.025f), Float.valueOf(0.06f * world.field_73012_v.nextFloat()), -1, false, this.texture, 2};
        }
    }
    ,
    MOSQUITO((Class)EntityBugFX.class, ParticleArgs.NONE, new Class[]{Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/particle/mosquito.png");

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{400, Float.valueOf(0.05f), Float.valueOf(0.025f), Float.valueOf(0.1f * world.field_73012_v.nextFloat()), -1, false, this.texture, 2};
        }
    }
    ,
    WATER_BUG((Class)EntityBugFX.class, ParticleArgs.NONE, new Class[]{Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/particle/waterbug.png");

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{400, Float.valueOf(0.03f), Float.valueOf(0.002f), Float.valueOf(0.2f * world.field_73012_v.nextFloat()), -1, true, this.texture, 2};
        }
    }
    ,
    LEAF((Class)EntityLeafFX.class, ParticleArgs.NONE, new Class[]{Integer.TYPE, Float.TYPE, Integer.TYPE, ResourceLocation.class, Integer.TYPE}){
        private final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/particle/leaf.png");

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{400, Float.valueOf(0.12f * world.field_73012_v.nextFloat() + 0.03f), -1, this.texture, 5};
        }
    }
    ,
    LEAF_SWIRL((Class)EntityLeafSwirlFX.class, ParticleArgs.NONE, new Class[]{Integer.TYPE, Float.TYPE, Integer.TYPE, ResourceLocation.class, Integer.TYPE, Entity.class, Float.TYPE}){
        private final ResourceLocation texture = new ResourceLocation("thebetweenlands:textures/particle/leaf.png");

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{400, Float.valueOf(0.12f * world.field_73012_v.nextFloat() + 0.03f), -1, this.texture, 5, (Entity)data[0], Float.valueOf(((Float)data[1]).floatValue())};
        }
    }
    ,
    SPLASH((Class)EntitySplashFX.class, ParticleArgs.VX_VY_VZ, new Class[]{Integer.TYPE}){

        @Override
        protected Object[] getAdditionalArgs(World world, Object ... data) {
            return new Object[]{data.length == 0 || !(data[0] instanceof Integer) ? 0xFFFFFF : (Integer)data[0]};
        }
    }
    ,
    CAVE_WATER_DRIP(EntityCaveWaterDripFX.class, ParticleArgs.NONE, new Class[0]),
    RUSTLE_LEAF(EntityWeedWoodRustleFX.class, ParticleArgs.NONE, new Class[0]);

    private static final int REGULAR_ARG_NUM = 4;
    private Constructor<? extends EntityFX> constructor;
    private ParticleArgs args;
    private Class<?>[] additionalArgTypes;
    private boolean shouldAssignColor = false;
    private float r;
    private float g;
    private float b;

    private BLParticle(Class<? extends EntityFX> fxClass) {
        this(fxClass, -1.0f, 57005.0f, 49374.0f);
    }

    private BLParticle(Class<? extends EntityFX> fxClass, float r, float g, float b) {
        this(fxClass, r, g, b, ParticleArgs.VX_VY_VZ, new Class[0]);
    }

    private BLParticle(Class<? extends EntityFX> fxClass, ParticleArgs args, Class<?> ... additionalArgTypes) {
        this(fxClass, -1.0f, 57005.0f, 49374.0f, args, additionalArgTypes);
    }

    private BLParticle(Class<? extends EntityFX> fxClass, float r, float g, float b, ParticleArgs args, Class<?> ... additionalArgTypes) {
        if (r != -1.0f) {
            this.shouldAssignColor = true;
            this.r = r;
            this.g = g;
            this.b = b;
        }
        try {
            this.constructor = fxClass.getConstructor(BLParticle.getArgumentTypes(args, additionalArgTypes));
        }
        catch (Exception e) {
            CrashReport crash = CrashReport.func_85055_a((Throwable)e, (String)"Constructing BLParticle");
            CrashReportCategory categoryArguments = crash.func_85058_a("Arguments");
            categoryArguments.func_71507_a("Class", fxClass);
            categoryArguments.func_71507_a("Particle Arg Types", (Object)args);
            categoryArguments.func_71507_a("Additional Arg Types", (Object)Arrays.toString(additionalArgTypes));
            throw new ReportedException(crash);
        }
        this.args = args;
        this.additionalArgTypes = additionalArgTypes;
    }

    private static Class<?>[] getArgumentTypes(ParticleArgs args, Class<?>[] additionalArgTypes) {
        Class[] argumentTypes = new Class[4 + args.getArgumentCount() + additionalArgTypes.length];
        argumentTypes[0] = World.class;
        argumentTypes[1] = Double.TYPE;
        argumentTypes[2] = Double.TYPE;
        argumentTypes[3] = Double.TYPE;
        System.arraycopy(args.getArgumentTypes(), 0, argumentTypes, 4, args.getArgumentCount());
        System.arraycopy(additionalArgTypes, 0, argumentTypes, 4 + args.getArgumentCount(), additionalArgTypes.length);
        return argumentTypes;
    }

    protected Object[] getAdditionalArgs(World world, Object ... data) {
        return new Object[0];
    }

    protected void onSpawn(EntityFX entityFX) {
    }

    public final void spawn(World world, double x, double y, double z) {
        this.spawn(world, x, y, z, 0.0, 0.0, 0.0, 1.0f, new Object[0]);
    }

    public final void spawn(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, Object ... data) {
        Object[] arguments = this.getArguments(world, x, y, z, motionX, motionY, motionZ, scale, data);
        try {
            EntityFX entityFX = this.constructor.newInstance(arguments);
            if (this.shouldAssignColor) {
                entityFX.func_70538_b(this.r, this.g, this.b);
            }
            this.onSpawn(entityFX);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(entityFX);
        }
        catch (Exception e) {
            CrashReport crash = CrashReport.func_85055_a((Throwable)e, (String)"Constructing EntityFX");
            CrashReportCategory categorySpawnArguments = crash.func_85058_a("Spawn Arguments");
            categorySpawnArguments.func_71507_a("World", (Object)world);
            categorySpawnArguments.func_71507_a("X", (Object)x);
            categorySpawnArguments.func_71507_a("Y", (Object)y);
            categorySpawnArguments.func_71507_a("Z", (Object)z);
            categorySpawnArguments.func_71507_a("Motion X", (Object)motionX);
            categorySpawnArguments.func_71507_a("Motion Y", (Object)motionY);
            categorySpawnArguments.func_71507_a("Motion Z", (Object)motionZ);
            categorySpawnArguments.func_71507_a("Scale", (Object)Float.valueOf(scale));
            categorySpawnArguments.func_71507_a("Data", (Object)Arrays.deepToString(data));
            CrashReportCategory categoryBLParticle = crash.func_85058_a("BLParticle");
            categoryBLParticle.func_71507_a("Constructor", this.constructor);
            categoryBLParticle.func_71507_a("Particle Arg Types", (Object)this.args);
            categoryBLParticle.func_71507_a("Additional Arg Types", (Object)Arrays.toString(this.additionalArgTypes));
            CrashReportCategory categoryArguments = crash.func_85058_a("Arguments");
            categoryArguments.func_71507_a("Arguments", (Object)Arrays.deepToString(arguments));
            throw new ReportedException(crash);
        }
    }

    private Object[] getArguments(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, Object ... data) {
        Object[] particleArgs = this.args.getArguments(motionX, motionY, motionZ, scale);
        Object[] additionalArgs = this.getAdditionalArgs(world, data);
        Object[] arguments = new Object[4 + this.args.getArgumentCount() + additionalArgs.length];
        arguments[0] = world;
        arguments[1] = x;
        arguments[2] = y;
        arguments[3] = z;
        System.arraycopy(particleArgs, 0, arguments, 4, this.args.getArgumentCount());
        System.arraycopy(additionalArgs, 0, arguments, 4 + this.args.getArgumentCount(), additionalArgs.length);
        return arguments;
    }
}

