/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.model.block;

import java.util.EnumMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import thebetweenlands.client.model.AdvancedModelRenderer;
import thebetweenlands.client.model.ModelBipedLimb;
import thebetweenlands.client.model.ModelBoxCustomizable;
import thebetweenlands.entities.rowboat.ShipSide;

public class ModelPlayerRower
extends ModelBiped {
    private EnumMap<ShipSide, ModelBipedLimb> arms;
    private ModelRenderer leftForearm;
    private ModelRenderer rightForearm;

    public ModelPlayerRower(float expand) {
        super(expand, 0.0f, 64, expand == 0.0f ? 64 : 32);
        this.field_78092_r.remove(this.field_78115_e.field_78804_l.remove(0));
        this.field_78115_e = new AdvancedModelRenderer((ModelBase)this, 16, 16);
        this.field_78115_e.func_78793_a(0.0f, 12.0f, 0.0f);
        this.field_78115_e.func_78790_a(-4.0f, -12.0f, -2.0f, 8, 12, 4, expand);
        this.field_78116_c.func_78793_a(0.0f, -12.0f, 0.0f);
        this.field_78092_r.remove(this.field_78116_c.field_78804_l.remove(0));
        this.field_78116_c.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, expand + 0.025f);
        this.field_78115_e.func_78792_a(this.field_78116_c);
        this.field_78114_d.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_78092_r.remove(this.field_78114_d.field_78804_l.remove(0));
        this.field_78114_d.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, expand + 0.525f);
        this.field_78116_c.func_78792_a(this.field_78114_d);
        this.field_78092_r.remove(this.field_78121_j.field_78804_l.remove(0));
        this.field_78112_f.field_78797_d = this.field_78113_g.field_78797_d = -10.0f;
        if (expand == 0.0f) {
            this.arms = ShipSide.newEnumMap(ModelBipedLimb.class, new ModelBipedLimb[0]);
            ModelBipedLimb left = this.createReplacementLimb(this.field_78113_g, 40, 16);
            this.field_78113_g = left;
            this.arms.put(ShipSide.STARBOARD, left);
            ModelBipedLimb right = this.createReplacementLimb(this.field_78112_f, 32, 48);
            this.field_78112_f = right;
            this.arms.put(ShipSide.PORT, right);
        } else {
            this.field_78113_g = this.createExpandReplacementLimb(this.field_78113_g, 40, 16, expand);
            this.field_78112_f = this.createExpandReplacementLimb(this.field_78112_f, 40, 16, expand);
        }
        this.field_78123_h.field_78795_f = -1.2566371f;
        this.field_78123_h.field_78796_g = 0.31415927f;
        this.field_78123_h.field_78798_e = 0.1f;
        this.field_78123_h.field_78797_d = 12.0f;
        this.field_78124_i.field_78795_f = -1.2566371f;
        this.field_78124_i.field_78796_g = -0.31415927f;
        this.field_78124_i.field_78798_e = 0.1f;
        this.field_78124_i.field_78797_d = 12.0f;
    }

    private ModelBipedLimb createReplacementLimb(ModelRenderer oldLimb, int textureOffsetX, int textureOffsetY) {
        ModelBipedLimb limb = new ModelBipedLimb((ModelBase)this, textureOffsetX, textureOffsetY);
        limb.func_78793_a(Math.signum(oldLimb.field_78800_c) * 6.0f, oldLimb.field_78797_d, oldLimb.field_78798_e);
        this.field_78092_r.remove(oldLimb.field_78804_l.remove(0));
        limb.field_82906_o = -2.0f;
        limb.field_82908_p = -2.0f;
        limb.field_82907_q = -2.0f;
        this.field_78115_e.func_78792_a((ModelRenderer)limb);
        return limb;
    }

    private ModelRenderer createExpandReplacementLimb(ModelRenderer oldLimb, int textureOffsetX, int textureOffsetY, float expand) {
        ModelRenderer limb = new ModelRenderer((ModelBase)this, textureOffsetX, textureOffsetY);
        this.field_78115_e.func_78792_a(limb);
        limb.field_78809_i = oldLimb.field_78809_i;
        ModelBox box = (ModelBox)oldLimb.field_78804_l.remove(0);
        this.field_78092_r.remove(box);
        ModelBoxCustomizable arm = new ModelBoxCustomizable(limb, textureOffsetX, textureOffsetY, -2.0f, -2.0f, -2.0f, 4, 6, 4, expand);
        arm.setVisibleSides(-9);
        limb.field_78804_l.add(arm);
        limb.func_78793_a(Math.signum(oldLimb.field_78800_c) * 6.0f, oldLimb.field_78797_d, oldLimb.field_78798_e);
        ModelRenderer lowerLimb = new ModelRenderer((ModelBase)this, textureOffsetX, textureOffsetY - 6);
        if (this.field_78113_g == oldLimb) {
            this.leftForearm = lowerLimb;
        } else {
            this.rightForearm = lowerLimb;
        }
        lowerLimb.field_78809_i = oldLimb.field_78809_i;
        lowerLimb.func_78793_a(0.0f, box.field_78250_b + 6.0f, box.field_78251_c + 2.0f);
        ModelBoxCustomizable forearm = new ModelBoxCustomizable(lowerLimb, textureOffsetX, textureOffsetY + 6, -2.0f, 0.0f, -2.0f, 4, 6, 4, expand * 0.75f, -6);
        forearm.setVisibleSides(-5);
        lowerLimb.field_78804_l.add(forearm);
        limb.func_78792_a(lowerLimb);
        return limb;
    }

    public ModelRenderer getArm(ShipSide side) {
        return this.arms.get((Object)side);
    }

    public void setLeftArmFlexionAngle(float flexionAngle) {
        if (this.arms == null) {
            this.leftForearm.field_78795_f = flexionAngle * ((float)Math.PI / 180);
        } else {
            this.arms.get((Object)ShipSide.STARBOARD).setFlexionAngle(flexionAngle);
        }
    }

    public void setRightArmFlexionAngle(float flexionAngle) {
        if (this.arms == null) {
            this.rightForearm.field_78795_f = flexionAngle * ((float)Math.PI / 180);
        } else {
            this.arms.get((Object)ShipSide.PORT).setFlexionAngle(flexionAngle);
        }
    }

    public void func_78088_a(Entity entity, float swing, float speed, float ticksExisted, float yaw, float pitch, float scale) {
        this.func_78087_a(speed, swing, ticksExisted, yaw, pitch, scale, entity);
        this.field_78115_e.func_78785_a(scale);
        this.field_78123_h.func_78785_a(scale);
        this.field_78124_i.func_78785_a(scale);
    }

    public void func_78110_b(float scale) {
    }

    public void func_78087_a(float speed, float swing, float ticksExisted, float yaw, float pitch, float scale, Entity entity) {
        this.field_78116_c.field_78795_f += pitch * ((float)Math.PI / 180);
        this.field_78116_c.field_78796_g += yaw * ((float)Math.PI / 180);
    }
}

