/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.model;

import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.Tessellator;

public class ModelBoxCustomizable
extends ModelBox {
    public static final int SIDE_LEFT = 1;
    public static final int SIDE_RIGHT = 2;
    public static final int SIDE_TOP = 4;
    public static final int SIDE_BOTTOM = 8;
    public static final int SIDE_FRONT = 16;
    public static final int SIDE_BACK = 32;
    public static final int SIDE_ALL = 63;
    private PositionTextureVertex[] vertexPositions;
    private TexturedQuad[] quadList;
    private final float posX1;
    private final float posY1;
    private final float posZ1;
    private final float posX2;
    private final float posY2;
    private final float posZ2;
    private int visibleSides;

    public ModelBoxCustomizable(ModelRenderer model, int u, int v, float x1, float y1, float z1, int width, int height, int depth, float expand) {
        this(model, u, v, x1, y1, z1, width, height, depth, expand, 0);
    }

    public ModelBoxCustomizable(ModelRenderer model, int u, int v, float x1, float y1, float z1, int width, int height, int depth, float expand, int topVOffset) {
        super(model, u, v, x1, y1, z1, width, height, depth, expand);
        this.posX1 = x1;
        this.posY1 = y1;
        this.posZ1 = z1;
        this.posX2 = x1 + (float)width;
        this.posY2 = y1 + (float)height;
        this.posZ2 = z1 + (float)depth;
        this.vertexPositions = new PositionTextureVertex[8];
        this.quadList = new TexturedQuad[6];
        float x2 = x1 + (float)width;
        float y2 = y1 + (float)height;
        float z2 = z1 + (float)depth;
        x1 -= expand;
        y1 -= expand;
        z1 -= expand;
        x2 += expand;
        y2 += expand;
        z2 += expand;
        if (model.field_78809_i) {
            float x = x2;
            x2 = x1;
            x1 = x;
        }
        PositionTextureVertex v000 = new PositionTextureVertex(x1, y1, z1, 1.3563156E-19f, 1.3563156E-19f);
        PositionTextureVertex v100 = new PositionTextureVertex(x2, y1, z1, 1.3563264E-19f, 4.966073E28f);
        PositionTextureVertex v110 = new PositionTextureVertex(x2, y2, z1, 1.9364292E31f, 1.7032407E25f);
        PositionTextureVertex v010 = new PositionTextureVertex(x1, y2, z1, 1.9441665E31f, 1.9264504E-19f);
        PositionTextureVertex v001 = new PositionTextureVertex(x1, y1, z2, 4.076745E22f, 1.3563156E-19f);
        PositionTextureVertex v101 = new PositionTextureVertex(x2, y1, z2, 2.0113521E-19f, 3.0309808E24f);
        PositionTextureVertex v111 = new PositionTextureVertex(x2, y2, z2, 6.977187E22f, 1.88877E31f);
        PositionTextureVertex v011 = new PositionTextureVertex(x1, y2, z2, 1.0943429E31f, 2.0958594E-19f);
        this.vertexPositions[0] = v000;
        this.vertexPositions[1] = v100;
        this.vertexPositions[2] = v110;
        this.vertexPositions[3] = v010;
        this.vertexPositions[4] = v001;
        this.vertexPositions[5] = v101;
        this.vertexPositions[6] = v111;
        this.vertexPositions[7] = v011;
        this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{v101, v100, v110, v111}, u + depth + width, v + depth, u + depth + width + depth, v + depth + height, model.field_78801_a, model.field_78799_b);
        this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{v000, v001, v011, v010}, u, v + depth, u + depth, v + depth + height, model.field_78801_a, model.field_78799_b);
        this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{v101, v001, v000, v100}, u + depth, v + topVOffset, u + depth + width, v + depth + topVOffset, model.field_78801_a, model.field_78799_b);
        this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{v110, v010, v011, v111}, u + depth + width, v + depth + topVOffset, u + depth + width + width, v + topVOffset, model.field_78801_a, model.field_78799_b);
        this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{v100, v000, v010, v110}, u + depth, v + depth, u + depth + width, v + depth + height, model.field_78801_a, model.field_78799_b);
        this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{v001, v101, v111, v011}, u + depth + width + depth, v + depth, u + depth + width + depth + width, v + depth + height, model.field_78801_a, model.field_78799_b);
        if (model.field_78809_i) {
            for (int i = 0; i < this.quadList.length; ++i) {
                this.quadList[i].func_78235_a();
            }
        }
        this.setVisibleSides(63);
    }

    public void setVisibleSides(int visibleSides) {
        this.visibleSides = visibleSides & 0x3F;
    }

    public void func_78245_a(Tessellator tessellator, float scale) {
        for (int i = 0; i < this.quadList.length; ++i) {
            if ((this.visibleSides & 1 << i) == 0) continue;
            this.quadList[i].func_78236_a(tessellator, scale);
        }
    }
}

