/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.input;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.input.BLKey;
import thebetweenlands.client.input.KeyBindingBL;
import thebetweenlands.client.input.KeyBindingWrapper;
import thebetweenlands.client.perspective.Perspective;
import thebetweenlands.client.perspective.rowboat.PerspectiveWeedwoodRowboatFirstPerson;
import thebetweenlands.client.perspective.rowboat.PerspectiveWeedwoodRowboatThirdPerson;
import thebetweenlands.client.render.entity.RenderWeedwoodRowboat;
import thebetweenlands.entities.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.forgeevent.client.ClientAttackEvent;
import thebetweenlands.forgeevent.client.RenderEntitiesEvent;
import thebetweenlands.network.message.MessageWeedwoodRowboatInput;

public class WeedwoodRowboatHandler {
    public static final WeedwoodRowboatHandler INSTANCE = new WeedwoodRowboatHandler();
    public static final Perspective THIRD_PERSON_PERSPECTIVE = new PerspectiveWeedwoodRowboatThirdPerson();
    public static final Perspective FIRST_PERSON_PERSPECTIVE = new PerspectiveWeedwoodRowboatFirstPerson();
    private List<BLKey> keyBindings = new ArrayList<BLKey>();
    private BLKey oarStrokeLeft;
    private BLKey oarStrokeRight;
    private boolean isRenderingEntities;

    private WeedwoodRowboatHandler() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        this.oarStrokeLeft = this.createKeyBinding(settings.field_74370_x);
        this.oarStrokeRight = this.createKeyBinding(settings.field_74366_z);
    }

    private KeyBindingBL createKeyBinding(String desc, int keycode) {
        KeyBindingBL keyBinding = new KeyBindingBL("key.weedwoodRowboat." + desc, keycode, "key.categories.weedwoodRowboat");
        this.keyBindings.add(keyBinding);
        return keyBinding;
    }

    private KeyBindingWrapper createKeyBinding(KeyBinding keyBinding) {
        KeyBindingWrapper wrapper = new KeyBindingWrapper(keyBinding);
        this.keyBindings.add(wrapper);
        return wrapper;
    }

    public void init() {
        this.registerKeyBinding();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        Perspective.register(THIRD_PERSON_PERSPECTIVE);
        Perspective.register(FIRST_PERSON_PERSPECTIVE);
        FMLCommonHandler.instance().bus().register((Object)THIRD_PERSON_PERSPECTIVE);
    }

    private void registerKeyBinding() {
        for (BLKey keyBinding : this.keyBindings) {
            keyBinding.register();
        }
    }

    public boolean isPlayerInRowboat() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g == null ? false : mc.field_71439_g.field_70154_o instanceof EntityWeedwoodRowboat;
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        if (this.pollKeyInput()) {
            boolean oarStrokeLeft = this.oarStrokeLeft.isDown();
            boolean oarStrokeRight = this.oarStrokeRight.isDown();
            MessageWeedwoodRowboatInput packet = new MessageWeedwoodRowboatInput(oarStrokeLeft, oarStrokeRight);
            TheBetweenlands.networkWrapper.sendToServer((IMessage)packet);
        }
        for (BLKey keyBinding : this.keyBindings) {
            keyBinding.update();
        }
    }

    private boolean pollKeyInput() {
        boolean changed = false;
        for (BLKey keyBinding : this.keyBindings) {
            changed |= keyBinding.pollStateChange();
        }
        return changed;
    }

    @SubscribeEvent
    public void onRenderTickEvent(RenderEntitiesEvent.Pre event) {
        this.isRenderingEntities = true;
    }

    @SubscribeEvent
    public void onRenderTickEvent(RenderEntitiesEvent.Post event) {
        this.isRenderingEntities = false;
    }

    @SubscribeEvent
    public void onRenderLivingEvent(RenderLivingEvent.Pre event) {
        if (this.isRenderingEntities && event.entity.field_70154_o instanceof EntityWeedwoodRowboat && RenderWeedwoodRowboat.shouldPreventRidingRender) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerUseItemEventStart(PlayerUseItemEvent.Start event) {
        if (this.shouldPreventWorldInteraction()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.shouldPreventWorldInteraction()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEvent(ClientAttackEvent event) {
        if (this.shouldPreventWorldInteraction()) {
            event.setCanceled(true);
        }
    }

    public boolean shouldPreventWorldInteraction() {
        return this.isPlayerInRowboat() && THIRD_PERSON_PERSPECTIVE.isCurrentPerspective();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (player.field_70154_o instanceof EntityWeedwoodRowboat) {
            return;
        }
        Perspective perspective = Perspective.getCurrentPerspective();
        if (perspective == FIRST_PERSON_PERSPECTIVE || perspective == THIRD_PERSON_PERSPECTIVE) {
            Perspective.FIRST_PERSON.switchTo();
        }
    }
}

