/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.render.shader.MainShader;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.effect.PostProcessingEffect;
import thebetweenlands.client.render.shader.effect.StarfieldEffect;
import thebetweenlands.decay.DecayManager;
import thebetweenlands.entities.mobs.boss.IBossBL;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesCircleGem;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.event.debugging.DebugHandlerClient;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.utils.ItemRenderHelper;

@SideOnly(value=Side.CLIENT)
public class GuiOverlay
extends Gui {
    public static final GuiOverlay INSTANCE = new GuiOverlay();
    private ResourceLocation decayBarTexture = new ResourceLocation("thebetweenlands:textures/gui/decayBar.png");
    private ResourceLocation bossBarTexture = new ResourceLocation("thebetweenlands:textures/gui/bossHealthBar.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private Random random = new Random();
    private int updateCounter;
    private PostProcessingEffect de = null;
    private Framebuffer tb1 = null;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++this.updateCounter;
        }
    }

    @SubscribeEvent
    public void renderGui(RenderGameOverlayEvent.Post event) {
        MainShader shader;
        if (DebugHandlerClient.INSTANCE.debugPostProcessingEffect && event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && ShaderHelper.INSTANCE.canUseShaders() && (shader = ShaderHelper.INSTANCE.getCurrentShader()) != null) {
            if (this.tb1 == null) {
                this.tb1 = new Framebuffer(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, false);
                this.de = new StarfieldEffect(true).init();
            } else if (this.tb1.field_147621_c != Minecraft.func_71410_x().field_71443_c / 2 || this.tb1.field_147618_d != Minecraft.func_71410_x().field_71440_d / 2) {
                this.tb1.func_147608_a();
                this.tb1 = new Framebuffer(Minecraft.func_71410_x().field_71443_c / 2, Minecraft.func_71410_x().field_71440_d / 2, false);
            }
            ((StarfieldEffect)this.de).setTimeScale(3.0E-6f);
            this.de.create(shader.getBlitBuffer("starfieldBlitBuffer")).setSource(this.tb1.field_147617_g).setPreviousFBO(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(Minecraft.func_71410_x().field_71443_c / 2, Minecraft.func_71410_x().field_71440_d / 2).render();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)60.0, (double)0.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBindTexture((int)3553, (int)shader.getBlitBuffer((String)"starfieldBlitBuffer").field_147617_g);
            GL11.glBegin((int)4);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)0.0, (double)640.0);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)640.0, (double)640.0);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)640.0, (double)640.0);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex2d((double)640.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int width = event.resolution.func_78326_a();
            int height = event.resolution.func_78328_b();
            EquipmentInventory equipmentInventory = EquipmentInventory.getEquipmentInventory((Entity)this.mc.field_71439_g);
            int yOffset = 0;
            for (EnumEquipmentCategory category : EnumEquipmentCategory.TYPES) {
                float scale;
                EntityPropertiesCircleGem properties;
                List<Equipment> equipmentList = equipmentInventory.getEquipment(category);
                int posX = width / 2 - 20 + 113;
                int posY = height - 19 + yOffset;
                if (equipmentList.size() <= 0) continue;
                if (category == EnumEquipmentCategory.AMULET && (properties = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)this.mc.field_71439_g, EntityPropertiesCircleGem.class)) != null) {
                    for (int a = 0; a < properties.getAmuletSlots(); ++a) {
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        scale = 1.0f;
                        GL11.glScaled((double)scale, (double)scale, (double)scale);
                        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        ItemRenderHelper.drawItemStack(new ItemStack(BLItemRegistry.amulet), 0, 0, null, false);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                        posX += 8;
                    }
                }
                posX = width / 2 - 20 + 113;
                for (int a = 0; a < equipmentList.size(); ++a) {
                    Equipment equipment = equipmentList.get(a);
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)posX, (double)posY, (double)0.0);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    scale = 1.0f;
                    GL11.glScaled((double)scale, (double)scale, (double)scale);
                    ItemRenderHelper.drawItemStack(equipment.item, 0, 0, null, true);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                    posX += 8;
                }
                yOffset -= 13;
            }
            if (DecayManager.isDecayEnabled((EntityPlayer)this.mc.field_71439_g)) {
                Entity ridingEntity;
                int duration;
                int startX = width / 2 - 13 + 23;
                int startY = height - 49;
                if (this.mc.field_71439_g.getEntityData().func_74764_b("antivenomDuration") && (duration = this.mc.field_71439_g.getEntityData().func_74762_e("antivenomDuration")) > 0) {
                    startY -= 12;
                }
                if ((ridingEntity = this.mc.field_71439_g.field_70154_o) != null && ridingEntity instanceof EntityLivingBase) {
                    EntityLivingBase riddenEntity = (EntityLivingBase)ridingEntity;
                    int entityHealth = (int)Math.ceil(riddenEntity.func_110143_aJ());
                    float maxEntityHealth = riddenEntity.func_110138_aP();
                    int maxHealthHearts = (int)(maxEntityHealth + 0.5f) / 2;
                    if (maxHealthHearts > 30) {
                        maxHealthHearts = 30;
                    }
                    int guiOffsetY = 0;
                    int column = 0;
                    while (maxHealthHearts > 0) {
                        int renderedHearts = Math.min(maxHealthHearts, 10);
                        maxHealthHearts -= renderedHearts;
                        guiOffsetY -= 10;
                        column += 20;
                    }
                    startY += guiOffsetY + 10;
                }
                int decayLevel = DecayManager.getDecayLevel((EntityPlayer)this.mc.field_71439_g);
                this.mc.func_110434_K().func_110577_a(this.decayBarTexture);
                GL11.glEnable((int)3042);
                for (int i = 0; i < 10; ++i) {
                    int offsetY;
                    int n = offsetY = this.mc.field_71439_g.func_70055_a(Material.field_151586_h) ? -10 : 0;
                    if (this.updateCounter % (decayLevel * 3 + 1) == 0) {
                        offsetY += this.random.nextInt(3) - 1;
                    }
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(startX + 71 - i * 8, startY + offsetY, 18, 0, 9, 9);
                    if (i * 2 + 1 < decayLevel) {
                        this.func_73729_b(startX + 71 - i * 8, startY + offsetY, 0, 0, 9, 9);
                    }
                    if (i * 2 + 1 != decayLevel) continue;
                    this.func_73729_b(startX + 72 - i * 8, startY + offsetY, 9, 0, 9, 9);
                }
            }
        } else if (event.type == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            Entity boss = null;
            for (Entity entity : this.mc.field_71441_e.field_72996_f) {
                if (!(entity instanceof IBossBL) || boss != null && !(entity.func_70032_d((Entity)this.mc.field_71439_g) < boss.func_70032_d((Entity)this.mc.field_71439_g))) continue;
                boss = entity;
            }
            if (boss != null) {
                float maxHealth = ((IBossBL)boss).getMaxBossHealth();
                float health = ((IBossBL)boss).getBossHealth();
                IChatComponent name = ((IBossBL)boss).getBossName();
                this.mc.func_110434_K().func_110577_a(this.bossBarTexture);
                int texWidth = 256;
                int texHeight = 16;
                double renderWidth = 250.0;
                double renderHeight = (double)texHeight / (double)texWidth * renderWidth;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glPushMatrix();
                GL11.glTranslated((double)((double)(event.resolution.func_78326_a() / 2) - renderWidth / 2.0), (double)10.0, (double)0.0);
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex2d((double)0.0, (double)0.0);
                GL11.glTexCoord2f((float)0.0f, (float)0.5f);
                GL11.glVertex2d((double)0.0, (double)renderHeight);
                GL11.glTexCoord2f((float)1.0f, (float)0.5f);
                GL11.glVertex2d((double)renderWidth, (double)renderHeight);
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glVertex2d((double)renderWidth, (double)0.0);
                GL11.glTexCoord2f((float)0.0f, (float)0.5f);
                GL11.glVertex2d((double)0.0, (double)0.0);
                GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                GL11.glVertex2d((double)0.0, (double)renderHeight);
                GL11.glTexCoord2f((float)(16.0f / (float)texWidth + (1.0f - 16.0f / (float)texWidth) / maxHealth * health), (float)1.0f);
                GL11.glVertex2d((double)(renderWidth - (renderWidth - (double)(16.0f / (float)texWidth) * renderWidth - (renderWidth - (double)(16.0f / (float)texWidth) * renderWidth) / (double)maxHealth * (double)health)), (double)renderHeight);
                GL11.glTexCoord2f((float)(16.0f / (float)texWidth + (1.0f - 16.0f / (float)texWidth) / maxHealth * health), (float)0.5f);
                GL11.glVertex2d((double)(renderWidth - (renderWidth - (double)(16.0f / (float)texWidth) * renderWidth - (renderWidth - (double)(16.0f / (float)texWidth) * renderWidth) / (double)maxHealth * (double)health)), (double)0.0);
                GL11.glEnd();
                GL11.glPopMatrix();
                int strWidth = TheBetweenlands.proxy.getCustomFontRenderer().func_78256_a(name.func_150254_d());
                TheBetweenlands.proxy.getCustomFontRenderer().func_78276_b(name.func_150254_d(), event.resolution.func_78326_a() / 2 - strWidth / 2, 13, -1);
            }
        }
    }
}

