/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;
import thebetweenlands.client.gui.GuiSmallButton;
import thebetweenlands.client.gui.GuiUpgradedTextField;
import thebetweenlands.event.debugging.DebugHandlerClient;

public class GuiDebugMenu
extends GuiScreen {
    private static final ResourceLocation[] PANORAMA_PATHS = new ResourceLocation[6];
    private DynamicTexture panoramaTexture;
    private ResourceLocation panoramaResourceLocation;
    private GuiUpgradedTextField worldSeedTextField;
    private int panoramaTimer;
    private int nextButtonId;
    private int nextButtonY;
    private GuiButton joinDebugWorldButton;
    private GuiButton deleteDebugWorldButton;
    private GuiButton returnButton;

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.nextButtonId = 0;
        this.nextButtonY = this.field_146295_m / 4 + 48;
        this.panoramaTexture = new DynamicTexture(256, 256);
        this.panoramaResourceLocation = this.field_146297_k.func_110434_K().func_110578_a("debug-background", this.panoramaTexture);
        int x = this.field_146294_l / 2 - 100;
        int y = this.nextButtonY();
        this.joinDebugWorldButton = new GuiButton(this.nextButtonId(), x, y, 138, 20, "Enter The Betweenlands");
        this.field_146292_n.add(this.joinDebugWorldButton);
        this.worldSeedTextField = new GuiUpgradedTextField(this.field_146289_q, x + 140, y + 1, 59, 18);
        this.worldSeedTextField.setPlaceholder("Seed");
        String saveFolder = DebugHandlerClient.INSTANCE.worldFolderName;
        ISaveFormat saveLoader = this.field_146297_k.func_71359_d();
        String seed = null;
        if (DebugHandlerClient.INSTANCE.isInDebugWorld) {
            seed = String.valueOf(MinecraftServer.func_71276_C().field_71305_c[0].func_72912_H().func_76063_b());
        } else if (saveLoader.func_90033_f(saveFolder)) {
            ISaveHandler saveHandler = saveLoader.func_75804_a(saveFolder, false);
            seed = String.valueOf(saveHandler.func_75757_d().func_76063_b());
        }
        if (seed != null) {
            this.worldSeedTextField.func_146180_a(seed);
            this.worldSeedTextField.func_146196_d();
            this.deleteDebugWorldButton = new GuiSmallButton(this.nextButtonId(), x + 201, y, 20, 0);
            this.field_146292_n.add(this.deleteDebugWorldButton);
        }
        this.returnButton = new GuiButton(this.nextButtonId(), this.field_146294_l / 2 - 100, this.field_146295_m - 28, "Return");
        this.field_146292_n.add(this.returnButton);
    }

    private void addButton(String label) {
        this.field_146292_n.add(new GuiButton(this.nextButtonId(), this.field_146294_l / 2 - 100, this.nextButtonY(), label));
    }

    private int nextButtonId() {
        return this.nextButtonId++;
    }

    private int nextButtonY() {
        int nextButtonY = this.nextButtonY;
        this.nextButtonY += 24;
        return nextButtonY;
    }

    public void func_73876_c() {
        ++this.panoramaTimer;
        this.worldSeedTextField.func_146178_a();
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.joinDebugWorldButton) {
            this.joinDebugWorld();
        } else if (button == this.deleteDebugWorldButton) {
            this.deleteDebugWorld();
        } else if (button == this.returnButton) {
            this.field_146297_k.func_147108_a(DebugHandlerClient.INSTANCE.previousGuiScreen);
        }
    }

    private long getSeed() {
        String seedString = this.worldSeedTextField.func_146179_b();
        if (!MathHelper.func_76139_a((String)seedString)) {
            try {
                return Long.parseLong(seedString);
            }
            catch (NumberFormatException numberformatexception) {
                return seedString.hashCode();
            }
        }
        return new Random().nextLong();
    }

    private void joinDebugWorld() {
        String saveFolder = DebugHandlerClient.INSTANCE.worldFolderName;
        ISaveFormat saveLoader = this.field_146297_k.func_71359_d();
        ISaveHandler saveHandler = saveLoader.func_75804_a(saveFolder, false);
        WorldInfo existingWorldInfo = saveHandler.func_75757_d();
        WorldSettings worldSettings = null;
        long seed = this.getSeed();
        boolean newWorld = false;
        if (existingWorldInfo == null) {
            newWorld = true;
        } else if (existingWorldInfo.func_76063_b() != seed || existingWorldInfo.func_76067_t() != WorldType.field_77137_b) {
            saveLoader.func_75800_d();
            saveLoader.func_75802_e(saveFolder);
            newWorld = true;
        }
        if (newWorld) {
            worldSettings = new WorldSettings(seed, WorldSettings.GameType.CREATIVE, true, false, WorldType.field_77137_b);
            worldSettings.func_77166_b();
        }
        this.field_146297_k.func_71371_a(saveFolder, DebugHandlerClient.INSTANCE.worldName, worldSettings);
        DebugHandlerClient.INSTANCE.isInDebugWorld = true;
    }

    private void deleteDebugWorld() {
        if (DebugHandlerClient.INSTANCE.isInDebugWorld) {
            this.field_146297_k.func_71403_a(null);
        }
        String saveFolder = DebugHandlerClient.INSTANCE.worldFolderName;
        ISaveFormat saveLoader = this.field_146297_k.func_71359_d();
        if (saveLoader.func_90033_f(saveFolder)) {
            saveLoader.func_75800_d();
            saveLoader.func_75802_e(saveFolder);
        }
        this.field_146292_n.remove(this.deleteDebugWorldButton);
    }

    protected void func_73869_a(char character, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_71381_h();
            this.field_146297_k.func_147108_a(DebugHandlerClient.INSTANCE.previousGuiScreen);
        } else {
            this.worldSeedTextField.func_146201_a(character, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.worldSeedTextField.func_146192_a(mouseX, mouseY, button);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialRenderTicks) {
        GL11.glDisable((int)3008);
        this.renderSkybox(mouseX, mouseY, partialRenderTicks);
        GL11.glEnable((int)3008);
        Tessellator tessellator = Tessellator.field_78398_a;
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0x40FFFFFF, 0xFFFFFF);
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0, Integer.MIN_VALUE);
        this.func_73732_a(this.field_146289_q, "The Betweenlands Debug", this.field_146294_l / 2, 10, -1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78378_d(-1);
        this.worldSeedTextField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialRenderTicks);
    }

    private void drawPanorama(int mouseX, int mouseY, float partialRenderTicks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        int resolution = 8;
        for (int pass = 0; pass < resolution * resolution; ++pass) {
            GL11.glPushMatrix();
            float offsetX = ((float)(pass % resolution) / (float)resolution - 0.5f) / 64.0f;
            float offsetY = ((float)(pass / resolution) / (float)resolution - 0.5f) / 64.0f;
            GL11.glTranslatef((float)offsetX, (float)offsetY, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)(((float)this.panoramaTimer + partialRenderTicks) / 400.0f)) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)this.panoramaTimer + partialRenderTicks) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int side = 0; side < 6; ++side) {
                GL11.glPushMatrix();
                if (side == 1) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (side == 2) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (side == 3) {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (side == 4) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                } else if (side == 5) {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                this.field_146297_k.func_110434_K().func_110577_a(PANORAMA_PATHS[side]);
                tessellator.func_78382_b();
                tessellator.func_78384_a(0xFFFFFF, 255 / (pass + 1));
                tessellator.func_78374_a(-1.0, -1.0, 1.0, 0.0, 0.0);
                tessellator.func_78374_a(1.0, -1.0, 1.0, 1.0, 0.0);
                tessellator.func_78374_a(1.0, 1.0, 1.0, 1.0, 1.0);
                tessellator.func_78374_a(-1.0, 1.0, 1.0, 0.0, 1.0);
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
    }

    private void rotateAndBlurSkybox(float partialRenderTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(this.panoramaResourceLocation);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GL11.glDisable((int)3008);
        int blurLevel = 3;
        for (int stage = 0; stage < blurLevel; ++stage) {
            tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f / (float)(stage + 1));
            int x = this.field_146294_l;
            int y = this.field_146295_m;
            float offset = (float)(stage - blurLevel / 2) / 256.0f;
            tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, (double)(0.0f + offset), 1.0);
            tessellator.func_78374_a((double)x, 0.0, (double)this.field_73735_i, (double)(1.0f + offset), 1.0);
            tessellator.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(1.0f + offset), 0.0);
            tessellator.func_78374_a(0.0, (double)y, (double)this.field_73735_i, (double)(0.0f + offset), 0.0);
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)3008);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void renderSkybox(int mouseX, int mouseY, float partialRenderTicks) {
        this.field_146297_k.func_147110_a().func_147609_e();
        GL11.glViewport((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(mouseX, mouseY, partialRenderTicks);
        this.rotateAndBlurSkybox(partialRenderTicks);
        this.rotateAndBlurSkybox(partialRenderTicks);
        this.rotateAndBlurSkybox(partialRenderTicks);
        this.rotateAndBlurSkybox(partialRenderTicks);
        this.rotateAndBlurSkybox(partialRenderTicks);
        this.rotateAndBlurSkybox(partialRenderTicks);
        this.rotateAndBlurSkybox(partialRenderTicks);
        this.field_146297_k.func_147110_a().func_147610_a(true);
        GL11.glViewport((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        float scale = this.field_146294_l > this.field_146295_m ? 120.0f / (float)this.field_146294_l : 120.0f / (float)this.field_146295_m;
        float u = (float)this.field_146295_m * scale / 256.0f;
        float v = (float)this.field_146294_l * scale / 256.0f;
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        int x = this.field_146294_l;
        int y = this.field_146295_m;
        tessellator.func_78374_a(0.0, (double)y, (double)this.field_73735_i, (double)(0.5f - u), (double)(0.5f + v));
        tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, (double)(0.5f - u), (double)(0.5f - v));
        tessellator.func_78374_a((double)x, 0.0, (double)this.field_73735_i, (double)(0.5f + u), (double)(0.5f - v));
        tessellator.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(0.5f + u), (double)(0.5f + v));
        tessellator.func_78381_a();
    }

    static {
        for (int i = 0; i < PANORAMA_PATHS.length; ++i) {
            GuiDebugMenu.PANORAMA_PATHS[i] = new ResourceLocation("thebetweenlands", String.format("textures/gui/debug/background/panorama_%s.png", i));
        }
    }
}

